/************************************************************************/
/*									*/
/*		xrefmenu.c						*/
/*									*/
/*	Menu handling routines for XREF package 			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "xref_local.h"





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define REFS_PER_LINE	10





/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


typedef struct _NAME_DATA {
   Character name[256];
   Character file[256];
   Character type[256];
   Integer count;
} NAME_DATA;






/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	int		xref_system_btn();
static	int		ref_btn();
static	void		ref_filter();
static	int		def_btn();
static	void		def_filter();
static	int		fct_btn();
static	void		fct_filter();
static	int		call_btn();
static	void		call_filter();
static	int		quit_btn();
static	void		fix_file_name();
static	void		output_string();
static	void		fix_string();





/************************************************************************/
/*									*/
/*	Tables								*/
/*									*/
/************************************************************************/


static STEM_PDM_DATA	xref_menus[] = {
   { STEM_PSTATE_MENU,	"Xref",         NULL },
   { STEM_PSTATE_BTN,	"Reference",    ref_btn },
   { STEM_PSTATE_BTN,	"Definition",   def_btn },
   { STEM_PSTATE_BTN,	"Function",     fct_btn },
   { STEM_PSTATE_BTN,	"Call",         call_btn },
   { STEM_PSTATE_BTN,	"Set System",   xref_system_btn },
   { STEM_PSTATE_BTN,	"Reload System",xref_system_btn },
   { STEM_PSTATE_BTN,	"Quit",         quit_btn },

   { STEM_PSTATE_END }
};





/************************************************************************/
/*									*/
/*	XREF_menu_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
XREF_menu_init()
{
};





/************************************************************************/
/*									*/
/*	XREF_menu_setup -- setup menu for window			*/
/*									*/
/************************************************************************/


void
XREF_menu_setup(xw)
   XREF_WIN xw;
{
   if (xw->menu_win == NULL) return;

   STEMpdm_define(xw->menu_win,xw,xref_menus);
};





/************************************************************************/
/*									*/
/*	XREF_menu_system -- get system name				*/
/*									*/
/************************************************************************/


Boolean
XREF_menu_system(xw)
   XREF_WIN xw;
{
   Character menu[10240],line[1024];
   Character sys[64];
   Integer wdfg;
   String s,rsy[32+2],fsy[16];
   Integer i,j,ct,sct;

   strcpy(menu,"%CSystem to Cross Reference\n\n");

   sct = FIELDinq_systems(16,fsy);
   if (sct == 1 && xw->data == NULL) {
      xw->data = XREF_set_system(fsy[0],TRUE);
      return TRUE;
    };

   if (xw->data != NULL && xw->data->system != NULL) {
      sprintf(line,"%%1.0o %s\n",xw->data->system);
      strcat(menu,line);
    };

   if (xw->data == NULL || STREQL(xw->data->system,".")) wdfg = 1;
   else wdfg = 0;

   rsy[0] = (xw->data == NULL ? NULL : xw->data->system);
   rsy[1] = ".";
   ct = 2+XREF_inq_systems(16,&rsy[2]);

   for (i = 2; i < ct; ++i) {
      if (STREQL(rsy[i],".")) continue;
      if (xw->data != NULL && xw->data->system != NULL && STREQL(xw->data->system,rsy[i]))
	 continue;
      sprintf(line,"%%1.%do %s\n",i,rsy[i]);
      strcat(menu,line);
    };

   for (i = ct; i < ct+sct; ++i) {
      rsy[i] = fsy[i-ct];
      for (j = 0; j < i; ++j) {
	 if (rsy[j] != NULL && STREQL(rsy[i],rsy[j])) break;
       };
      if (j < i) continue;
      if (xw->data != NULL && STREQL(xw->data->system,rsy[i])) wdfg = i;
      sprintf(line,"%%1.%do %s\n",i,rsy[i]);
      strcat(menu,line);
    };

   strcat(menu,"%1.1o Current working directory\n");

   strcat(menu,"\nName: %0.48t\n\n");

   strcat(menu,"   %a%M   %c\n");

   sys[0] = 0;

   if (!STEMdialog1(xw->window,menu,sys,&wdfg)) return FALSE;

   fix_string(sys);

   if (sys[0] == 0) s = rsy[wdfg];
   else s = sys;

   if (s == NULL || xw->data != NULL && STREQL(s,xw->data->system)) return FALSE;

   xw->data = XREF_set_system(s,TRUE);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	xref_system_btn -- handle Set System and Reload buttons 	*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
xref_system_btn(xw,menu,btn)
   XREF_WIN xw;
   String menu;
   String btn;
{
   if (xw->data != NULL && xw->data->system != NULL &&
	  xw->data->cmd_file != NULL && STRNEQ(btn,"Set System")) {
      XREF_load_system(xw->data);
    }
   else {
      XREF_menu_system(xw);
    };

   return TRUE;
};





/************************************************************************/
/*									*/
/*	ref_btn -- handle reference query				*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
ref_btn(xw,mnm,btn)
   XREF_WIN xw;
   String mnm;
   String btn;
{
   String menu[20];
   Integer ct;
   Character nam[64],fil[64],lin[32];
   Integer line,asgmt;
   Character sel[256];
   NAME_DATA *nd;

   ct = 0;
   menu[ct++] = "%CReference Query\n";
   menu[ct++] = "Name: %0.32t";
   menu[ct++] = "File: %1.32t";
   menu[ct++] = "Line: %2.8t";
   menu[ct++] = "%3o Assignments Only";
   menu[ct++] = "\n   %a%M   %c";
   menu[ct] = 0;

   FIELDinq_selection(nam);
   fil[0] = 0;
   lin[0] = 0;
   asgmt = FALSE;

   if (!STEMdialog(xw->window,menu,nam,fil,lin,&asgmt)) return FALSE;

   fix_string(nam);
   fix_string(fil);
   fix_string(lin);

   line = atol(lin);
   sel[0] = 0;

   if (nam[0] != 0) {
      strcat(sel,"R.name ~= `");
      strcat(sel,nam);
    };

   if (fil[0] != 0) {
      if (sel[0] != 0) strcat(sel," & ");
      strcat(sel,"R.file == `");
      strcat(sel,fil);
    };

   if (line > 0) {
      sprintf(lin,"%d",line);
      if (sel[0] != 0) strcat(sel," & ");
      strcat(sel,"R.line == `");
      strcat(sel,lin);
    };

   if (asgmt) {
      if (sel[0] != 0) strcat(sel," & ");
      strcat(sel,"R.assign == `True");
    };

   nd = PALLOC(NAME_DATA);
   nd->name[0] = 0;
   nd->file[0] = 0;
   nd->count = 0;

   XREF_run_query(xw,"R.name,R.file,R.line,R.assign",sel,ref_filter,nd);

   return TRUE;
};




/*ARGSUSED*/

static void
ref_filter(xw,buf,nd)
   XREF_WIN xw;
   String buf;
   NAME_DATA * nd;
{
   Character name[256],file[256],fg[16];
   Integer line,asg;

   if (buf == NULL) {
      if (nd->count > 0) XREF_output(xw,"\n");
      free(nd);
      return;
    };

   sscanf(buf,"%[^\177]\177%[^\177]\177%d\177%[^\177]",name,file,&line,fg);
   asg = (fg[0] == 'T');

   fix_file_name(file);

   if (STREQL(name,nd->name)) name[0] = 0;
   else strcpy(nd->name,name);

   if (name[0] == 0 && STREQL(file,nd->file)) file[0] = 0;
   else strcpy(nd->file,file);

   if (nd->count > 0 && (name[0] != 0 || file[0] != 0 ||
			    nd->count == REFS_PER_LINE)) {
      XREF_output(xw,"\n");
      nd->count = 0;
    };

   if (nd->count == 0) {
      output_string(xw,name,12);
      output_string(xw,file,12);
    };

   if (asg) XREF_output(xw,"%d* ",line);
   else XREF_output(xw,"%d ",line);
   ++nd->count;
};




/************************************************************************/
/*									*/
/*	def_btn -- handle definition query				*/
/*									*/
/************************************************************************/


static String decl_class_names[] = {
   "NONE",
   "STATIC",
   "EXTERN",
   "AUTO",
   "REGISTER",
   "TYPEDEF",
   "PARAM",
   "FIELD",
   "EFUNCTION",
   "SFUNCTION",
   "STRUCTID",
   "UNIONID",
   "ENUMID",
   "CONST",
   "EXTDEF",
   "CLASSID",
   "MACRO",
};


/*ARGSUSED*/

static int
def_btn(xw,mnm,btn)
   XREF_WIN xw;
   String mnm;
   String btn;
{
   String menu[40];
   Integer ct;
   Character nam[64],fil[64],lin[32],typ[64];
   Integer line,class;
   Character sel[256];

   ct = 0;
   menu[ct++] = "%CDeclaration Query\n";
   menu[ct++] = "Name: %0.32t";
   menu[ct++] = "File: %1.32t";
   menu[ct++] = "Line: %2.8t";
   menu[ct++] = "Type: %3.32t";
   menu[ct++] = "\nClass:";
   menu[ct++] = "%4.0o Any%M%4.1o Static";
   menu[ct++] = "%4.2o Extern%M%4.3o Automatic";
   menu[ct++] = "%4.4o Register%M%4.5o Typedef";
   menu[ct++] = "%4.6o Parameter%M%4.7o Field";
   menu[ct++] = "%4.8o External Function%M%4.9o Static Function";
   menu[ct++] = "%4.10o Structure Name%M%4.11o Union Name";
   menu[ct++] = "%4.12o Enumeration Name%M%4.13o Enumeration Constant";
   menu[ct++] = "%4.14o External Definition%M%4.15o Class Name";
   menu[ct++] = "%4.16o Macro Definition";
   menu[ct++] = "\n   %a%M   %c";
   menu[ct] = 0;

   FIELDinq_selection(nam);
   fil[0] = 0;
   lin[0] = 0;
   typ[0] = 0;
   class = 0;

   if (!STEMdialog(xw->window,menu,nam,fil,lin,typ,&class)) return FALSE;

   fix_string(nam);
   fix_string(fil);
   fix_string(lin);
   fix_string(typ);

   line = atol(lin);
   sel[0] = 0;

   if (nam[0] != 0) {
      strcat(sel,"D.name ~= `");
      strcat(sel,nam);
    };

   if (fil[0] != 0) {
      if (sel[0] != 0) strcat(sel," & ");
      strcat(sel,"D.file == `");
      strcat(sel,fil);
    };

   if (line > 0) {
      sprintf(lin,"%d",line);
      if (sel[0] != 0) strcat(sel," & ");
      strcat(sel,"D.line == `");
      strcat(sel,lin);
    };

   if (typ[0] != 0) {
      if (sel[0] != 0) strcat(sel," & ");
      strcat(sel,"D.type ~= `");
      strcat(sel,typ);
    };

   if (class != 0) {
      if (sel[0] != 0) strcat(sel," & ");
      strcat(sel,"D.class == `");
      strcat(sel,decl_class_names[class]);
    };

   XREF_run_query(xw,"D.name,D.file,D.line,D.class,D.type",sel,def_filter,NULL);

   return TRUE;
};




/*ARGSUSED*/

static void
def_filter(xw,buf,d)
   XREF_WIN xw;
   String buf;
   Universal d;
{
   Character name[256],file[256],type[256],class[32];
   Character lbf[16];
   Integer line;

   if (buf == NULL) return;

   type[0] = 0;
   sscanf(buf,"%[^\177]\177%[^\177]\177%d\177%[^\177]\177%[^\177]",name,file,&line,class,type);

   fix_file_name(file);

   output_string(xw,name,12);
   output_string(xw,file,12);

   sprintf(lbf,"%d",line);
   output_string(xw,lbf,6);

   output_string(xw,class,12);
   output_string(xw,type,0);
   XREF_output(xw,"\n");
};





/************************************************************************/
/*									*/
/*	fct_btn -- handle function query				*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
fct_btn(xw,mnm,btn)
   XREF_WIN xw;
   String mnm;
   String btn;
{
   String menu[20];
   Integer ct;
   Character nam[64],fil[64],lin[32];
   Integer line;
   Character sel[256];

   ct = 0;
   menu[ct++] = "%CFunction Query\n";
   menu[ct++] = "Name: %0.32t";
   menu[ct++] = "File: %1.32t";
   menu[ct++] = "Line: %2.8t";
   menu[ct++] = "\n   %a%M   %c";
   menu[ct] = 0;

   FIELDinq_selection(nam);
   fil[0] = 0;
   lin[0] = 0;

   if (!STEMdialog(xw->window,menu,nam,fil,lin)) return FALSE;

   fix_string(nam);
   fix_string(fil);
   fix_string(lin);

   line = atol(lin);
   sel[0] = 0;

   if (nam[0] != 0) {
      strcat(sel,"F.name ~= `");
      strcat(sel,nam);
    };

   if (fil[0] != 0) {
      if (sel[0] != 0) strcat(sel," & ");
      strcat(sel,"F.file == `");
      strcat(sel,fil);
    };

   if (line > 0) {
      sprintf(lin,"%d",line);
      if (sel[0] != 0) strcat(sel," & ");
      strcat(sel,"F.line == `");
      strcat(sel,lin);
    };

   XREF_run_query(xw,"F.name,F.file,F.line,F.args",sel,fct_filter,NULL);

   return TRUE;
};




/*ARGSUSED*/

static void
fct_filter(xw,buf,d)
   XREF_WIN xw;
   String buf;
   Universal d;
{
   Character name[256],file[256],args[256];
   Character lbf[16];
   Integer line;

   if (buf == NULL) return;

   args[0] = 0;
   sscanf(buf,"%[^\177]\177%[^\177]\177%d\177%[^\177]",name,file,&line,args);

   fix_file_name(file);

   output_string(xw,name,12);
   output_string(xw,file,12);

   sprintf(lbf,"%d",line);
   output_string(xw,lbf,6);

   output_string(xw,args,0);

   XREF_output(xw,"\n");
};




/************************************************************************/
/*									*/
/*	call_btn -- handle call query					*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
call_btn(xw,mnm,btn)
   XREF_WIN xw;
   String mnm;
   String btn;
{
   String menu[20];
   Integer ct;
   Character nam[64],fil[64],lin[32],from[64];
   Integer line;
   Character sel[256];

   ct = 0;
   menu[ct++] = "%CCall Query\n";
   menu[ct++] = "Call Name: %0.32t";
   menu[ct++] = "From Name: %3.32t";
   menu[ct++] = "File: %1.32t";
   menu[ct++] = "Line: %2.8t";
   menu[ct++] = "\n   %a%M   %c";
   menu[ct] = 0;

   FIELDinq_selection(nam);
   fil[0] = 0;
   lin[0] = 0;
   from[0] = 0;

   if (!STEMdialog(xw->window,menu,nam,fil,lin,from)) return FALSE;

   fix_string(nam);
   fix_string(fil);
   fix_string(lin);
   fix_string(from);

   line = atol(lin);
   sel[0] = 0;

   if (nam[0] != 0) {
      strcat(sel,"C.call ~= `");
      strcat(sel,nam);
    };

   if (from[0] != 0) {
      if (sel[0] != 0) strcat(sel," & ");
      strcat(sel,"C.from ~= `");
      strcat(sel,from);
    };

   if (fil[0] != 0) {
      if (sel[0] != 0) strcat(sel," & ");
      strcat(sel,"C.file == `");
      strcat(sel,fil);
    };

   if (line > 0) {
      sprintf(lin,"%d",line);
      if (sel[0] != 0) strcat(sel," & ");
      strcat(sel,"C.line == `");
      strcat(sel,lin);
    };

   XREF_run_query(xw,"C.call,C.from,C.file,C.line",sel,call_filter,NULL);

   return TRUE;
};




/*ARGSUSED*/

static void
call_filter(xw,buf,d)
   XREF_WIN xw;
   String buf;
   Universal d;
{
   Character name[256],file[256],from[256];
   Character lbf[16];
   Integer line;

   if (buf == NULL) return;

   sscanf(buf,"%[^\177]\177%[^\177]\177%[^\177]\177%d",name,from,file,&line);

   fix_file_name(file);

   output_string(xw,name,12);
   output_string(xw,from,12);
   output_string(xw,file,12);

   sprintf(lbf,"%d",line);
   output_string(xw,lbf,6);

   XREF_output(xw,"\n");
};




/************************************************************************/
/*									*/
/*	quit_btn -- handle QUIT command 				*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
quit_btn(xw,menu,btn)
   XREF_WIN xw;
   String menu;
   String btn;
{
   ASHremove(xw->window);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	fix_file_name -- fix up a file name				*/
/*									*/
/************************************************************************/


static void
fix_file_name(buf)
   String buf;
{
   Character tbuf[1024];
   String s;
   Integer ln;

   s = MSGinq_wd();
   ln = strlen(s);

   if (strncmp(s,buf,ln) == 0) {
      strcpy(tbuf,buf);
      s = &buf[ln];
      if (*s == '/') ++s;
      strcpy(buf,s);
    };
};






/************************************************************************/
/*									*/
/*	output_string -- output and space for string			*/
/*									*/
/************************************************************************/


static void
output_string(xw,txt,size)
   XREF_WIN xw;
   String txt;
   Integer size;
{
   Integer i;

   if (txt != NULL && txt[0] != 0) {
      XREF_output(xw,"%s",txt);
      i = strlen(txt);
    }
   else i = 0;

   while (i < size) {
      XREF_output(xw," ");
      ++i;
    };
   XREF_output(xw," ");
};





/************************************************************************/
/*									*/
/*	fix_string -- fix up dialog box returned string 		*/
/*									*/
/************************************************************************/


static void
fix_string(buf)
   String buf;
{
   String s;

   for (s = buf; *s == ' '; ++s);
   if (*s == 0) *buf = 0;
};





/* end of xrefmenu.c */


