/************************************************************************/
/*									*/
/*		xrefmain.c						*/
/*									*/
/*	General routines for cross-reference viewing			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "xref_local.h"





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/


static	Boolean 	xref_inited = FALSE;
	PROT_DECL;




/************************************************************************/
/*									*/
/*	XREFinit -- package initialization				*/
/*									*/
/************************************************************************/


void
XREFinit()
{
   PROT_INIT;
   PROTECT;
   if (!xref_inited) {
      xref_inited = TRUE;
      MSGinit(FALSE);
      XREF_win_init();
      XREF_menu_init();
      XREF_edit_init();
      XREF_run_init();
      XREF_msg_init();
      MSGservice_register("XREF");
    };
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	XREFnew_wm_window -- create a new window from window manager	*/
/*									*/
/************************************************************************/


int
XREFnew_wm_window(w)
   ASH_WINDOW w;
{
   return XREFnew_window(w,NULLSTRING);
};





/************************************************************************/
/*									*/
/*	XREFnew_window -- create a new building window of given type	*/
/*									*/
/************************************************************************/


int
XREFnew_window(w,sys)
   ASH_WINDOW w;
   String sys;
{
   XREF_WIN xw;

   XREFinit();

   xw = XREF_create(w,sys);

   return (xw != NULL);
};





/* end of xrefmain.c */
