/************************************************************************/
/*									*/
/*		xrefedit.c						*/
/*									*/
/*	Editor interface for Xref interface				*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "xref_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	int		xref_mouse();




/************************************************************************/
/*									*/
/*	XREF_edit_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
XREF_edit_init()
{
};





/************************************************************************/
/*									*/
/*	XREF_edit_setup -- setup editor 			       */
/*									*/
/************************************************************************/


void
XREF_edit_setup(xw)
   XREF_WIN xw;
{
   register EDT_DATA ed;
   register EDT_ID ei;

   if (xw->disp_win == NULL) return;

   ed = PALLOC(EDT_DATA_INFO);
   ed->readonly = FALSE;
   ed->create = FALSE;
   ed->temporary = TRUE;
   ed->scroll = TRUE;
   ed->raw = FALSE;
   ed->echo = FALSE;
   ed->savectl = FALSE;
   ed->mode = "SCRIPT";
   ed->bounds_rtn = NULL;
   ed->input_rtn = NULL;
   ed->mouse_rtn = xref_mouse;
   ed->file_rtn = NULL;
   ed->input_filter = NULL;
   ed->output_filter = NULL;

   ei = EDTdefine_editor(xw->disp_win,NULL,ed,xw,xw->menu_win,NULL);
   EDTenable(ei,FALSE);

   xw->edit_info = ei;
};





/************************************************************************/
/*									*/
/*	XREF_output_begin -- start output from query			*/
/*	XREF_output -- output string from query 			*/
/*	XREF_output_done -- finish output from query			*/
/*									*/
/************************************************************************/


void
XREF_output_begin(xw)
   XREF_WIN xw;
{
   if (xw->skip_fg || xw->edit_info == NULL) return;

   if (xw->clear_fg) {
      EDTenable(xw->edit_info,TRUE);
      EDTtruncate_at(xw->edit_info,1);
      EDTenable(xw->edit_info,FALSE);
    };

   xw->outline[0] = 0;
};




/* VARARGS2 */

void
XREF_output(xw,pat,a1,a2,a3,a4)
   XREF_WIN xw;
   String pat;
   Universal a1,a2,a3,a4;
{
   Character buf[1024];

   if (xw->skip_fg || xw->edit_info == NULL) return;

   sprintf(buf,pat,a1,a2,a3,a4);

   if (strlen(buf) + strlen(xw->outline) >= BUF_SIZE) {
      EDTenable(xw->edit_info,TRUE);
      EDTshell_output(xw->edit_info,xw->outline);
      xw->outline[0] = 0;
      if (strlen(buf) >= BUF_SIZE) {
	 EDTshell_output(xw->edit_info,buf);
	 buf[0] = 0;
       };
      EDTenable(xw->edit_info,FALSE);
    };

   strcat(xw->outline,buf);

   printf("%s",buf);
};




void
XREF_output_done(xw)
   XREF_WIN xw;
{
   if (xw->skip_fg || xw->edit_info == NULL) return;

   EDTenable(xw->edit_info,TRUE);

   if (xw->outline[0] != 0) EDTshell_output(xw->edit_info,xw->outline);

   if (!xw->clear_fg) {
      EDTshell_output(xw->edit_info,"\n");
      EDTshell_output(xw->edit_info,SEPARATOR);
      EDTshell_output(xw->edit_info,"\n\n");
    };

   EDTenable(xw->edit_info,FALSE);

   printf("\n%s\n\n",SEPARATOR);
};





/************************************************************************/
/*									*/
/*	XREF_edit_show -- show information gathered from editor click	*/
/*									*/
/************************************************************************/


Boolean
XREF_edit_show(xw,l,c,b)
   XREF_WIN xw;
   Integer l,c;
   String b;
{
   Character lbuf[10240],xbuf[10240];
   String file;
   Integer i,ln,qfg;
   Boolean sp;

   if (l == 0) {
      l = EDTcur_line(xw->edit_info);
      c = EDTcur_char(xw->edit_info);
    };

   EDTinq_line_text(xw->edit_info,l,lbuf);
   --c;
   ln = strlen(lbuf);

   while (lbuf[0] == ' ') {
      for (i = 0; i < ln && isspace(lbuf[i]); ++i);
      if (i >= ln) return FALSE;
      if (!isdigit(lbuf[i])) break;
      if (l == 1) return FALSE;
      l -= 1;
      strcpy(xbuf,lbuf);
      EDTinq_line_text(xw->edit_info,l,lbuf);
      c += strlen(lbuf);
      strcat(lbuf,xbuf);
      ln = strlen(lbuf);
    };

   file = NULL;
   qfg = 0;
   sp = TRUE;
   for (i = 0; i < ln; ++i) {
      if (qfg == 0 && file != NULL && sp && isdigit(lbuf[i])) break;

      if (qfg == 0) {
	 if (lbuf[i] == '"' || lbuf[i] == '\'') {
	    qfg = lbuf[i];
	    continue;
	  };
       }
      else {
	 if (lbuf[i] == '\\') ++i;
	 else if (lbuf[i] == qfg) qfg = 0;
	 continue;
       };

      if (!isspace(lbuf[i])) {
	 if (sp) file = &lbuf[i];
	 sp = FALSE;
       }
      else {
	 if (!sp) lbuf[i] = 0;
	 sp = TRUE;
       };
    };

   if (file == NULL) return FALSE;

   if (c > i && c < ln) {
      while (isdigit(lbuf[c]) || lbuf[c] == '*') --c;
      while (isspace(lbuf[c])) ++c;
      if (isdigit(lbuf[c])) i = c;
    };

   ln = atol(&lbuf[i]);
   if (ln == 0) return FALSE;

   MSGsenda("XREF SET %s %d %s",file,ln,b);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	xref_mouse -- handle mouse hits on editor			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
xref_mouse(xw,btn,l,c,fl,fc,tl,tc)
   XREF_WIN xw;
   Integer btn;
   Integer l,c;
   Integer fl,fc;
   Integer tl,tc;
{
   String b;

   if (btn & RIP_BTN_LEFT) b = "LEFT";
   else if (btn & RIP_BTN_MID) b = "MID";
   else if (btn & RIP_BTN_RIGHT) b = "RIGHT";
   else b = "NONE";

   return XREF_edit_show(xw,l,c,b);
};






/* end of xrefedit.c */
