/************************************************************************/
/*									*/
/*		xref_local.h						*/
/*									*/
/*	Local definitions for xref interface package			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#define  PROT_NAME	XREF__sema

#include <datatypes.h>
#include <sequence.h>
#include <ash.h>
#include <rip.h>
#include <stem.h>
#include <leaf.h>

#include <auxd.h>
#include <edt.h>
#include <msg.h>
#include <pmat.h>
#include <field.h>

#include <xref.h>
#include "xref_common.h"




/************************************************************************/
/*									*/
/*	Local Definitions						*/
/*									*/
/************************************************************************/


#define XRDB_CMD_NAME	"xrefdb"
#define XRDB_SYSNAME	"xrefdb"

#define SEPARATOR	"----------------------------------------------"

#define BUF_SIZE	1024




/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/



typedef struct _XREF_WIN *	XREF_WIN;
typedef struct _XREF_DATA *	XREF_DATA;



typedef struct _XREF_WIN {
   ASH_WINDOW	window;
   ASH_WINDOW	menu_win;
   ASH_WINDOW	disp_win;
   EDT_ID	edit_info;
   Boolean	clear_fg;
   Boolean	skip_fg;
   XREF_DATA	data;
   Character	outline[BUF_SIZE];
} XREF_WIN_INFO;



typedef struct _XREF_DATA {
   Integer	pid;
   String	system;
   FILE *	cmd_file;
   FILE *	data_file;
   Function_Ptr outfct;
   Universal	outdata;
   XREF_WIN	outedit;
} XREF_DATA_INFO;





/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/


					/* xrefmain.c			*/



					/* xrefwin.c			*/
extern	void		XREF_win_init();
extern	XREF_WIN	XREF_create();
extern	XREF_WIN	XREF_find_window();
extern	void		XREF_for_all_windows();



					/* xrefmenu.c			*/
extern	void		XREF_menu_init();
extern	void		XREF_menu_setup();
extern	Boolean 	XREF_menu_system();



					/* xrefedit.c			*/
extern	void		XREF_edit_init();
extern	void		XREF_edit_setup();
extern	void		XREF_output_begin();
extern	void		XREF_output();
extern	void		XREF_output_done();
extern	Boolean 	XREF_edit_show();



					/* xrefrun.c			*/
extern	void		XREF_run_init();
extern	XREF_DATA	XREF_set_system();
extern	void		XREF_run_system();
extern	void		XREF_run_query();
extern	Integer 	XREF_inq_systems();
extern	Boolean 	XREF_check_for_system();
extern	void		XREF_load_system();


					/* xrefmsg.c			*/
extern	void		XREF_msg_init();





/* end of xref_local.h */
