/************************************************************************/
/*									*/
/*		xrdb_defs.h						*/
/*									*/
/*	Definitions for the database					*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/





/************************************************************************/
/*									*/
/*	Type definitions						*/
/*									*/
/************************************************************************/


typedef struct _RELATION *	RELATION;
typedef struct _FIELD * 	FIELD;



typedef enum _FIELD_TYPE {
   FIELD_TYPE_NONE,
   FIELD_TYPE_INT,
   FIELD_TYPE_STRING,
   FIELD_TYPE_SCOPE_CLASS,
   FIELD_TYPE_FILE,
   FIELD_TYPE_SCOPE,
   FIELD_TYPE_NAME,
   FIELD_TYPE_TYPE,
   FIELD_TYPE_BOOL,
   FIELD_TYPE_DECL_CLASS,
   FIELD_TYPE_DECL,
   FIELD_TYPE_PROT_CLASS,
} FIELD_TYPE;



typedef struct _RELATION {
   String name;
   Character id;
   FIELD field;
   Integer ** base;
   Integer unit_size;
   Integer * count;
} RELATION_INFO;



typedef struct _FIELD {
   String name;
   FIELD_TYPE type;
   Integer offset;
} FIELD_INFO;





/************************************************************************/
/*									*/
/*	Data dictionary definitions					*/
/*									*/
/************************************************************************/


static FIELD_INFO scope_fields[] = {
   { "class",   FIELD_TYPE_SCOPE_CLASS, 0 },
   { "id",      FIELD_TYPE_SCOPE,       1 },
   { "start",   FIELD_TYPE_INT,         2 },
   { "end",     FIELD_TYPE_INT,         3 },
   { "file",    FIELD_TYPE_FILE,        4 },
   { "inside",  FIELD_TYPE_SCOPE,       5 },
   { 0 }
};



static FIELD_INFO ref_fields[] = {
   { "name",    FIELD_TYPE_NAME,        0 },
   { "file",    FIELD_TYPE_FILE,        1 },
   { "line",    FIELD_TYPE_INT,         2 },
   { "assign",  FIELD_TYPE_BOOL,        3 },
   { "function",FIELD_TYPE_NAME,        4 },
   { 0 }
};



static FIELD_INFO decl_fields[] = {
   { "name",    FIELD_TYPE_NAME,        0 },
   { "scope",   FIELD_TYPE_SCOPE,       1 },
   { "file",    FIELD_TYPE_FILE,        2 },
   { "type",    FIELD_TYPE_TYPE,        3 },
   { "class",   FIELD_TYPE_DECL_CLASS,  4 },
   { "line",    FIELD_TYPE_INT,         5 },
   { "id",      FIELD_TYPE_DECL,        6 },
   { "function",FIELD_TYPE_NAME,        7 },
   { 0 }
};



static FIELD_INFO call_fields[] = {
   { "from",    FIELD_TYPE_NAME,        0 },
   { "call",    FIELD_TYPE_NAME,        1 },
   { "file",    FIELD_TYPE_FILE,        2 },
   { "line",    FIELD_TYPE_INT,         3 },
   { 0 }
};



static FIELD_INFO fct_fields[] = {
   { "name",    FIELD_TYPE_NAME,        0 },
   { "file",    FIELD_TYPE_FILE,        1 },
   { "line",    FIELD_TYPE_INT,         2 },
   { "scope",   FIELD_TYPE_SCOPE,       3 },
   { "numarg",  FIELD_TYPE_INT,         4 },
   { "args",    FIELD_TYPE_STRING,      5 },
   { 0 }
};




static FIELD_INFO file_fields[] = {
   { "name",    FIELD_TYPE_NAME,        0 },
   { "tail",    FIELD_TYPE_NAME,        1 },
   { "id",      FIELD_TYPE_FILE,        2 },
   { "usedby",  FIELD_TYPE_FILE,        3 },
   { 0 }
};



static FIELD_INFO hier_fields[] = {
   { "class",   FIELD_TYPE_NAME,        0 },
   { "parent",  FIELD_TYPE_NAME,        1 },
   { "file",    FIELD_TYPE_FILE,        2 },
   { "line",    FIELD_TYPE_INT,         3 },
   { "public",  FIELD_TYPE_BOOL,        4 },
   { "virtual", FIELD_TYPE_BOOL,        5 },
   { "friend",  FIELD_TYPE_BOOL,        6 },
   { 0 }
};



static FIELD_INFO memb_fields[] = {
   { "class",   FIELD_TYPE_NAME,        0 },
   { "member",  FIELD_TYPE_NAME,        1 },
   { "file",    FIELD_TYPE_FILE,        2 },
   { "line",    FIELD_TYPE_INT,         3 },
   { "protect", FIELD_TYPE_PROT_CLASS,  4 },
   { "isdata",  FIELD_TYPE_BOOL,        5 },
   { "inline",  FIELD_TYPE_BOOL,        6 },
   { "friend",  FIELD_TYPE_BOOL,        7 },
   { "virtual", FIELD_TYPE_BOOL,        8 },
   { "static",  FIELD_TYPE_BOOL,        9 },
   { "pure",    FIELD_TYPE_BOOL,        10 },
   { "const",   FIELD_TYPE_BOOL,        11 },
   { 0 }
};




static FIELD_INFO mdef_fields[] = {
   { "class",   FIELD_TYPE_NAME,        0 },
   { "member",  FIELD_TYPE_NAME,        1 },
   { "file",    FIELD_TYPE_FILE,        2 },
   { "line",    FIELD_TYPE_INT,         3 },
   { "type",    FIELD_TYPE_TYPE,        4 },
   { "name",    FIELD_TYPE_NAME,        5 },
   { 0 }
};




static RELATION_INFO relations[] = {
   { "Scope", 'S', scope_fields,
	(Integer **) & XRDB__db_scope,
	sizeof(XRDB_SCOPE_INFO)/4 ,
	(Integer *) & XRDB__db_scope_ct },
   { "Ref", 'R', ref_fields,
	(Integer **) & XRDB__db_ref,
	sizeof(XRDB_REF_INFO)/4 ,
	(Integer *) & XRDB__db_ref_ct },
   { "Decl", 'D', decl_fields,
	(Integer **) & XRDB__db_decl,
	sizeof(XRDB_DECL_INFO)/4 ,
	(Integer *) & XRDB__db_decl_ct },
   { "Call", 'C', call_fields,
	(Integer **) & XRDB__db_call,
	sizeof(XRDB_CALL_INFO)/4 ,
	(Integer *) & XRDB__db_call_ct },
   { "Fct", 'F', fct_fields,
	(Integer **) & XRDB__db_fct,
	sizeof(XRDB_FCT_INFO)/4 ,
	(Integer *) & XRDB__db_fct_ct },
   { "file", 'f', file_fields,
	(Integer **) & XRDB__db_file,
	sizeof(XRDB_FILE_INFO)/4 ,
	(Integer *) & XRDB__db_file_ct },
   { "Hier", 'H', hier_fields,
	(Integer **) & XRDB__db_hier,
	sizeof(XRDB_HIER_INFO)/4 ,
	(Integer *) & XRDB__db_hier_ct },
   { "Memb", 'M', memb_fields,
	(Integer **) & XRDB__db_memb,
	sizeof(XRDB_MEMB_INFO)/4 ,
	(Integer *) & XRDB__db_memb_ct },
   { "mDef", 'm', mdef_fields,
	(Integer **) & XRDB__db_mdef,
	sizeof(XRDB_MDEF_INFO)/4 ,
	(Integer *) & XRDB__db_mdef_ct },
   { 0 }
};




/************************************************************************/
/*									*/
/*	Enumeration look up tables					*/
/*									*/
/************************************************************************/


typedef struct _VALUE_TABLE {
   String name;
   Integer value;
} VALUE_TABLE;







static VALUE_TABLE scope_class_table[] = {
   { "NONE", XRDB_SCOPE_NONE },
   { "EXTERN", XRDB_SCOPE_EXTERN },
   { "INTERN", XRDB_SCOPE_INTERN },
   { "ARGS", XRDB_SCOPE_ARGS },
   { "SUE", XRDB_SCOPE_SUE },
   { 0 }
};




static VALUE_TABLE decl_class_table[] = {
   { "NONE", XRDB_DECL_NONE },
   { "STATIC", XRDB_DECL_STATIC },
   { "EXTERN", XRDB_DECL_EXTERN },
   { "AUTO", XRDB_DECL_AUTO },
   { "REGISTER", XRDB_DECL_REGISTER },
   { "TYPEDEF", XRDB_DECL_TYPEDEF },
   { "EXTDEF", XRDB_DECL_EXTDEF },
   { "PARAM", XRDB_DECL_PARAM },
   { "FIELD", XRDB_DECL_FIELD },
   { "EFUNCTION", XRDB_DECL_EFUNCTION },
   { "SFUNCTION", XRDB_DECL_SFUNCTION },
   { "STRUCTID", XRDB_DECL_STRUCTID },
   { "UNIONID", XRDB_DECL_UNIONID },
   { "ENUMID", XRDB_DECL_ENUMID },
   { "CONST", XRDB_DECL_CONST },
   { "CLASSID", XRDB_DECL_CLASSID },
   { "MACRO", XRDB_DECL_MACRO },
   { 0 }
};






static VALUE_TABLE prot_class_table[] = {
   { "NONE", XRDB_PROT_NONE },
   { "PUBLIC", XRDB_PROT_PUBLIC },
   { "PRIVATE", XRDB_PROT_PRIVATE },
   { "PROTECTED", XRDB_PROT_PROTECTED },
   { 0 }
};





/* end of xrdb_defs.h */


