/************************************************************************/
/*									*/
/*		viewtext.c						*/
/*									*/
/*	Text string maintenance for view windows			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#include "view_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define INIT_DISP_SIZE	32




/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	Integer 	key_match();
static	void		free_data();
static	void		free_from();

extern	Float		atof();



/************************************************************************/
/*									*/
/*	VIEW_text_init -- module initialization 		       */
/*									*/
/************************************************************************/


void
VIEW_text_init()
{
};





/************************************************************************/
/*									*/
/*	VIEW_text_setup -- setup new view window			*/
/*									*/
/************************************************************************/


void
VIEW_text_setup(vw)
   VIEW_WIN vw;
{
   vw->max_disp = INIT_DISP_SIZE;
   vw->num_disp = 0;
   vw->displays = (VIEW_DATA) calloc(sizeof(VIEW_DATA_INFO),vw->max_disp);
};





/************************************************************************/
/*									*/
/*	VIEW_add -- add line for viewing				*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

void
VIEW_add(vw,vc,key,txt)
   VIEW_WIN vw;
   VIEW_CLASS vc;
   String key;
   String txt;
{
   Integer i,j,k;

   for (i = 0; i < vw->num_disp; ++i) {
      j = key_match(vw,key,&vw->displays[i]);
      if (j <= 0) break;
    };

   if (i < vw->num_disp && j == 0) {	/* replace			*/
      if (STRNEQ(txt,vw->displays[i].text)) {
	 SFREE(vw->displays[i].text);
	 vw->displays[i].text = SALLOC(txt);
	 VIEW_replace_line(vw,i,txt);
       };
      if (vw->displays[i].invalid) {
	 vw->displays[i].invalid = FALSE;
	 if (vw->type->num_key) {
	    vw->displays[i].key.num = atof(key);
	  }
	 else {
	    if (vw->displays[i].key.str != NULL) SFREE(vw->displays[i].key.str);
	    vw->displays[i].key.str = SALLOC(key);
	  };
       };
    }
   else {				/* insert			*/
      if (vw->num_disp+1 >= vw->max_disp) {
	 vw->max_disp *= 2;
	 vw->displays = (VIEW_DATA) realloc(vw->displays,
					       sizeof(VIEW_DATA_INFO)*vw->max_disp);
       };
      for (k = vw->num_disp-1; k >= i; --k) {
	 vw->displays[k+1] = vw->displays[k];
       };
      ++vw->num_disp;
      vw->displays[i].text = SALLOC(txt);
      vw->displays[i].invalid = FALSE;
      if (vw->type->num_key) {
	 vw->displays[i].key.num = atof(key);
       }
      else {
	 vw->displays[i].key.str = SALLOC(key);
       };
      VIEW_insert_line(vw,i,txt);
    };
};





/************************************************************************/
/*									*/
/*	VIEW_remove -- remove indicated item				*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

void
VIEW_remove(vw,vc,key)
   VIEW_WIN vw;
   VIEW_CLASS vc;
   String key;
{
   Integer i,j,k;

   for (i = 0; i < vw->num_disp; ++i) {
      j = key_match(vw,key,&vw->displays[i]);
      if (j <= 0) break;
    };

   if (j != 0 || i >= vw->num_disp) return;

   VIEW_delete_line(vw,i);

   free_data(vw,i);

   for (k = i+1; k < vw->num_disp; ++k) {
      vw->displays[k-1] = vw->displays[k];
    };

   --vw->num_disp;
};





/************************************************************************/
/*									*/
/*	VIEW_end -- end after indicated item				*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

void
VIEW_end(vw,vc,key)
   VIEW_WIN vw;
   VIEW_CLASS vc;
   String key;
{
   Integer i,j;

   for (i = 0; i < vw->num_disp; ++i) {
      j = key_match(vw,key,&vw->displays[i]);
      if (j <= 0) break;
    };

   free_from(vw,i);
};





/************************************************************************/
/*									*/
/*	VIEW_clear -- clear all displays				*/
/*									*/
/************************************************************************/


void
VIEW_clear(vw)
   VIEW_WIN vw;
{
   free_from(vw,0);
};





/************************************************************************/
/*									*/
/*	VIEW_invalidate -- invalidate all displays			*/
/*									*/
/************************************************************************/


void
VIEW_invalidate(vw)
   VIEW_WIN vw;
{
   Integer i;

   for (i = 0; i < vw->num_disp; ++i) {
      vw->displays[i].invalid = TRUE;
    };
};





/************************************************************************/
/*									*/
/*	key_match -- compare key with given line			*/
/*									*/
/************************************************************************/


static Integer
key_match(vw,key,vd)
   VIEW_WIN vw;
   String key;
   VIEW_DATA vd;
{
   Integer i;
   Float fkey;

   if (vd->invalid) return 0;

   if (vw->type->num_key) {
      fkey = atof(key);
      if (fkey < vd->key.num) i = -1;
      else if (fkey == vd->key.num) i = 0;
      else i = 1;
    }
   else {
      i = strcmp(key,vd->key.str);
    };

   return i;
};





/************************************************************************/
/*									*/
/*	free_data -- freee view data					*/
/*									*/
/************************************************************************/


static void
free_data(vw,i)
   VIEW_WIN vw;
   Integer i;
{
   SFREE(vw->displays[i].text);
   if (!vw->type->num_key) SFREE(vw->displays[i].key.str);
   vw->displays[i].text = NULL;
   vw->displays[i].key.str = NULL;
};





/************************************************************************/
/*									*/
/*	free_from -- free data from given index on			*/
/*									*/
/************************************************************************/


static void
free_from(vw,i)
   VIEW_WIN vw;
   Integer i;
{
   Integer k;

   if (i >= vw->num_disp) return;

   VIEW_truncate_at(vw,i);

   for (k = i; k < vw->num_disp; ++k) free_data(vw,k);

   vw->num_disp = i;
};





/* end of viewtext.c */
