/************************************************************************/
/*									*/
/*		viewmon.c						*/
/*									*/
/*	Message monitoring package for viewers				*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "view_local.h"

#include <varargs.h>




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_PARAM	6






/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	void		setup_msg();
static	void		remove_msg();
static	void		handle_view_add_msg();
static	void		handle_view_remove_msg();
static	void		handle_end_msg();
static	void		handle_clear_msg();
static	void		handle_invalidate_msg();
static	void		format_text();




/************************************************************************/
/*									*/
/*	VIEW_mon_init -- module initialization				*/
/*									*/
/************************************************************************/


void
VIEW_mon_init()
{
};




/************************************************************************/
/*									*/
/*	VIEW_mon_setup -- setup message routines			*/
/*									*/
/************************************************************************/


void
VIEW_mon_setup(vw)
   VIEW_WIN vw;
{
   VIEW_CLASS cls[64];
   register VIEW_CLASS vc;
   register Integer ct,i;
   String sys;

   ct = VIEW_inq_classes(vw,64,cls);

   for (i = 0; i < ct; ++i) {
      vc = cls[i];
      setup_msg(vw,vc,vc->msg_add,handle_view_add_msg);
      setup_msg(vw,vc,vc->msg_remove,handle_view_remove_msg);
      setup_msg(vw,vc,vc->msg_end,handle_end_msg);
    };

   sys = vw->system;
   if (sys == NULL || *sys == 0) sys = "*";

   if (vw->type->msg_open != NULL) {
      MSGsenda(vw->type->msg_open,sys);
    };

   if (vw->type->msg_clear != NULL) {
      setup_msg(vw,NULL,vw->type->msg_clear,handle_clear_msg);
    };
   if (vw->type->msg_invalidate != NULL) {
      setup_msg(vw,NULL,vw->type->msg_invalidate,handle_invalidate_msg);
    };
};





/************************************************************************/
/*									*/
/*	VIEW_mon_remove -- remove messages				*/
/*									*/
/************************************************************************/


void
VIEW_mon_remove(vw)
   VIEW_WIN vw;
{
   VIEW_CLASS cls[64];
   register VIEW_CLASS vc;
   register Integer ct,i;

   ct = VIEW_inq_classes(vw,64,cls);

   for (i = 0; i < ct; ++i) {
      vc = cls[i];
      remove_msg(vw,vc,vc->msg_add,handle_view_add_msg);
      remove_msg(vw,vc,vc->msg_remove,handle_view_remove_msg);
      remove_msg(vw,vc,vc->msg_end,handle_end_msg);
    };

   if (vw->type->msg_clear != NULL) {
      remove_msg(vw,NULL,vw->type->msg_clear,handle_clear_msg);
    };
   if (vw->type->msg_invalidate != NULL) {
      remove_msg(vw,NULL,vw->type->msg_invalidate,handle_invalidate_msg);
    };
};





/************************************************************************/
/*									*/
/*	setup_msg -- setup message					*/
/*									*/
/************************************************************************/


static void
setup_msg(vw,vc,msg,rtn)
   VIEW_WIN vw;
   VIEW_CLASS vc;
   String msg;
   Function_Ptr rtn;
{
   Integer i;
   Universal args[MAX_PARAM+2];

   if (msg == NULL) return;

   for (i = 0; i < MAX_PARAM; ++i) args[i] = NULL;
   args[MAX_PARAM] = (Universal) vw;
   args[MAX_PARAM+1] = (Universal) vc;

   MSGregister(msg,rtn,MAX_PARAM+2,args);
};





/************************************************************************/
/*									*/
/*	remove_msg -- done with message 				*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static void
remove_msg(vw,vc,msg,rtn)
   VIEW_WIN vw;
   VIEW_CLASS vc;
   String msg;
   Function_Ptr rtn;
{
   if (msg == NULL) return;

/* MSGfeee(msg,rtn);		*********** have to be more selective	*/
};





/************************************************************************/
/*									*/
/*	handle_view_add_msg -- handle message to add view		*/
/*	handle_view_remove_msg -- handle message to remove view 	*/
/*	handle_end_msg -- handle message to end display 		*/
/*	handle_clear_msg -- handle message to clear display		*/
/*	handle_invalidate_msg -- handle message to invalidate display	*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static void
handle_view_add_msg(key,a2,a3,a4,a5,a6,vw,vc)
   String key;
   Universal a2,a3,a4,a5,a6;
   VIEW_WIN vw;
   VIEW_CLASS vc;
{
   Character buf[20480];

   if (vw->window == NULL) return;

   format_text(buf,vc,key,a2,a3,a4,a5,a6);

   VIEW_add(vw,vc,key,buf);
};





/*ARGSUSED*/

static void
handle_view_remove_msg(key,a2,a3,a4,a5,a6,vw,vc)
   String key;
   Universal a2,a3,a4,a5,a6;
   VIEW_WIN vw;
   VIEW_CLASS vc;
{
   if (vw->window == NULL) return;

   VIEW_remove(vw,vc,key);
};





/*ARGSUSED*/

static void
handle_end_msg(key,a2,a3,a4,a5,a6,vw,vc)
   String key;
   Universal a2,a3,a4,a5,a6;
   VIEW_WIN vw;
   VIEW_CLASS vc;
{
   if (vw->window == NULL) return;

   VIEW_end(vw,vc,key);
};





/*ARGSUSED*/

static void
handle_clear_msg(key,a2,a3,a4,a5,a6,vw,vc)
   String key;
   Universal a2,a3,a4,a5,a6;
   VIEW_WIN vw;
   VIEW_CLASS vc;
{
   if (vw->window == NULL) return;

   VIEW_clear(vw);
};





/*ARGSUSED*/

static void
handle_invalidate_msg(key,a2,a3,a4,a5,a6,vw,vc)
   String key;
   Universal a2,a3,a4,a5,a6;
   VIEW_WIN vw;
   VIEW_CLASS vc;
{
   if (vw->window == NULL) return;

   VIEW_invalidate(vw);
};





/************************************************************************/
/*									*/
/*	format_text -- format a message 				*/
/*									*/
/************************************************************************/


static void
format_text(va_alist)
   va_dcl
{
   va_list ap;
   String buf,pat,s,f;
   VIEW_CLASS vc;
   Universal args[MAX_PARAM];
   Character lbuf[512];
   Universal pargs[MAX_PARAM];
   Integer i,ct;

   va_start(ap);
   buf = va_arg(ap,String);
   vc = va_arg(ap,VIEW_CLASS);
   for (i = 0; i < MAX_PARAM; ++i) args[i] = va_arg(ap,Universal);

   ct = 0;
   s = lbuf;
   for (pat = vc->display_fmt; *pat != 0; ++pat) {
      if (*pat == '%') {
	 if (!isdigit(pat[1])) {
	    *s++ = *pat++;
	  }
	 else {
	    *s++ = *pat++;
	    i = 0;
	    while (isdigit(*pat)) i = i*10 + *pat++ - '0';
	    pargs[ct++] = args[i-1];
	    if (*pat == ':') {
	       f = rindex(args[i-1],'/');
	       if (f != NULL) pargs[ct-1] = (Universal) ++f;
	       ++pat;
	     };
	    if (*pat == '.') ++pat;
	    if (*pat == 's' && pargs[ct-1] != NULL && strlen(pargs[ct-1]) > 512) {
	       f = (String) pargs[ct-1];
	       f[511] = 0;
	     };
	  };
	 if (*pat == 0) break;
       };
      *s++ = *pat;
    };
   *s = 0;

   sprintf(buf,lbuf,pargs[0],pargs[1],pargs[2],pargs[3],pargs[4],pargs[5]);
};





/* end of viewmon.c */
