/************************************************************************/
/*									*/
/*		viewmain.c						*/
/*									*/
/*	General routines for viewing package			       */
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "view_local.h"





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/


static	Boolean 	view_inited = FALSE;
	PROT_DECL;




/************************************************************************/
/*									*/
/*	VIEW_init -- package initialization				*/
/*									*/
/************************************************************************/


void
VIEW_init()
{
   PROT_INIT;
   PROTECT;
   if (!view_inited) {
      view_inited = TRUE;
      VIEW_def_init();
      VIEW_win_init();
      VIEW_edit_init();
      VIEW_mon_init();
      VIEW_text_init();
      VIEW_menu_init();
      VIEW_ask_init();
    };
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	VIEWnew_willow_window -- create a new willow window		*/
/*									*/
/************************************************************************/


int
VIEWnew_willow_window(w,name)
   ASH_WINDOW w;
   String name;
{
   register VIEW_WIN aw;

   VIEW_init();

   aw = VIEW_create(w,name);

   if (aw == NULL) return FALSE;

   aw->willow_fg = TRUE;

   return TRUE;
};





/************************************************************************/
/*									*/
/*	VIEWnew_window -- create a new viewing window of given type	*/
/*									*/
/************************************************************************/


int
VIEWnew_window(w,type)
   ASH_WINDOW w;
   String type;
{
   register VIEW_WIN aw;

   VIEW_init();

   aw = VIEW_create(w,type);

   return (aw != NULL);
};





/* end of viewmain.c */
