/************************************************************************/
/*									*/
/*		viewedit.c						*/
/*									*/
/*	Editor interface for view windows				*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#include "view_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	VIEW_edit_init -- module initialization 		       */
/*									*/
/************************************************************************/


void
VIEW_edit_init()
{
};





/************************************************************************/
/*									*/
/*	VIEW_edit_setup -- setup editor in window			*/
/*									*/
/************************************************************************/


void
VIEW_edit_setup(vw)
   VIEW_WIN vw;
{
   EDT_DATA ed;

   if (vw->edit_win == NULL) return;

   ed = PALLOC(EDT_DATA_INFO);
   ed->readonly = FALSE;
   ed->create = TRUE;
   ed->temporary = TRUE;
   ed->scroll = TRUE;
   ed->raw = FALSE;
   ed->echo = FALSE;
   ed->savectl = FALSE;
   ed->mode = "SCRIPT";
   ed->bounds_rtn = NULL;
   ed->input_rtn = NULL;
   ed->mouse_rtn = (Function_Ptr) VIEW_edit_mouse;
   ed->file_rtn = NULL;
   ed->input_filter = NULL;
   ed->output_filter = NULL;

   vw->edit_info = EDTdefine_editor(vw->edit_win,NULL,ed,vw,
				       vw->menu_win,NULL);

   EDTenable(vw->edit_info,FALSE);
   EDTkeep_position(vw->edit_info,TRUE);
};





/************************************************************************/
/*									*/
/*	VIEW_insert_line -- insert a new line				*/
/*	VIEW_delete_line -- delete a line				*/
/*	VIEW_replace_line -- replace a line				*/
/*	VIEW_truncate_at -- truncate a give line			*/
/*									*/
/************************************************************************/


void
VIEW_insert_line(vw,line,text)
   VIEW_WIN vw;
   Integer line;
   String text;
{
   EDTenable(vw->edit_info,TRUE);
   EDTinsert_line(vw->edit_info,line+1,text);
   EDTenable(vw->edit_info,FALSE);
};






void
VIEW_delete_line(vw,line)
   VIEW_WIN vw;
   Integer line;
{
   EDTenable(vw->edit_info,TRUE);
   EDTdelete_line(vw->edit_info,line+1);
   EDTenable(vw->edit_info,FALSE);
};






void
VIEW_replace_line(vw,line,text)
   VIEW_WIN vw;
   Integer line;
   String text;
{
   EDTenable(vw->edit_info,TRUE);
   EDTreplace_line(vw->edit_info,line+1,text);
   EDTenable(vw->edit_info,FALSE);
};






void
VIEW_truncate_at(vw,line)
   VIEW_WIN vw;
   Integer line;
{
   EDTenable(vw->edit_info,TRUE);
   EDTtruncate_at(vw->edit_info,line+1);
   EDTenable(vw->edit_info,FALSE);
};







/* end of viewedit.c */
