/************************************************************************/
/*									*/
/*		viewdef.c						*/
/*									*/
/*	Definition routines for views					*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "view_local.h"





/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


static	Sequence	all_view_wtyp;
static	Sequence	all_view_class;




/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	void		get_view_classes();
static	void		get_window_types();




/************************************************************************/
/*									*/
/*	VIEW_def_init -- module initialization			       */
/*									*/
/************************************************************************/


void
VIEW_def_init()
{
   all_view_wtyp = NULL;
   all_view_class = NULL;

   get_view_classes();
   get_window_types();
};





/************************************************************************/
/*									*/
/*	VIEW_find_window_type -- find window description by name	*/
/*	VIEW_find_class -- find view class description by name		*/
/*									*/
/************************************************************************/


VIEW_WTYPE
VIEW_find_window_type(nm)
   String nm;
{
   register Sequence l;
   register VIEW_WTYPE wt;

   forin (wt,VIEW_WTYPE,l,all_view_wtyp) {
      if (STREQL(wt->name,nm)) break;
    };

   return wt;
};





VIEW_CLASS
VIEW_find_class(vw,nm)
   VIEW_WIN vw;
   String nm;
{
   register VIEW_CLASS vc;
   register Sequence l,la;

   if (vw == NULL) la = all_view_class;
   else la = vw->type->allowed;

   forin (vc,VIEW_CLASS,l,la) {
      if (STREQL(vc->name,nm)) break;
    };

   return vc;
};





/************************************************************************/
/*									*/
/*	VIEW_inq_window_types -- return types of view windows		*/
/*	VIEW_inq_classes -- return view classes allowed 		*/
/*									*/
/************************************************************************/


Integer
VIEW_inq_window_types(mx,typ)
   Integer mx;
   VIEW_WTYPE typ[];
{
   register Integer ct;
   register Sequence l;
   register VIEW_WTYPE vt;

   ct = 0;
   forin (vt,VIEW_WTYPE,l,all_view_wtyp) {
      typ[ct++] = vt;
      if (ct >= mx) break;
    };

   return ct;
};





Integer
VIEW_inq_classes(vw,mx,typ)
   VIEW_WIN vw;
   Integer mx;
   VIEW_CLASS typ[];
{
   register Integer ct;
   register Sequence l,la;
   register VIEW_CLASS vc;

   if (vw == NULL) la = all_view_class;
   else la = vw->type->allowed;

   ct = 0;
   forin (vc,VIEW_CLASS,l,la) {
      typ[ct++] = vc;
      if (ct >= mx) break;
    };

   return ct;
};





/************************************************************************/
/*									*/
/*	get_view_classes -- read in anc create view class definitions	*/
/*									*/
/************************************************************************/


static void
get_view_classes()
{
   register AUXD hdl;
   register VIEW_CLASS vc;

   hdl = AUXDget_handle(NULL,"VIEW");

   for (hdl = AUXDget_handle(hdl,"CLASS"); hdl != NULL; hdl = AUXDnext_handle(hdl)) {
      vc = PALLOC(VIEW_CLASS_INFO);
      vc->name = AUXDget_info(hdl,"NAME");
      if (vc->name == NULL) continue;
      vc->display_fmt = AUXDget_info(hdl,"DISPLAY_FMT");
      vc->msg_add = AUXDget_info(hdl,"DISPLAY_MSG");
      vc->msg_remove = AUXDget_info(hdl,"DELETE_MSG");
      vc->msg_end = AUXDget_info(hdl,"END_MSG");
      all_view_class = APPEND(vc,all_view_class);
    };
};





/************************************************************************/
/*									*/
/*	get_window_types -- read in and create window definitions	*/
/*									*/
/************************************************************************/


static void
get_window_types()
{
   register AUXD hdl;
   register VIEW_WTYPE vt;
   String defs[64];
   register Integer i,ct;
   register Sequence l;
   register VIEW_CLASS vc;
   String s;

   hdl = AUXDget_handle(NULL,"VIEW");
   s = ASHinq_resource("view.simple");

   for (hdl = AUXDget_handle(hdl,"TYPE"); hdl != NULL; hdl = AUXDnext_handle(hdl)) {
      vt = PALLOC(VIEW_WTYPE_INFO);
      vt->name = AUXDget_info(hdl,"NAME");
      if (vt->name == NULL) continue;

      ct = AUXDget_info_list(hdl,"USE",64,defs);
      l = NULL;
      for (i = ct-1; i >= 0; --i) {
	 vc = VIEW_find_class(NULL,defs[i]);
	 if (vc == NULL) {
	    fprintf(stderr,"VIEW: Unknown view class: %s\n",defs[i]);
	  }
	 else {
	    l = CONS(vc,l);
	  };
       };
      vt->allowed = l;

      vt->num_key = AUXDget_defined(hdl,"NUMERIC_KEY");
      vt->msg_open = AUXDget_info(hdl,"OPEN_MSG");
      vt->msg_clear = AUXDget_info(hdl,"CLEAR_MSG");
      vt->msg_invalidate = AUXDget_info(hdl,"INVALIDATE_MSG");
      vt->options_rtn = AUXDget_info(hdl,"OPTIONS");
      vt->options_name = AUXDget_info(hdl,"OPTIONS_NAME");
      vt->remove_rtn = AUXDget_info(hdl,"REMOVE");
      vt->remove_name = AUXDget_info(hdl,"REMOVE_NAME");
      vt->askfirst = AUXDget_defined(hdl,"ASK_FIRST");
      vt->simple = AUXDget_defined(hdl,"SIMPLE");
      if (!vt->simple && s != NULL && STRNEQ(s,"off")) vt->simple = TRUE;

      all_view_wtyp = APPEND(vt,all_view_wtyp);
    };
};





/* end of viewdef.c */
