/*      Copyright 1990 Brown University -- Steven P. Reiss              */

#include <stdio.h>

typedef int Integer;
typedef char Character;
typedef struct _TREE *  TREE;

typedef struct _TREE {
   Integer value;
   TREE lson;
   TREE rson;
} TREE_B;

static  TREE    root;

static  TREE    insert_tree();
static  void    tree_walk();




main()
{
   Integer i,j;

   root = NULL;
   for (i = 0; i < 30; ++i) {
      j = random() % 1024;
      root = insert_tree(root,j);
    };

   tree_walk(root);

   if (root == NULL) abort();
};




static TREE
insert_tree(t,v)
   TREE t;
   Integer v;
{
   if (t == NULL) {
      t = (TREE) malloc(sizeof(TREE_B));
      t->lson = NULL;
      t->rson = NULL;
      t->value = v;
    }
   else if (v <= t->value) {
      t->lson = insert_tree(t->lson,v);
    }
   else {
      t->rson = insert_tree(t->rson,v);
    };

   return t;
};




static void
tree_walk(t)
   TREE t;
{
   if (t == NULL) return;

   tree_walk(t->lson);
   printf("TREE %d\n",t->value);
   tree_walk(t->rson);
};



/* end of tree.c */
