/************************************************************************/
/*                                                                      */
/*              auto.h                                                  */
/*                                                                      */
/*      Definitions for rotation/reflection finder                      */
/*                                                                      */
/************************************************************************/


#include <stdio.h>




/************************************************************************/
/*                                                                      */
/*      Type definitions                                                */
/*                                                                      */
/************************************************************************/

typedef int             Integer;
typedef char            Boolean;
typedef int             Universal;
typedef char *          String;


typedef struct _Sequence *Sequence;     /* A list is a pointer to a list block  */

typedef struct _Sequence {      /* A list block contains                */
   Universal Lcar;              /*    data in its car                   */
   Sequence Lcdr;               /*    and a list as its cdr             */
} SequenceB;


typedef Sequence        SeqOfInteger;


typedef struct _NODE {                  /* graph                        */
   Integer id;
   Integer nson;
   SeqOfInteger sons;
   Integer class;
   Integer done;
   Integer *dsig;
   Integer base;
   Integer cycle;
} *NODE, NODE_B;



typedef struct _CLASS {                 /* equivalence class            */
   Integer id;
   Integer nelt;
   SeqOfInteger elts;
   Boolean self;
} *CLASS, CLASS_B;





/************************************************************************/
/*                                                                      */
/*      Macro definitions                                               */
/*                                                                      */
/************************************************************************/


#define TRUE            1
#define FALSE           0



#define CAR(type,list)  ((type)((list)->Lcar))
#define CDR(list)       ((list)->Lcdr)
#define CADR(type,list) CAR(type,CDR(list))
#define EMPTY(list)     ((list) == NULL)

extern  Sequence        CONS();
extern  Sequence        RPLACD();
extern  Boolean         MEMQ();
extern                  LFREE();


#define forin(var,type,lvar,list) for(var=NULL,lvar=(list); EMPTY(lvar)?((var=NULL),FALSE):((var=CAR(type,lvar)),TRUE); lvar=CDR(lvar))




/* end of auto.h */
