/************************************************************************/
/*									*/
/*		fsymsun.c						*/
/*									*/
/*	Symbol reading definitions for SUN workstations 		*/
/*									*/
/************************************************************************/
/* Copyright 1989 Brown University -- Steven P. Reiss			*/
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/


#include "fsym_local.h"

#include <a.out.h>
#include <stab.h>
#include <sys/file.h>




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	Local type definitions						*/
/*									*/
/************************************************************************/


typedef struct _FSYM_ID {
   FILE * fid;
   String stringtbl;
   struct exec header;
} FSYM_ID_INFO;





/************************************************************************/
/*									*/
/*	Macros								*/
/*									*/
/************************************************************************/


#ifdef M_SPARC
#ifdef sparc
#define N_BADMACH(hdr) ((hdr).a_machtype != M_SPARC)
#else
#ifdef sun
#define N_BADMACH(hdr) ((hdr).a_machtype == M_SPARC)
#else
#define N_BADMACH(hdr) (0)
#endif
#endif
#else
#define N_BADMACH(hdr) (0)
#endif




/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	FSYMopen -- open a .o or executable file			*/
/*									*/
/************************************************************************/


FSYM_ID
FSYMopen(name,execonly)
   String name;
   Boolean execonly;
{
   FILE * fid;
   FSYM_ID fs;
   Integer len;

   fid = fopen(name,"r");
   if (fid == NULL) return NULL;

   fs = PALLOC(FSYM_ID_INFO);
   fs->fid = fid;
   fs->stringtbl = NULL;

   if (fread(&fs->header,sizeof(struct exec),1,fid) != 1) {
      FSYMclose(fs);
      return NULL;
    };

   if (N_BADMAG(fs->header)) {
      FSYMclose(fs);
      return NULL;
    };

   if (execonly && (N_BADMACH(fs->header) || fs->header.a_magic == OMAGIC)) {
      FSYMclose(fs);
      return NULL;
    };

   fseek(fid,N_STROFF(fs->header),0);
   if (fread(&len,sizeof(len),1,fid) != 1) {
      FSYMclose(fs);
      return NULL;
    };

   fseek(fid,N_STROFF(fs->header),0);
   fs->stringtbl = (String) malloc(len+10);
   if (fread(fs->stringtbl,len,1,fid) != 1) {
      FSYMclose(fs);
      return NULL;
    };

   return fs;
};






/************************************************************************/
/*									*/
/*	FSYMclose -- close binary file					*/
/*									*/
/************************************************************************/


void
FSYMclose(fs)
   FSYM_ID fs;
{
   if (fs->fid != NULL) fclose(fs->fid);
   fs->fid = NULL;

   if (fs->stringtbl != NULL) free(fs->stringtbl);
   fs->stringtbl = NULL;

   free(fs);
};





/************************************************************************/
/*									*/
/*	FSYMtest_exec -- check for executable vs .o file		*/
/*									*/
/************************************************************************/


int
FSYMtest_exec(fs)
   FSYM_ID fs;
{
   return (fs->header.a_magic != OMAGIC);
};






/************************************************************************/
/*									*/
/*	FSYMsymbols -- read symbols from executable file		*/
/*									*/
/************************************************************************/


void
FSYMsymbols(fs,tbl,data)
   FSYM_ID fs;
   FSYM_CALL * tbl;
   Universal data;
{
   Integer nsym;
   Integer i,ln;
   struct nlist sym;
   voidFunction_Ptr rtns[FSYM_TYPE_CT];
   FSYM_TYPE ft;
   String name,s;

   nsym = fs->header.a_syms / sizeof(struct nlist);
   fseek(fs->fid,N_SYMOFF(fs->header),0);

   for (i = 0; i < FSYM_TYPE_CT; ++i) rtns[i] = NULL;

   for (i = 0; tbl[i].type != FSYM_TYPE_END; ++i) {
      rtns[(int) tbl[i].type] = tbl[i].addr;
    };

   for (i = 0; i < nsym; ++i) {
      if (fread(&sym,sizeof(sym),1,fs->fid) != 1) break;
      name = &fs->stringtbl[sym.n_un.n_strx];

      switch (sym.n_type) {
	 case N_SO :
	    ft = FSYM_TYPE_SO;
	    ln = strlen(name);
	    if (name[ln-1] == '/') ft = FSYM_TYPE_DIR;
	    break;
	 case N_SOL :
	    ft = FSYM_TYPE_SOL;
	    break;
#ifdef N_BINCL
	 case N_BINCL :
	    ft = FSYM_TYPE_BINCL;
	    break;
	 case N_EINCL :
	    ft = FSYM_TYPE_EINCL;
	    break;
	 case N_EXCL :
	    ft = FSYM_TYPE_EXCL;
	    break;
#endif
	 case N_TEXT :
	 case N_FN :
	    if (name[0] != '_' &&
		   (index(name,'.') != NULL || strncmp(name,"-l",2) == 0))
	       ft = FSYM_TYPE_TEXT_SO;
	    else
	       ft = FSYM_TYPE_TEXT;
	    break;
	 case N_TEXT|N_EXT :
	    if (name[0] != '_' &&
		   (index(name,'.') != NULL || strncmp(name,"-l",2) == 0))
	       ft = FSYM_TYPE_TEXT_SO;
	    else
	       ft = FSYM_TYPE_TEXT_EXT;
	    break;
#ifdef N_MAIN
	 case N_MAIN :
#endif
	 case N_FNAME :
	 case N_FUN :
	 case N_ENTRY :
	    ft = FSYM_TYPE_FUN;
	    break;
	 case N_SLINE :
	    ft = FSYM_TYPE_SLINE;
	    break;
	 case N_ABS :
	 case N_DATA :
	 case N_BSS :
	 case N_COMM :
	    ft = FSYM_TYPE_DATA;
	    break;
	 case N_ABS|N_EXT :
	 case N_DATA|N_EXT :
	 case N_BSS|N_EXT :
	 case N_COMM|N_EXT :
	    ft = FSYM_TYPE_DATA_EXT;
	    break;
	 case N_GSYM :		/* global symbol: name,,0,type,0 */
	 case N_STSYM:		/* static symbol: name,,0,type,address */
	 case N_LCSYM:		/* .lcomm symbol: name,,0,type,address */
	 case N_RSYM :		/* register sym: name,,0,type,register */
	 case N_SSYM :		/* structure elt: name,,0,type,struct_offset */
	 case N_LSYM :		/* local sym: name,,0,type,offset */
	 case N_PSYM :		/* parameter: name,,0,type,offset */
	    if (sym.n_type == N_GSYM) ft = FSYM_TYPE_GLOBAL;
	    else ft = FSYM_TYPE_LOCAL;
	    s = index(name,':');
	    if (s != NULL) {
	       ++s;
	       switch (*s) {
		  case 't' :
		     ft = FSYM_TYPE_TYPE;
		     break;
		  case 'T' :
		     s = index(s,'=');
		     if (s != NULL) ++s;
		     if (s == NULL) ft = FSYM_TYPE_STRUCT;
		     else if (*s == 'u') ft = FSYM_TYPE_UNION;
		     else if (*s == 'e') ft = FSYM_TYPE_ENUM;
		     else ft = FSYM_TYPE_STRUCT;
		     break;
		  case 'S' :
		  case 'G' :
		  case 'V' :
		  case 'C' :
		     break;
		  default :
		     ft = FSYM_TYPE_AUTO;
		     break;
		};
	     };
	    break;
	 case N_LBRAC :
	    ft = FSYM_TYPE_LBRAC;
	    break;
	 case N_RBRAC :
	    ft = FSYM_TYPE_RBRAC;
	    break;
	 default :
	    ft = FSYM_TYPE_END;
	    break;
       };

      if (rtns[(int) ft] != NULL) {
	 (*rtns[(int) ft])(name,sym.n_desc,sym.n_value,ft,data);
       };
    };
};




/* end of fsymsun.c */
