/************************************************************************/
/*									*/
/*		fsym.h							*/
/*									*/
/*	Global definitions for symbol reading package			*/
/*									*/
/************************************************************************/
/* Copyright 1989 Brown University -- Steven P. Reiss			*/
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/





/************************************************************************/
/*									*/
/*	Type definitions						*/
/*									*/
/************************************************************************/


typedef struct _FSYM_ID *	FSYM_ID;



typedef enum _FSYM_TYPE {
   FSYM_TYPE_END,

   FSYM_TYPE_SO,
   FSYM_TYPE_DIR,
   FSYM_TYPE_SOL,
   FSYM_TYPE_BINCL,
   FSYM_TYPE_EINCL,
   FSYM_TYPE_EXCL,

   FSYM_TYPE_TEXT,
   FSYM_TYPE_TEXT_EXT,
   FSYM_TYPE_TEXT_SO,
   FSYM_TYPE_FUN,

   FSYM_TYPE_SLINE,

   FSYM_TYPE_DATA,
   FSYM_TYPE_DATA_EXT,
   FSYM_TYPE_LOCAL,
   FSYM_TYPE_GLOBAL,
   FSYM_TYPE_AUTO,

   FSYM_TYPE_TYPE,
   FSYM_TYPE_STRUCT,
   FSYM_TYPE_UNION,
   FSYM_TYPE_ENUM,

   FSYM_TYPE_LBRAC,
   FSYM_TYPE_RBRAC,
} FSYM_TYPE;

#define FSYM_TYPE_CT	24




typedef struct _FSYM_CALL {
   FSYM_TYPE type;
   void (*addr)();
} FSYM_CALL;





/************************************************************************/
/*									*/
/*	Entry Points							*/
/*									*/
/************************************************************************/


extern	FSYM_ID 		FSYMopen();
extern	void			FSYMclose();
extern	int			FSYMtest_exec();
extern	void			FSYMsymbols();




/* end of fsym.h */
