/************************************************************************/
/*									*/
/*		fprofwin.c						*/
/*									*/
/*	Window manipulation routines for cross-reference viewing	*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#include "fprof_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


static	Sequence	all_windows;





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	Boolean 	setup_window();
static	int		fprof_control();
static	void		check_windows();
static	int		fprof_edit_control();
static	void		fprof_remove();




/************************************************************************/
/*									*/
/*	Tables								*/
/*									*/
/************************************************************************/


#define MENU_WIN	1
#define DISPLAY_WIN	2



static	LEAF_DATA	fprof_leaf[] = {
   LEAF_ROOT(NULL),
   { MENU_WIN, LEAF_TYPE_PDM,
	{ LEAF_COORD_LX, LEAF_COORD_TEXT_LINE, LEAF_COORD_RX, LEAF_COORD_TY },
	NULL, NULL },
   { DISPLAY_WIN, LEAF_TYPE_WINDOW,
	{ LEAF_COORD_LX, LEAF_COORD_BY,
	     LEAF_COORD_RX, LEAF_COORD_NEXT(MENU_WIN) },
	NULL, NULL },
   LEAF_END
};





/************************************************************************/
/*									*/
/*	FPROF_win_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
FPROF_win_init()
{
   all_windows = NULL;
};





/************************************************************************/
/*									*/
/*	FPROF_create -- create a new make interface window		*/
/*									*/
/************************************************************************/


FPROF_WIN
FPROF_create(w,sys)
   ASH_WINDOW w;
   String sys;
{
   FPROF_WIN fw;

   fw = PALLOC(FPROF_WIN_INFO);
   fw->window = w;
   fw->willow_fg = FALSE;
   fw->disp_win = NULL;
   fw->system = sys;
   fw->edit_info = NULL;
   fw->pid = 0;
   fw->cmd_file = NULL;
   fw->data_file = NULL;
   fw->edit_info = NULL;
   fw->data = NULL;
   fw->topline = 1;

   PROTECT;
   all_windows = CONS(fw,all_windows);
   UNPROTECT;

   ASHset_window_id(w,"fprof");
   ASHset_window_defaults(w);

   if (fw->system == NULL) {
      if (!FPROF_menu_system(fw)) return NULL;
    };

   if (!setup_window(fw)) return NULL;

   FPROF_menu_setup(fw);
   FPROF_edit_setup(fw);
   FPROF_run_setup(fw);

   return fw;
};





/************************************************************************/
/*									*/
/*	FPROF_find_window -- find fprof window given ash window 	*/
/*									*/
/************************************************************************/


FPROF_WIN
FPROF_find_window(w)
   ASH_WINDOW w;
{
   Sequence l;
   FPROF_WIN fw;

   forin (fw,FPROF_WIN,l,all_windows) {
      if (fw->window == w) break;
      else if (fw->menu_win == w) break;
      else if (fw->disp_win == w) break;
    };

   return fw;
};





/************************************************************************/
/*									*/
/*	setup_window -- define the portions of a fprof window		*/
/*									*/
/************************************************************************/


static Boolean
setup_window(fw)
   FPROF_WIN fw;
{
   LEAFsetup_window(fw->window,fprof_leaf,fw);

   LEAFset_control(fw->window,fprof_control);
   LEAFredraw(fw->window);

   fw->menu_win = LEAFinq_window(fw->window,MENU_WIN,0);
   fw->disp_win = LEAFinq_window(fw->window,DISPLAY_WIN,0);

   if (fw->disp_win == NULL) {
      fprintf(stderr,"Window to small to run profile viewer\n");
      ASHremove(fw);
      return FALSE;
    };

   ASHset_control(fw->disp_win,fprof_edit_control);
   LEAFset_refresh(fw->window,check_windows);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	fprof_control -- handle ASH and other control messages		*/
/*									*/
/************************************************************************/


static int
fprof_control(msg,w)
   String msg;
   ASH_WINDOW w;
{
   FPROF_WIN fw;

   fw = FPROF_find_window(w);

   if (fw == NULL) return ASH_CONTROL_REJECT;

   if (STREQL(msg,"ASH$REMOVE")) {
      fprof_remove(fw);
    };

   return ASH_CONTROL_REJECT;
};





/************************************************************************/
/*									*/
/*	check_windows -- check for user doing a stupid resize		*/
/*									*/
/************************************************************************/


static void
check_windows(w)
   ASH_WINDOW w;
{
   FPROF_WIN fw;
   ASH_WINDOW dw;

   fw = FPROF_find_window(w);

   if (fw == NULL) return;

   dw = LEAFinq_window(w,DISPLAY_WIN,0);

   if (dw != fw->disp_win) {
      if (ASHinq_valid_window(w)) ASHremove(w);
    };
};





/********************************************************************************/
/*										*/
/*	fprof_edit_control -- handle control messages from editor		*/
/*										*/
/********************************************************************************/


static int
fprof_edit_control(msg,w)
   String msg;
   ASH_WINDOW w;
{
   FPROF_WIN fw;

   fw = FPROF_find_window(w);

   if (fw == NULL || fw->window == NULL) return ASH_CONTROL_REJECT;

   if (STREQL(msg,"EDIT$REMOVE")) {
      ASHremove(fw->window);
    };

   return ASH_CONTROL_REJECT;
};





/************************************************************************/
/*									*/
/*	fprof_remove -- remove given fprof window			*/
/*									*/
/************************************************************************/


static void
fprof_remove(fw)
   FPROF_WIN fw;
{
   PROTECT;

   all_windows = REMOB(fw,all_windows);

   UNPROTECT;

   fw->window = NULL;
};





/* end of fprofwin.c */
