/************************************************************************/
/*									*/
/*		fprof_local.h						*/
/*									*/
/*	Local definitions for profiling interface package		*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#define  PROT_NAME	FPROF__sema

#include <datatypes.h>
#include <sequence.h>
#include <ash.h>
#include <rip.h>
#include <stem.h>
#include <leaf.h>

#include <auxd.h>
#include <edt.h>
#include <msg.h>
#include <pmat.h>
#include <field.h>

#include <fprof.h>
#include "fprof_common.h"




/************************************************************************/
/*									*/
/*	Local Definitions						*/
/*									*/
/************************************************************************/


#define GPROF_NAME	"fieldgprof"

#define BUF_SIZE	1024





/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/



typedef struct _FPROF_WIN *	FPROF_WIN;
typedef struct _FPROF_LINE *	FPROF_LINE;



typedef enum _FPROF_ORDER {
   ORDER_SYMS,
   ORDER_TIME,
   ORDER_COUNT,
   ORDER_ALPHA,
} FPROF_ORDER;



typedef struct _FPROF_WIN {
   ASH_WINDOW	window;
   ASH_WINDOW	menu_win;
   ASH_WINDOW	disp_win;
   String	system;
   EDT_ID	edit_info;
   Boolean	willow_fg;
   Integer	pid;
   FILE *	cmd_file;
   FILE *	data_file;
   Character	outline[BUF_SIZE];
   FPROF_LINE	data;
   FPROF_ORDER	order;
   Integer	topline;
} FPROF_WIN_INFO;




typedef struct _FPROF_LINE {
   FPROF_LINE	next;
   FPROF_LINE	son;
   String	name;
} FPROF_LINE_INFO;





/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/


					/* fprofmain.c			*/
extern	void		FPROF_error();



					/* fprofwin.c			*/
extern	void		FPROF_win_init();
extern	FPROF_WIN	FPROF_create();
extern	FPROF_WIN	FPROF_find_window();



					/* fprofmenu.c			*/
extern	void		FPROF_menu_init();
extern	void		FPROF_menu_setup();
extern	Boolean 	FPROF_menu_system();



					/* fprofedit.c			*/
extern	void		FPROF_edit_init();
extern	void		FPROF_edit_setup();
extern	void		FPROF_edit_clear();
extern	void		FPROF_edit_remove();
extern	void		FPROF_edit_insert();
extern	void		FPROF_edit_save_top();
extern	void		FPROF_edit_goto_top();



					/* fprofrun.c			*/
extern	void		FPROF_run_init();
extern	void		FPROF_run_setup();
extern	void		FPROF_run_system();
extern	void		FPROF_run_update();
extern	void		FPROF_run_profile();
extern	void		FPROF_run_order();


					/* fprofdata.c			*/
extern	void		FPROF_data_init();
extern	void		FPROF_data_clear();
extern	void		FPROF_data_gather();
extern	Boolean 	FPROF_data_expand();





/* end of fprof_local.h */
