/************************************************************************/
/*									*/
/*		formmain.c						*/
/*									*/
/*	General routines for FORM configuration management front end	*/
/*									*/
/************************************************************************/
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/


#include "form_local.h"





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/


static	Boolean 	form_inited = FALSE;
	PROT_DECL;




/************************************************************************/
/*									*/
/*	FORMinit -- package initialization				*/
/*									*/
/************************************************************************/


void
FORMinit()
{
   PROT_INIT;
   PROTECT;
   if (!form_inited) {
      form_inited = TRUE;
      FORM_win_init();
      FORM_menu_init();
      FORM_trans_init();
      FORM_disp_init();

      FORM_attr_init();
      FORM_back_init();
      FORM_item_init();
      FORM_proj_init();
      FORM_setup_init();
      FORM_msg_init();

      FORM_setup_load();
      FORM_back_load();

      FORM_proj_find(MSGinq_wd());

      FORM_msg_start();
    };
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	FORMnew_window -- create a new form window			*/
/*	FORMnew_wm_window -- create a window from window manager	*/
/*									*/
/************************************************************************/


int
FORMnew_window(w,name)
   ASH_WINDOW w;
   String name;
{
   FORM_WIN fw;

   FORMinit();

   fw = FORM_create(w,name);

   return (fw != NULL);
};





int
FORMnew_wm_window(w)
   ASH_WINDOW w;
{
   FORM_WIN fw;

   FORMinit();

   fw = FORM_create(w,NULL);

   return (fw != NULL);
};





/************************************************************************/
/*									*/
/*	FORMnew_trans_window -- create a new form window		*/
/*	FORMnew_trans_wm_window -- create a window from window manager	*/
/*									*/
/************************************************************************/


int
FORMnew_trans_window(w,name)
   ASH_WINDOW w;
   String name;
{
   FORM_WIN fw;

   FORMinit();

   fw = FORM_create_trans(w,name);

   return (fw != NULL);
};





int
FORMnew_trans_wm_window(w)
   ASH_WINDOW w;
{
   FORM_WIN fw;

   FORMinit();

   fw = FORM_create_trans(w,NULL);

   return (fw != NULL);
};





/************************************************************************/
/*									*/
/*	FORM_error -- handle error's arising in FORM                    */
/*									*/
/************************************************************************/


void
FORM_error(msg,a1,a2,a3,a4)
   String msg;
   String a1,a2,a3,a4;
{
   fprintf(stderr,"FORM: ");
   fprintf(stderr,msg,a1,a2,a3,a4);
   fprintf(stderr,"\n");
   fflush(stderr);
};





/* end of formmain.c */
