/************************************************************************/
/*									*/
/*		flowmain.c						*/
/*									*/
/*	General routines for flow graph package 			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "flow_local.h"





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/


static	Boolean 	flow_inited = FALSE;
	PROT_DECL;




/************************************************************************/
/*									*/
/*	FLOW_init -- package initialization				*/
/*									*/
/************************************************************************/


void
FLOW_init()
{
   PROT_INIT;
   PROTECT;
   if (!flow_inited) {
      flow_inited = TRUE;
      MSGinit(FALSE);
      MSGservice_start("XREF",XREFinit,NULL,NULL);
      FLOW_win_init();
      FLOW_node_init();
      FLOW_disp_init();
      FLOW_menu_init();
      FLOW_info_init();
    };
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	FLOWnew_window -- create a new flow window			*/
/*	FLOWnew_wind_window -- create a window from wind		*/
/*									*/
/************************************************************************/


int
FLOWnew_window(w,name)
   ASH_WINDOW w;
   String name;
{
   FLOW_WIN fw;

   FLOW_init();

   fw = FLOW_create(w,name);

   return (fw != NULL);
};





int
FLOWnew_wind_window(w)
   ASH_WINDOW w;
{
   FLOW_WIN fw;

   FLOW_init();

   fw = FLOW_create(w,NULL);

   return (fw != NULL);
};





/* end of flowmain.c */
