/************************************************************************/
/*									*/
/*		flow_local.h						*/
/*									*/
/*	Local definitions for flow graph package			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#define  PROT_NAME	FLOW__sema

#include <datatypes.h>
#include <sequence.h>
#include <hashsearch.h>
#include <ash.h>
#include <rip.h>
#include <leaf.h>
#include <stem.h>
#include <wind.h>
#include <edt.h>

#include <auxd.h>
#include <gelo.h>
#include <msg.h>
#include <field.h>

#include <flow.h>
#include <xref.h>





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Local Definitions						*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/



typedef struct _FLOW_WIN *		FLOW_WIN;
typedef struct _FLOW_NODE *		FLOW_NODE;
typedef struct _FLOW_ARC *		FLOW_ARC;


typedef enum _FLOW_TRACE {
   FLOW_TRACE_NONE,
   FLOW_TRACE_ALL,
   FLOW_TRACE_DISPLAY,
} FLOW_TRACE;




typedef struct _FLOW_WIN {
   ASH_WINDOW window;
   String system;
   ASH_WINDOW menu_win;
   ASH_WINDOW disp_win;
   ASH_WINDOW flow_win;
   ASH_WINDOW text_win;
   FLOW_NODE root;
   FLOW_NODE main;
   FLOW_NODE maindisp;
   FLOW_NODE topdisp;
   Integer numconn;
   Integer maxconn;
   FLOW_ARC conns;
   Boolean display_all;
   Boolean display_force;
   Boolean display_callbys;
   Boolean display_callees;
   Boolean display_fixcur;
   Boolean display_conn;
   Boolean level_valid;
   Boolean conn_valid;
   Integer display_levels;
   Integer display_zoom;
   GELO_OBJECT gid;
   GELO_METHOD method;
   GELO_CONN_METHOD connmethod;
   Boolean fixed;
   Boolean standard;
   Boolean centered;
   Integer whitespace;
   Integer numnodes;
   Integer numarcs;
   FLOW_NODE selection;
   FLOW_NODE execute;
   RIP_REGION region;
   Sequence callstack;
   FLOW_TRACE tracemode;
   EDT_ID edit_info;
   HASH_TABLE hashtable;
} FLOW_WIN_INFO;



typedef enum _FLOW_NODE_TYPE {
   FLOW_TYPE_DIRECTORY,
   FLOW_TYPE_FILE,
   FLOW_TYPE_FUNCTION,
   FLOW_TYPE_ROOT,
} FLOW_NODE_TYPE;




typedef struct _FLOW_NODE {
   FLOW_NODE_TYPE type;
   String name;
   String dispname;
   String matchname;
   FLOW_NODE parent;
   FLOW_NODE brother;
   FLOW_NODE son;
   FLOW_NODE alt;
   Integer line;
   Integer arcin;
   Integer arcout;
   GELO_OBJECT gid;
   Integer infoline;
   Integer callby_level;
   Integer call_level;
   Boolean ignore;
   Boolean display;
   Boolean connected;
   Boolean expand;
} FLOW_NODE_INFO;




typedef struct _FLOW_ARC {
   FLOW_NODE from;
   FLOW_NODE to;
   Integer line;
   GELO_OBJECT gid;
} FLOW_ARC_INFO;





/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/


					/* flowmain.c		       */
extern	void		FLOW_init();



					/* flowwin.c		       */
extern	void		FLOW_win_init();
extern	FLOW_WIN	FLOW_create();
extern	FLOW_WIN	FLOW_find_window();
extern	FLOW_WIN	FLOW_find_system();



					/* flownode.c			*/
extern	void		FLOW_node_init();
extern	void		FLOW_node_setup();
extern	void		FLOW_node_file();
extern	FLOW_NODE	FLOW_node_find_function();
extern	void		FLOW_node_count_arcs();
extern	void		FLOW_node_connected();



					/* flowdisp.c			*/
extern	void		FLOW_disp_init();
extern	void		FLOW_disp_setup();
extern	void		FLOW_disp_reset();
extern	void		FLOW_disp_show();
extern	void		FLOW_disp_free();
extern	void		FLOW_disp_select();
extern	void		FLOW_disp_expand();
extern	void		FLOW_disp_compact();
extern	void		FLOW_disp_ignore();
extern	void		FLOW_disp_item();
extern	void		FLOW_disp_node_regex();



					/* flowmenu.c			*/
extern	void		FLOW_menu_init();
extern	void		FLOW_menu_setup();
extern	void		FLOW_menu_set_selection();
extern	void		FLOW_menu_setup_trace();



					/* flowinfo.c			*/
extern	void		FLOW_info_init();
extern	void		FLOW_info_setup();
extern	void		FLOW_info_node();






/* end of flow_local.h */
