.fo 'FIELD'- % -'Overview'
.po +0.5i
.ll 6.5i
.(l C
Overview of the FIELD Environment
.sp 1
Steven P. Reiss
.sp 1
Department of Computer Science
Brown University
Providence, RI 02912
.sp 1
November, 1987
.)l
.sp 2
.(l C
.b Introduction
.)l
.sp 1
.ls 1
.pp
FIELD (Friendly Integrated Environment for Learning and Development) is a
programming environment being developed at Brown University for use
in both an instructional and a research setting.  It is designed to accomplish
several goals:
.ip \(bu
It should provide a consistent visual interface to the tools already provided
by UNIX.
.ip \(bu
It should be simple to produce, requiring a minimal amount of effort to build
and maintain.
.ip \(bu
It should be simple and easy to use, requiring a minimal knowledge of UNIX for
unsophisticated programmers; it should also be powerful and complete, offering
full access to the software development tools provided by UNIX.
.ip \(bu
It should provide a consistent interface that is independent of the underlying
machine, enabling programmers to work on multiple machines simultaneously.
.ip \(bu
It should take full advantage of the software that has been developed at
Brown, notably data
structure display and animation.
.ip \(bu
It should be flexible and extensible to allow additional facilities to be
easily added as needed for either teaching or research purposes.
.lp
These goals were chosen to make the project both doable in a limited time
frame, worthwhile both for research and teaching, applicable to the new
workstations the department expects to obtain, and interesting enough to be
considered research.
.pp
FIELD consists of an integrated set of tools that communicate via a common
broadcast-style message facility.  This allows a wide range
of tools to coexist in a flexible environment.  FIELD tools are designed
to run on top of X11 window manager using the Brown Workstation Environment
(BWE) extensions
to the X toolkit and will be
compatible with other
X11-based tools.  The underlying message facility allows the tools to be run
as separate processes, using lightweight processes in a single
process, as a simple UNIX
process, or as any combination of these.  This facility also allows the
environment to be run on one machine, the user program to be run on another,
and the display to appear on a third, when this is desirable.  It also allows
pared-down versions of the environment to be easily put together for the
introductory courses.
.pp
The goal of a
software development environment is to provided controlled execution of a user
program in a framework where editing, compiling and execution are all
integrated.  FIELD provides controlled execution using its own interface to
the system-provided debugger.  It provides editing capabilities though a
flexible and extensible mouse-oriented base editor that is part of the Brown
Workstation Environment.  This editor is augmented with an annotation
interface that allows program and user-generated annotations to be associated
with the source code.  Compilation and system building will be provided
through a visual interface to \fImake\fP (actually \fIbuildmake\fP) and a
version control package (\fISCCS\fP or \fIRCS\fP).  Execution monitoring tools
are
being designed to either work directly off the debugger (i.e. stack and local
variable display; expression and variable monitoring).  Additional source
tools are contemplated via visual interfaces to UNIX search commands
(\fIgrep\fP), and program database facilities based on \fIcxref\fP,
\fIctabs\fP, and \fIpxref\fP.
.pp
In addition to providing visual interfaces to most of the functionality of
UNIX as a programming environment, FIELD will use the graphical facilities
that have been developed for the GARDEN conceptual programming system to
provide dynamic displays of
user data structures.  This facility provides the capability to quickly
display complex data structures in a natural way.  It was designed for GARDEN,
but was written to be independent of any particular structure representation.
We plan to develop the appropriate interfaces to tie it to Pascal and C using
the structure information provided through the Unix debuggers.  In conjunction
with a database and a semi-intelligent system for mapping from the database to
the user's data structures, this system should provide a powerful facility.
It will let the programmer browse through (and edit if desired) a graphical
view of his data.  Moreover, this view can be set up to automatically update
as the program executes.
.pp
FIELD will also provide a tie-in to the new version of the BALSA algorithm
animation package being deveoped at Brown.  This package is driven by events
that are associated with locations in the program.  FIELD will allow the
user to use the mouse to dynamically specify these associations, and will
provide the appropriate event stream to BALSA.  Thus, the user will be able to
use all the normal FIELD facilities to control and inspect his program, while
at the same time, viewing high-quality BALSA displays of his algorithms in
action.  In addition FIELD will be augmented with packages for scripting and
for more detailed program animations to provide an environment for classroom
demonstrations.
.pp
Considerable emphasis is being placed on making FIELD easy to use for both
naive and for sophisticated users.  The various FIELD tools will present a
consistent and common-sense interface to the user.  All text being displayed
will use a common base editor, allowing the user to cut and paste between
windows and to select expressions, names, etc. in any window on the display.
The data structure display tools will use a common graphical editor,
providing consistent user interaction with structure displays that show
make dependencies, user data structures, or call graphs.  All the tools will
use the same menu and dialogue box-style interface.  In addition, a common
help
facility will allow the user to request additional information on any button
or object being displayed.
.(l C
.b Tools
.)l
.pp
The integration mechanism used by FIELD is a message system that acts like an
intelligent telephone switchboard.  Each FIELD tool will send out messages in
well-known formats describing what it is doing.  For example, the debugger
sends out messages indicating the current debugger focus, the currently
executing source line, the current call stack, and the values of traced
variables when they change.  Moreover, each FIELD tool provides a
message-based interface to its functionality.  Each debugger command can be
activated by an appropriate message; annotations in the editor can be set and
removed via messages.
The message interface is designed to allow arbitrary messages while
simplifying their processing.  This is accomplished by having each tool
register a set of message patterns when they begin.  When a message is sent,
it is compared to each of the patterns that has been registered, and is only
forwarded to those tools whose patterns match.  The pattern matching mechanism
that is provided is a powerful extension of UNIX-style \fIscanf\fP strings.
.pp
The FIELD debugger tool is the most complex in the environment.  It
attempts to provide a powerful and complete debugger that is both language and
machine independent.  It does this by providing a consistent \fIdbx\fP-like
front end to whatever source-level debugger is provided with the underlying
system.  This tool consists of three components.  The first provides a
textual language interface that is an extended combination of the various
versions of \fIdbx\fP that are
currently extant.  This reads input from an input tty, parses it, and
generates appropriate command messages through the message server.
The second component provides a message interface that allows other
portions of the FIELD environment to easily (and quietly) interface to the
user program.
This component receives messages, maps them into appropriate
commands for the system debugger running the user program, and then interprets
the output of the system debugger and generates textual output for the
user and messages for other system tools as appropriate.  The third
component
of the debugger
is a visual front end that uses the BWE base editor for textual
input and output and that provides arbitrary, user-definable mouse buttons for
a simple debugger interface.
.pp
The FIELD annotation editor provides an annotated view of a source file.  It
provides a complete base editor on the source file in the center of a window,
an annotation selection area on the right, and an annotation window on the
left.  Each line of the source can have one or more associated annotations.
These can range from breakpoint or trace indicators, to compiler error
and warning flags, to BALSA-style interesting events, to the current executing
line or debugger focus.  Annotations can be program generated (triggered by an
appropriate message), can be user generated, or can be user-triggered and then
program generated.  When the user triggers a break annotation, for example,
the annotation editor sends the appropriate message requesting a break point
to the debugger.  The debugger, if the breakpoint is successfully set, sends
an ADD EVENT message to all interested parties, one of which is the annotation
editor which will then display the BREAK annotation.  Each annotation can have
associated information that can be requested by the user.  This is used for
error annotations, for example, to provide the user with the exact error
message and possibly information about that error.
.pp
The FIELD viewer tool provides the capability to monitor and display
information that is sent out as messages.  Different viewers can be
constructed for different classes of messages.  There are currently three
viewers set up using this tool.  The first monitors messages describing the
current stack and the values of local variables.  The second monitors messages
describing all current events such as breakpoints, traced lines and monitored
variables.  The third monitors trace messages, providing a display of the
current values of all traced variables.
.pp
The FIELD interface to \fImake\fP will provide a simple, menu-oriented
interface that will relieve the user from many of the problems encountered in
using \fImake\fP.  It will generate appropriate makefiles from a user
specification of the files composing the system and the desired commands.  It
will also have the capability to let the user describe his system graphically
by editing a data-structure display of the dependency structure of the system.
We are also attempting to provide an automatic interface to an underlying
source code control system, and appropriate message interfaces so that
compilation can be requested from the editor or debugger or be done
automatically when a file is changed.
.pp
The \fIgprof\fP interface will provide profiling information about the user's
currently running system in a variety of forms.  It will be able to  display a
histogram of execution times at various levels of granularity ranging from
files to source lines.  It will be able to display normal \fIprof\fP output
sorted by frequency or in file-order.  It should also be able to generate
annotations for the annotation editor for heavily used portions of the source.
It will have an interface to the debugger that will allow profiling
information to be gathered from the running system as needed, either whenever
the system stops, or every \fIk\fP seconds of run time for some \fIk\fP.  It
will
also
be
able to do a complete profile once the system has terminated.
.pp
FIELD allows multiple copies of most of these tools to be running
simultaneously.  The user can have multiple editors on different source files,
each with multiple views on different portions of the files.  Multiple process
programs can be handled using multiple debugger interfaces.  Different profile
views can be associated with different running systems.
.pp
FIELD is a flexible environment and the tools noted here are not meant to
express its limits.  We hope to provide tools that can easily be integrated
into the common environment as they are requested by the user community.  We
also hope to tie into existing research projects such as the
lightweight processes
debugging and profiling tools, algebra-based animation packages, and the
object-oriented database system.
.(l C
.b Usage
.)l
.pp
A simplified version of FIELD will be made available for the introductory
programming courses.  This will offer a single annotation editor on the source
file, a debugger view with buttons for all the operations that might be
performed, and a view window for variables.  The \fImake\fP tool would be part
of the system, but would not require a visual interface.  FIELD would be used
for algorithm animation in the introductory courses by augmenting this basic
system with custom-build renderers and a scripting package.
.pp
As students become more sophisticated, additional FIELD tools could be
made available.  Once they start working with complex data structures,
they could be given access to
a simplified version of the data structure display facility.
This would provide displays of a fixed set of structures, notably the ones
that would be taught in the courses, with a minimum of user interaction. A
stack view could be provided when recursion is introduced.
.pp
In more advanced courses, additional tools could be introduced.  In the
algorithms and data structures course the students could use the full power of
the data structure display tools, designing their own data structure displays
interactively.  The textual debugger interface could also be provided here
since it offers more flexibility and power than the simple button interface.
In the first software engineering course, the student could be introduced to
the \fImake\fP and profiling interfaces.  In addition, advanced systems
courses could make use of specialty versions of the tools.  The operating
systems course which teaches about lightweight processes could use the FIELD
interface to debug and understand them.  The compiler course could use special
monitoring tools that would illustrate the students' compilers in action.  The
database course could offer similar interfaces to show how the students'
database systems work.
.pp
The FIELD environment is also intended for research purposes.  It could be
used both as a research vehicle and as a new tool.  As a vehicle, it could be
used to explore different ways to provide the information that users want
while debugging.  For example, it should be possible to keep enough
information to describe the tree of assignments that leads to a particular
variable getting assigned a wrong value, thus allowing the user to more easily
isolate the point of error.  It could be used to explore ways of controlling
and understanding parallel programs, both with standard and with lightweight
processes.  It could also be used as a means for understanding how color and 3
dimensional graphics can best be used in a programming environment.
.pp
As a research tool, FIELD could be used extensively by graduate students and
faculty at BROWN for developing a wide variety of software systems, ranging
from FIELD itself, to object-oriented databases, to realistic 3-D animation
graphics, to incremental and optimizing compilers.  In this capacity, it is
essential that FIELD offer at least the full capabilities of the underlying
UNIX programming environment.
.(l C
.b Status
.)l
.pp
A prototype version of the FIELD system is currently under development.  The
underlying message facility as well as the more basic tools, including the
debugger, the annotation editor, and the viewing tool, have been written and
integrated.  Additional tools, including the \fImake\fP and profiling
interfaces as well as data structure display are in various stages of
development.  We expect that a completed prototype will be available for use
as a research tool in the spring of 1988.
