/************************************************************************/
/*									*/
/*		disppear.c						*/
/*									*/
/*	PEAR interface for displaying data structures package		*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "disp_local.h"
#include <edt.h>





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	int		disp_pear_request();
static	int		disp_pear_value();
static	int		disp_pear_assign();
static	int		disp_pear_insert();
static	int		disp_pear_insarc();
static	int		disp_pear_remove();
static	int		disp_pear_delarc();
static	int		disp_pear_select();
static	int		disp_pear_update();
static	int		disp_pear_typein();
static	int		disp_pear_depend();
static	int		disp_pear_eval();
static	int		disp_pear_conn();
static	int		disp_pear_hit();
static	int		disp_pear_cupd();
static	int		disp_pear_refresh();

static	Boolean 	get_user_value();





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	DISP_pear_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
DISP_pear_init()
{
   PEARregister_interface(disp_pear_request,
			     disp_pear_value,
			     disp_pear_assign,
			     disp_pear_insert,
			     disp_pear_insarc,
			     disp_pear_remove,
			     disp_pear_delarc,
			     disp_pear_select,
			     disp_pear_update,
			     disp_pear_typein,
			     disp_pear_depend,
			     disp_pear_eval,
			     disp_pear_conn,
			     disp_pear_hit,
			     disp_pear_cupd,
			     disp_pear_refresh);
};





/************************************************************************/
/*									*/
/*	DISP_pear_setup -- set up a pear window 			*/
/*									*/
/************************************************************************/


void
DISP_pear_setup(dw)
   DISP_WIN dw;
{
   String s;
   AUXD hdl;

   if (dw->have_pear) PEARremove(dw->pear_win);

   if (dw->variable == NULL || dw->pear_win == NULL) return;

   DISP_flush_cache(dw);

   PEARedit(dw->pear_win,dw->var_addr,dw->var_type,dw);

   hdl = AUXDget_handle(NULL,"DISP");
   PEARmenu_quit(dw->pear_win);

   dw->have_pear = TRUE;
};




/************************************************************************/
/*									*/
/*	DISP_pear_update -- update a pear window			*/
/*									*/
/************************************************************************/


void
DISP_pear_update(dw)
   DISP_WIN dw;
{
   if (ASHinput_lock(dw->window,FALSE) != ASH_LOCK_GRANTED) return;
   DISP_flush_cache(dw);
   ASHinput_unlock(dw->window);

   if (dw->pear_win != NULL && dw->have_pear) {
      if (PEARupdate(dw->pear_win)) dw->update = FALSE;
    };
};





/************************************************************************/
/*									*/
/*	disp_pear_request -- request value from user for PEAR		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_request(w,t,vp,tp)
   ASH_WINDOW w;
   DISP_TYPE t;
   DISP_OBJECT * vp;
   DISP_TYPE * tp;
{
   register Boolean fg;

   fg = FALSE;

   return fg;
};





/************************************************************************/
/*									*/
/*	disp_pear_value -- get value from source/field/index triple	*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_value(src,fld,idx,acttypfg,vp,tp)
   DISP_OBJECT src;
   DISP_OBJECT fld;
   Integer idx;
   Boolean acttypfg;
   DISP_OBJECT * vp;
   DISP_TYPE * tp;
{
   return FALSE;
};





/************************************************************************/
/*									*/
/*	disp_pear_assign -- assign to a standard field			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_assign(w,src,df,idx,typ,v,t,valfg,copyfg,autofg)
   ASH_WINDOW w;
   DISP_OBJECT src;
   DISP_FIELD df;
   Integer idx;
   DISP_TYPE typ;
   DISP_OBJECT v;
   DISP_TYPE t;
   Boolean valfg;
   Boolean copyfg;
   Boolean autofg;
{
   Character buf[1024],vbuf[1024],tbuf[1024];
   String s;
   Boolean fg;
   DISP_WIN dw;

   dw = DISP_find_window(w);
   if (dw == NULL) return FALSE;

   src = (DISP_OBJECT) DISP_var_addr(src);
   v = (DISP_OBJECT) DISP_var_addr(v);

   if (valfg) {
      if (t != NULL) {
	 s = DISP_expr_type_name(t,tbuf);
	 sprintf(vbuf,"*((%s *)(0x%x))",s,v);
       }
      else {
	 sprintf(vbuf,"((%s)(0))",typ->name);
       };
    }
   else {
      if (!get_user_value(dw,typ,vbuf)) return FALSE;
    };

   if (df != NULL) {
      s = DISP_expr_type_name(df->base,tbuf);
      sprintf(buf,"(*(%s **)(0x%x))->%s",s,src,df->name);
    }
   else if (idx >= 0) {
      s = DISP_expr_type_name(typ,tbuf);
      sprintf(buf,"((%s *) 0x%x)[%d]",s,src,idx);
    }
   else {
      s = DISP_expr_type_name(typ,tbuf);
      sprintf(buf,"(*(%s *)(0x%x))",s,src);
    };

   fg = DISP_set_value(dw->system,buf,vbuf);

   if (fg) DISP_flush_cache(dw);

   return fg;
};






/************************************************************************/
/*									*/
/*	disp_pear_insert -- handle inserting node into layout		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_insert(v,src,fld,idx,val,valfg,copy,after,first)
   DISP_OBJECT v;
   DISP_OBJECT src;
   DISP_OBJECT fld;
   Integer idx;
   DISP_OBJECT val;
   Boolean valfg;
   Boolean copy;
   Boolean after;
   Boolean first;
{
   return FALSE;
};






/************************************************************************/
/*									*/
/*	disp_pear_remove -- remove item from layout			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_remove(src,fld,idx)
   DISP_OBJECT src;
   DISP_OBJECT fld;
   Integer idx;
{
   return FALSE;
};





/************************************************************************/
/*									*/
/*	disp_pear_insarc -- handle inserting arc  into layout		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_insarc(v,src,fld,idx,dsrc,dfld,didx)
   DISP_OBJECT v;
   DISP_OBJECT src;
   DISP_OBJECT fld;
   Integer idx;
   DISP_OBJECT dsrc;
   DISP_OBJECT dfld;
   Integer didx;
{
   return FALSE;
};






/************************************************************************/
/*									*/
/*	disp_pear_delarc -- handle deleting arc from layout		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_delarc(v,src,fld,idx,dsrc,dfld,didx)
   DISP_OBJECT v;
   DISP_OBJECT src;
   DISP_OBJECT fld;
   Integer idx;
   DISP_OBJECT dsrc;
   DISP_OBJECT dfld;
   Integer didx;
{
   return FALSE;
};






/************************************************************************/
/*									*/
/*	disp_pear_select -- handle user selection			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_select(v,btn,fg)
   DISP_OBJECT v;
   Integer btn;
   Boolean fg;
{
   return FALSE;
};






/************************************************************************/
/*									*/
/*	disp_pear_update -- update (compile) for user structure 	*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_update(v,forcefg)
   DISP_OBJECT v;
   Boolean forcefg;
{
   return FALSE;
};






/************************************************************************/
/*									*/
/*	disp_pear_typein -- handle function key commands		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_typein(key,obj1,obj2,obj3,parobj)
   Integer key;
   DISP_OBJECT obj1,obj2,obj3,parobj;
{
   return FALSE;
};






/************************************************************************/
/*									*/
/*	disp_pear_depend -- handle dependency notifications	      */
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_depend(w,obj,fg)
   ASH_WINDOW w;
   DISP_OBJECT obj;
   Boolean fg;
{
   return FALSE;
};





/************************************************************************/
/*									*/
/*	disp_pear_eval -- handle evaluation requests		      */
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_eval(obj,type)
   DISP_OBJECT obj;
   Integer type;
{
   return FALSE;
};





/************************************************************************/
/*									*/
/*	disp_pear_conn -- handle port connection requests		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_conn(from,to,arc,tofg,portp,sportp)
   DISP_OBJECT from;
   DISP_OBJECT to;
   DISP_OBJECT arc;
   Boolean tofg;
   GELO_PORT * portp;
   Integer * sportp;
{
   return FALSE;
};





/************************************************************************/
/*									*/
/*	disp_pear_hit -- handle user requests in window 	      */
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_hit(w,x,y,ch,btn)
   ASH_WINDOW w;
   Integer x,y;
   Integer ch;
   Integer btn;
{
   return FALSE;
};





/************************************************************************/
/*									*/
/*	disp_pear_cupd -- command update request			*/
/*	handle_cmd_depend -- handle command dependency			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
disp_pear_cupd(pd)
   Integer pd;
{
   return FALSE;
};





/************************************************************************/
/*									*/
/*	disp_pear_refresh -- handle refresh of pear window		*/
/*									*/
/************************************************************************/


static int
disp_pear_refresh(w)
   ASH_WINDOW w;
{
   DISP_WIN dw;

   dw = DISP_find_window(w);

   DISP_flush_cache(dw);

   return 0;
};





/************************************************************************/
/*									*/
/*	get_user_value -- get value from user for given type		*/
/*									*/
/************************************************************************/


static Boolean
get_user_value(dw,typ,vbuf)
   DISP_WIN dw;
   DISP_TYPE typ;
   String vbuf;
{
   Character buf[10240];
   Integer fg;

   sprintf(buf,"%%CEnter value of type %s\n\n%%0.48t\n\n",typ->name);

   if (typ->class == DISP_TYPE_POINTER) {
      strcat(buf,"%1.1o malloc() new instance of type\n");
      strcat(buf,"%1.2o Null value of type\n");
    };

   strcat(buf,"\n   %a%M   %c");

   vbuf[0] = 0;
   fg = 0;
   if (!STEMdialog1(dw->pear_win,buf,vbuf,&fg)) return FALSE;

   if (vbuf[0] != 0) fg = 0;

   if (fg == 1) {
      sprintf(vbuf,"((%s) malloc(sizeof(%s)))",typ->name,typ->base->name);
    }
   else if (fg == 2) {
      sprintf(vbuf,"((%s) 0)",typ->name);
    };

   if (vbuf[0] == 0) return FALSE;

   return TRUE;
};





/* end of disppear.c */

