/************************************************************************/
/*									*/
/*		dispexpr.c						*/
/*									*/
/*	Expression routines for display editors 			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "disp_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	void			convert_type();





/************************************************************************/
/*									*/
/*	DISP_expr_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
DISP_expr_init()
{
};





/************************************************************************/
/*									*/
/*	DISP_expr_value -- get DDT expression for value 		*/
/*									*/
/************************************************************************/


void
DISP_expr_value(o,typ,df,idx,buf)
   DISP_OBJECT o;
   DISP_TYPE typ;
   DISP_FIELD df;
   Integer idx;
   String buf;
{
   Character tbuf[1024];
   String s;

   if (df == NULL && typ == NULL) {
      sprintf(buf,"??? 0x%x ???",o);
    }
   else if (df == NULL) {
      s = DISP_expr_type_name(typ,tbuf);
      sprintf(buf,"*((%s *)(0x%x))",s,o);
    }
   else {
      convert_type(o,typ,df->base,tbuf);
      sprintf(buf,"(%s).%s",tbuf,df->name);
    };

   if (idx >= 0) {
      sprintf(tbuf,"((%s)[%d])",buf,idx);
      strcpy(buf,tbuf);
    };
};





/********************************************************************************/
/*										*/
/*	DISP_expr_type_name -- fix type name for ddt printing			*/
/*										*/
/********************************************************************************/


String
DISP_expr_type_name(typ,buf)
   DISP_TYPE typ;
   String buf;
{
   String s;
   Character tbuf[1024];

   if (typ->class != DISP_TYPE_ARRAY) return typ->name;

   s = DISP_expr_type_name(typ->base,tbuf);
   strcpy(buf,s);
   strcat(buf," *");

   return buf;
};







/************************************************************************/
/*									*/
/*	convert_type -- get DDT expression for type conversion		*/
/*									*/
/************************************************************************/


static void
convert_type(o,ftyp,ttyp,buf)
   DISP_OBJECT o;
   DISP_TYPE ftyp;
   DISP_TYPE ttyp;
   String buf;
{
   Character tbuf[1024],sbuf[1024];
   String s;

   s = DISP_expr_type_name(ftyp,sbuf);
   sprintf(tbuf,"*((%s *)(0x%x))",s,o);

   while (ftyp != ttyp) {
      switch (ftyp->class) {
	 case DISP_TYPE_SAME :
	    ftyp = ftyp->base;
	    break;
	 case DISP_TYPE_ARRAY :
	 case DISP_TYPE_POINTER :
	    sprintf(sbuf,"*(%s)",tbuf);
	    strcpy(tbuf,sbuf);
	    ftyp = ftyp->base;
	    break;
	 default :
	    ftyp = ttyp;
	    break;
       };
    };

   strcpy(buf,tbuf);
};





/* end of dispexpr.c */
