/************************************************************************/
/*									*/
/*		disp_local.h						*/
/*									*/
/*	Local definitions for data structure display package		*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#define  PROT_NAME	DISP__sema

#include <datatypes.h>
#include <sequence.h>
#include <ash.h>
#include <stem.h>
#include <gelo.h>
#include <apple.h>
#include <apple_gelo.h>
#include <pear.h>

#include <auxd.h>
#include <msg.h>
#include <pmat.h>
#include <field.h>

#include <disp.h>





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define UNDEF_ADDR(i)	(0xb3000081+((i)<<8))
#define TEST_UNDEF(x)	(((x) & 0xff0000ff) == 0xb3000081)




/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/


typedef struct _DISP_WIN *	DISP_WIN;
typedef struct _DISP_TYPE *	DISP_TYPE;
typedef struct _DISP_FIELD *	DISP_FIELD;
typedef struct _DISP_CACHE *	DISP_CACHE;
typedef Univ_Ptr		DISP_OBJECT;




typedef enum _DISP_SHOW {
   DISP_SHOW_APPLE,
   DISP_SHOW_PEAR,
   DISP_SHOW_BOTH,
} DISP_SHOW;




typedef enum _DISP_TYPE_CLASS {
   DISP_TYPE_UNKNOWN,
   DISP_TYPE_PRIMITIVE,
   DISP_TYPE_SAME,
   DISP_TYPE_ENUM,
   DISP_TYPE_ARRAY,
   DISP_TYPE_POINTER,
   DISP_TYPE_RECORD,
   DISP_TYPE_UNION,
   DISP_TYPE_VARREC,
   DISP_TYPE_SET,
   DISP_TYPE_FILE,
} DISP_TYPE_CLASS;





typedef struct _DISP_WIN {
   ASH_WINDOW window;
   ASH_WINDOW apple_win;
   String system;
   String variable;
   String file;
   String func;
   Sequence all_types;
   Integer var_addr;
   DISP_TYPE var_type;
   APPLE_ID apple_id;
   ASH_WINDOW pear_win;
   DISP_TYPE type;
   Boolean have_pear;
   DISP_SHOW show_type;
   Boolean nested;
   Boolean usedb;
   Boolean simple;
   Boolean update;
} DISP_WIN_INFO;





typedef struct _DISP_TYPE {
   String system;
   String name;
   String file;
   String func;
   DISP_TYPE_CLASS class;
   Integer count;
   Integer count0;
   Sequence fields;
   String enumbase;
   DISP_TYPE base;
   Boolean nested;
   Boolean usedb;
   Boolean user;
   Integer usecount;
   APPLE_GELO_OBJECT drawinfo;
} DISP_TYPE_INFO;





typedef struct _DISP_FIELD {
   String name;
   DISP_TYPE type;
   DISP_TYPE base;
} DISP_FIELD_INFO;




typedef struct _DISP_CACHE {
   String system;
   String expr;
   String value;
   DISP_CACHE next;
} DISP_CACHE_INFO;





/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/


					/* dispmain.c		       */
extern	void		DISP_init();



					/* dispwin.c		       */
extern	void		DISP_win_init();
extern	DISP_WIN	DISP_create();
extern	DISP_WIN	DISP_find_window();
extern	DISP_WIN	DISP_find_window_by_addr();
extern	DISP_TYPE	DISP_find_defined_type();
extern	void		DISP_clear_type();



					/* dispddt.c			*/
extern	void		DISP_ddt_init();
extern	Boolean 	DISP_var_info();
extern	Integer 	DISP_var_addr();
extern	DISP_TYPE	DISP_find_type();
extern	void		DISP_get_value();
extern	Boolean 	DISP_set_value();
extern	void		DISP_flush_cache();



					/* dispapple.c			*/
extern	void		DISP_apple_init();
extern	void		DISP_apple_setup();




					/* disppear.c			*/
extern	void		DISP_pear_init();
extern	void		DISP_pear_setup();
extern	void		DISP_pear_update();



					/* dispexpr.c			*/
extern	void		DISP_expr_init();
extern	void		DISP_expr_value();
extern	String		DISP_expr_type_name();


					/* dispdb.c			*/
extern	void		DISP_db_init();
extern	void		DISP_db_store();
extern	void		DISP_db_load();





/* end of disp_local.h */

