/************************************************************************/
/*									*/
/*		ddtmain.c						*/
/*									*/
/*	General routines for debugger interface 			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "ddt_local.h"





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/


	Boolean 	DDT__standalone;
	Boolean 	DDT__norun;
	Integer 	DDT__cplusplus;
	Boolean 	DDT__stdpascal;
	Boolean 	DDT__use_gdb;
	Integer 	DDT__picklevel;

static	Boolean 	ddt_inited = FALSE;
	PROT_DECL;




/************************************************************************/
/*									*/
/*	DDT_init -- package initialization				*/
/*									*/
/************************************************************************/


void
DDT_init()
{
   Character buf[128];
   AUXD hdl;

   PROT_INIT;
   PROTECT;
   if (!ddt_inited) {
      ddt_inited = TRUE;

      MSGrundata_name("ddt.auxd",buf);
      AUXDuse(buf);
      hdl = AUXDget_handle(NULL,"DDT");
      if (AUXDget_defined(hdl,"GDB")) DDT__use_gdb = TRUE;

      DDT_monitor_init();
      DDT_state_init();
      DDT_trace_init();
      DDT_model_init();
      DDT_event_init();
      DDT_msg_init();
      DDT_symbol_init();
      DDT_cplus_init();
      DDT_x_init();
      DDT_run_init();
      DDT_lang_init();
      DDT_expr_init();
      DDT_map_init();
      DDT_input_init();

      MSGwait_fct(DDT_state_next);
    };
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	main -- main program						*/
/*									*/
/************************************************************************/


main(argc,argv)
   Integer argc;
   String argv[];
{
   String s,file,core,context;
   register Integer i;
   Boolean local,debug;

   file = NULL;
   core = NULL;
   context = NULL;
   DDT__standalone = TRUE;
   DDT__norun = FALSE;
   DDT__cplusplus = NOCPLUSPLUS;
   DDT__use_gdb = FALSE;
   DDT__stdpascal = FALSE;
   DDT__picklevel = 1;
   local = TRUE;
   debug = FALSE;

   s = rindex(argv[0],'/');
   if (s != NULL) ++s;
   else s = argv[0];

   if (s[0] == 'g') DDT__use_gdb = TRUE;
   else if (getenv("USE_GDB") != NULL) DDT__use_gdb = TRUE;
   if (getenv("STDPASCAL") != NULL) DDT__stdpascal = TRUE;


   s = getenv("FIELD_DIR");
#ifdef FIELD_DIRECTORY
   if (s == NULL) s = FIELD_DIRECTORY;
#endif
   if (s != NULL) BWEset_local_project(s);

   argc = MSGset_application(argc,argv);

   for (i = 1; i < argc; ++i) {
      if (argv[i][0] == '-') {
	 switch (argv[i][1]) {
	    case 'c' :
	       if (i+1 < argc) context = argv[++i];
	       break;
	    case 'n' :
	       DDT__norun = TRUE;
	       break;
	    case 'u' :
	       if (i+1 < argc) AUXDuse(argv[++i]);
	       break;
	    case 'f' :
	       DDT__standalone = FALSE;
	       local = FALSE;
	       break;
	    case 'C' :
	       if (argv[i][2] == '1') DDT__cplusplus = CPLUSPLUS12;
	       else DDT__cplusplus = CPLUSPLUS20;
	       break;
	    case 'g' :
	       DDT__use_gdb = TRUE;
	       break;
	    case 's' :
	       DDT__stdpascal = TRUE;
	       break;
	    case 'l' :
	       local = TRUE;
	       break;
	    case 'D' :
	       debug = TRUE;
	       break;
	    case 'p' :
	       if (isdigit(argv[i][2])) DDT__picklevel = atol(&argv[i][2]);
	       else DDT__picklevel = 2;
	       break;
	    default :
	       printf("%s [-C] [-g] [-s] [-p] file core [-u use_file]\n",argv[0]);
	       exit(1);
	  };
       }
      else if (file == NULL) file = argv[i];
      else if (core == NULL) core = argv[i];
      else {
	 printf("%s file core [-u use_file]\n",argv[0]);
	 exit(1);
       };
    };

   if (local) MSGlocal_init(debug);
   else MSGinit(debug);
   if (debug) putenv("DDT_DEBUG=TRUE");

   DDT_init();

   if (!DDT__norun && !DDT_start_debug(file,core)) {
      printf("Couldn't start debugger\n");
      exit(0);
    }
   else if (DDT__norun) {
      if (file == NULL) {
	 printf("Must specify file for extra view option\n");
	 exit(0);
       };
      DDTLANG_set_system(file,0);
      DDT_lang_startup();
      DDTLANG_set_output(TRUE);
    };

   if (context != NULL) DDTLANG_set_context(context);

   DDT_lang_loop();
};





/* end of ddtmain.c */
