/************************************************************************/
/*									*/
/*		ddtlanghelp.c						*/
/*									*/
/*	Handle help commands -- read the DDT help file and print it	*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "ddtlang_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	FILE *		help_file;





/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	DDTLANG_help_init -- module initialization			*/
/*									*/
/************************************************************************/


void
DDTLANG_help_init()
{
   help_file = NULL;
};





/************************************************************************/
/*									*/
/*	DDTLANG_help -- print help information				*/
/*									*/
/************************************************************************/


void
DDTLANG_help(what)
   String what;
{
   Character buf[10240];
   Boolean ok;
   Integer ln;

   if (help_file == NULL) {
      MSGrundata_name("ddt.help",buf);
      help_file = fopen(buf,"r");
    };

   if (help_file == NULL) {
      printf("No help information available\n");
      return;
    };

   rewind(help_file);

   if (what == NULL) ok = TRUE;
   else ok = FALSE;

   while (fgets(buf,10240,help_file) != NULL) {
      if (buf[0] != '$') {
	 if (ok) printf("%s",buf);
       }
      else if (ok) break;
      else {
	 ln = strlen(buf);
	 buf[ln-1] = 0;
	 if (STREQL(what,&buf[1])) ok = TRUE;
       };
    };

   if (!ok) {
      printf("No help information available on %s\n",what);
    };
};





/* end of ddtlanghelp.c */
