/************************************************************************/
/*									*/
/*		ddtlang_local.h 					*/
/*									*/
/*	Local definitions for debugger interface			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/




#include "ddt_local.h"




/************************************************************************/
/*									*/
/*	Data types							*/
/*									*/
/************************************************************************/


typedef struct _DDT_CMD *	DDT_CMD;
typedef struct _DDT_VAR *	DDT_VAR;


typedef enum _DDT_CMD_TYPE {
   CMD_TYPE_EVAL,
   CMD_TYPE_WHILE,
   CMD_TYPE_IF,
   CMD_TYPE_END,
   CMD_TYPE_ERROR,
   CMD_TYPE_LOOPEXIT,
   CMD_TYPE_SEND,
   CMD_TYPE_ELSE,
   CMD_TYPE_SAVE,
} DDT_CMD_TYPE;



typedef enum _DDT_CMD_RESULT {
   CMD_RESULT_NONE,
   CMD_RESULT_OK,
   CMD_RESULT_NOK,
   CMD_RESULT_ERROR,
   CMD_RESULT_LOOPEXIT,
} DDT_CMD_RESULT;




typedef struct _DDT_CMD {
   DDT_CMD_TYPE type;
   Sequence args;		/* of strings		*/
} DDT_CMD_INFO;



typedef struct _DDT_VAR {
   String name;
   String contents;
} DDT_VAR_INFO;





/************************************************************************/
/*									*/
/*	Routine definitions						*/
/*									*/
/************************************************************************/


				/* ddtlangsyn.y 			*/
extern	void		DDTLANG_nest();
extern	void		DDTLANG_eval();
extern	String		DDTLANG_system_name();
extern	void		DDTLANG_set_system();
extern	void		DDTLANG_set_context();
extern	void		DDTLANG_set_output();



				/* ddtlangstmt.c			*/
extern	void		DDTLANG_stmt_init();
extern	DDT_CMD 	DDTLANG_statement();
extern	void		DDTLANG_add_args();
extern	void		DDTLANG_free_statement();
extern	DDT_CMD_RESULT	DDTLANG_eval_statement();
extern	String		DDTLANG_setup_when();



				/* ddtlanghelp.c			*/
extern	void		DDTLANG_help_init();
extern	void		DDTLANG_help();





/* end of ddtlang_local.h */
