/*	Copyright 1988 Brown University -- Steven P. Reiss		*/

%{

/************************************************************************/
/*									*/
/*		ddtexprsyn.y						*/
/*									*/
/*	DDT syntax for textual command language 			*/
/*									*/
/************************************************************************/

#include "ddt_local.h"

#undef ECHO




/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


%}



%union {
   String	strval;
}



%token <strval> 	LX_ID
%token <strval> 	LX_INT
%token <strval> 	LX_STRING
%token <strval> 	LX_FLT
%token <strval> 	LX_TYPEID

%token			LX_ERROR


%left		LX_OR
%left		LX_AND
%left		'|'
%left		'^'
%left		'&'
%left		LX_EQL LX_NEQ '='
%left		LX_GTR LX_GEQ LX_LSS LX_LEQ
%left		LX_LSH LX_RSH
%left		'+' '-'
%left		'*' '/' '%' LX_MOD LX_DIV
%right		LX_SIZEOF LX_UNARY '.'
%left		'('

%token		LX_DOTDOT LX_PTS
%token		LX_STRUCT LX_UNION LX_ENUM LX_UNSIGNED

%type	<strval>	expr primary expr_list type_name type


%start	scan


%%

scan	:	expr
			{ set_result($1); }
	;


expr	:	expr	'|'     expr
			{ $$ = expr_build($1,TRUE,"|",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	LX_OR	expr
			{ $$ = expr_build($1,TRUE,"|",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	'^'     expr
			{ $$ = expr_build($1,TRUE,"^",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	'&'     expr
			{ $$ = expr_build($1,TRUE,"&",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	LX_AND	expr
			{ $$ = expr_build($1,TRUE,"&",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	LX_EQL	expr
			{ $$ = expr_build($1,TRUE,"==",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	'='     expr
			{ $$ = expr_build($1,TRUE,"==",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	LX_NEQ	expr
			{ $$ = expr_build($1,TRUE,"!=",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	LX_LSS	expr
			{ $$ = expr_build($1,TRUE,"<",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	LX_GTR	expr
			{ $$ = expr_build($1,TRUE,">",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	LX_LEQ	expr
			{ $$ = expr_build($1,TRUE,"<=",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	LX_GEQ	expr
			{ $$ = expr_build($1,TRUE,">=",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	LX_LSH	expr
			{ $$ = expr_build($1,TRUE,"<<",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	LX_RSH	expr
			{ $$ = expr_build($1,TRUE,">>",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	'+'     expr
			{ $$ = expr_build($1,TRUE,"+",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	'-'     expr
			{ $$ = expr_build($1,TRUE,"-",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	'*'     expr
			{ $$ = expr_build($1,TRUE,"*",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	'/'     expr
			{ $$ = expr_build($1,TRUE,"/",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	'%'     expr
			{ $$ = expr_build($1,TRUE,"%",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	LX_MOD	expr
			{ $$ = expr_build($1,TRUE,"%",FALSE,$3,TRUE,NULL,FALSE); }
	|	expr	LX_DIV	expr
			{ $$ = expr_build($1,TRUE,"div",FALSE,$3,TRUE,NULL,FALSE); }
	|	LX_SIZEOF expr			%prec LX_UNARY
			{ $$ = expr_build("sizeof(",FALSE,$2,TRUE,")",FALSE,NULL,FALSE); }
	|	'*'       expr                  %prec LX_UNARY
			{ $$ = expr_build("*",FALSE,$2,TRUE,NULL,FALSE,NULL,FALSE); }
	|	expr '^'                        %prec LX_UNARY
			{ $$ = expr_build("*",FALSE,$1,TRUE,NULL,FALSE,NULL,FALSE); }
	|	'&'       expr                  %prec LX_UNARY
			{ $$ = expr_build("&",FALSE,$2,TRUE,NULL,FALSE,NULL,FALSE); }
	|	'-'       expr                  %prec LX_UNARY
			{ $$ = expr_build("-",FALSE,$2,TRUE,NULL,FALSE,NULL,FALSE); }
	|	'!'       expr                  %prec LX_UNARY
			{ $$ = expr_build("!",FALSE,$2,TRUE,NULL,FALSE,NULL,FALSE); }
	|	'~'       expr                  %prec LX_UNARY
			{ $$ = expr_build("~",FALSE,$2,TRUE,NULL,FALSE,NULL,FALSE); }
	|	'(' type ')' expr          %prec LX_UNARY
			{ $$ = expr_build("(",FALSE,$2,TRUE,")",FALSE,$4,TRUE); }
	|	primary
			{ $$ = $1; }
	;


primary :	LX_ID
			{ $$ = expr_map_var($1); }
	|	LX_INT
	|	LX_FLT
	|	LX_STRING
	|	'(' expr ')'
			{ $$ = expr_build("(",FALSE,$2,TRUE,")",FALSE,NULL,FALSE); }
	|	primary '[' expr ']'
			{ $$ = expr_build($1,TRUE,"[",FALSE,$3,TRUE,"]",FALSE); }
/*	|	primary '[' expr LX_DOTDOT expr ']'             */
	|	primary '(' expr_list ')'
			{ $$ = expr_build($1,TRUE,"(",FALSE,$3,TRUE,")",FALSE); }
	|	primary '(' ')'
			{ $$ = expr_build($1,TRUE,"()",FALSE,NULL,FALSE,NULL,FALSE); }
	|	primary '.' LX_ID                       %prec '.'
			{ $3 = expr_map_field($3,$1);
			  $$ = expr_build($1,TRUE,".",FALSE,$3,TRUE,NULL,FALSE);
			}
	|	primary LX_PTS LX_ID			%prec '.'
			{ $3 = expr_map_field($3,$1);
			  $$ = expr_build($1,TRUE,"->",FALSE,$3,TRUE,NULL,FALSE);
			}
	|	primary '.' LX_ID '(' ')'               %prec '('
			{ $$ = expr_map_member_fct($1,$3,NULL,FALSE); }
	|	primary LX_PTS LX_ID '(' ')'            %prec '('
			{ $$ = expr_map_member_fct($1,$3,NULL,TRUE); }
	|	primary '.' LX_ID '(' expr_list ')'     %prec '('
			{ $$ = expr_map_member_fct($1,$3,$5,FALSE); }
	|	primary LX_PTS LX_ID '(' expr_list ')'  %prec '('
			{ $$ = expr_map_member_fct($1,$3,$5,TRUE); }
	;


expr_list :	expr
	|	expr_list ',' expr
			{ $$ = expr_build($1,TRUE,",",FALSE,$3,TRUE,NULL,FALSE); }
	;


type	:	type_name
	|	type '*'
			{ $$ = expr_build($1,TRUE," *",FALSE,NULL,FALSE,NULL,FALSE); }
	|	'^' type
			{ $$ = expr_build($2,TRUE," *",FALSE,NULL,FALSE,NULL,FALSE); }
	;


type_name :	LX_STRUCT LX_ID
			{ $$ = expr_build("struct",FALSE,$2,TRUE,NULL,FALSE,NULL,FALSE); }
	|	LX_UNION LX_ID
			{ $$ = expr_build("union",FALSE,$2,TRUE,NULL,FALSE,NULL,FALSE); }
	|	LX_ENUM LX_ID
			{ $$ = expr_build("enumt",FALSE,$2,TRUE,NULL,FALSE,NULL,FALSE); }
	|	LX_STRUCT LX_TYPEID
			{ $$ = expr_build("struct",FALSE,$2,TRUE,NULL,FALSE,NULL,FALSE); }
	|	LX_UNION LX_TYPEID
			{ $$ = expr_build("union",FALSE,$2,TRUE,NULL,FALSE,NULL,FALSE); }
	|	LX_ENUM LX_TYPEID
			{ $$ = expr_build("enumt",FALSE,$2,TRUE,NULL,FALSE,NULL,FALSE); }
	|	LX_TYPEID
	|	LX_UNSIGNED
			{ $$ = SALLOC("unsigned int"); }
	|	LX_UNSIGNED LX_TYPEID
			{ $$ = expr_build("unsigned",FALSE,$2,TRUE,NULL,FALSE,NULL,FALSE); }
	;




%%


#include "ddtexpr.c"




/* end of ddtexprsyn.y */

