/************************************************************************/
/*									*/
/*		ddtcplus20.c						*/
/*									*/
/*	C++ 2.0 mapping routines for the ddt debugger interface 	*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#include "ddt_local.h"
#include "ddt_names.h"






/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	Integer 	pick_alternative();
static	String		type_name();





/************************************************************************/
/*									*/
/*	DDT_cplus_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
DDT_cplus_init()
{
};






/************************************************************************/
/*									*/
/*	DDT_cplus_fix_function -- convert user function name to C++ name*/
/*									*/
/************************************************************************/


#define MAX_SAVE 32

String
DDT_cplus_fix_function(f,buf)
   String f;
   String buf;
{
   FUN_INFO * ftbl;
   Integer ct,i,ln;
   DDT_MANGLE dm,dmf;
   String save[MAX_SAVE];
   String use[MAX_SAVE];
   Integer savct;

   ct = DDT_symbol_funct_table(&ftbl);

   dm = DDT_mangle_name(f,MANGLE_FUNCTION);
   ln = strlen(dm->base);
   savct = 0;

   for (i = 0; i < ct; ++i) {
      if (strncmp(dm->base,ftbl[i].name,ln) == 0 &&
	     (ftbl[i].name[ln] == '_' || ftbl[i].name[ln] == 0)) ;
      else if (ftbl[i].name[0] == '_' && ftbl[i].name[1] == '_') ;
      else continue;

      if (ftbl[i].mangle == NULL)
	 ftbl[i].mangle = DDT_demangle_name(ftbl[i].name);
      dmf = ftbl[i].mangle;

      if (DDT_mangle_match(dm,dmf) && savct < MAX_SAVE) {
	 save[savct] = ftbl[i].pname;
	 use[savct] = ftbl[i].name;
	 ++savct;
       };
    };

   if (savct == 0) strcpy(buf,f);
   else {
      if (dm->prefix == NULL) buf[0] = 0;
      else sprintf(buf,"%s`",dm->prefix);
      if (savct == 1) strcat(buf,use[0]);
      else {
	 i = pick_alternative(f,savct,save);
	 if (i < 0) strcat(buf,f);
	 else strcat(buf,use[i]);
       };
    };

   free(dm);

   return buf;
};







/************************************************************************/
/*									*/
/*	DDT_cplus_fix_member_function -- handle member functions	*/
/*									*/
/************************************************************************/


String
DDT_cplus_fix_member_function(f,lhs,args,buf)
   String f;
   String lhs;
   String args;
   String buf;
{
   FUN_INFO * ftbl;
   Integer ct,i,ln;
   DDT_MANGLE dm,dmf;
   String save[MAX_SAVE];
   String use[MAX_SAVE];
   Integer savct;
   Character tbuf[10240];
   String t;

   ct = DDT_symbol_funct_table(&ftbl);

   dm = DDT_mangle_name(f,MANGLE_FUNCTION);
   ln = strlen(dm->base);

   if (dm->class == NULL) {
      t = type_name(lhs,tbuf);
      if (t != NULL) dm->class = DDT_mangle_add_name(dm,t);
    };

   savct = 0;

   for (i = 0; i < ct; ++i) {
      if (strncmp(dm->base,ftbl[i].name,ln) == 0 &&
	     (ftbl[i].name[ln] == '_' || ftbl[i].name[ln] == 0)) ;
      else if (ftbl[i].name[0] == '_' && ftbl[i].name[1] == '_') ;
      else continue;

      if (ftbl[i].mangle == NULL)
	 ftbl[i].mangle = DDT_demangle_name(ftbl[i].name);
      dmf = ftbl[i].mangle;

      if (DDT_mangle_match(dm,dmf) && savct < MAX_SAVE) {
	 save[savct] = ftbl[i].pname;
	 use[savct] = ftbl[i].name;
	 ++savct;
       };
    };

   free(dm);

   if (savct == 0) strcpy(buf,f);
   else if (savct == 1) strcpy(buf,use[0]);
   else {
      i = pick_alternative(f,savct,save);
      if (i < 0) strcpy(buf,f);
      else strcpy(buf,use[i]);
    };

   return buf;
};





/************************************************************************/
/*									*/
/*	DDT_cplus_unfix_function -- convert C++ name to source name	*/
/*									*/
/************************************************************************/


String
DDT_cplus_unfix_function(s)
   String s;
{
   Integer ct,i;
   FUN_INFO * ftbl;
   Character buf[1024];

   ct = DDT_symbol_funct_table(&ftbl);

   for (i = 0; i < ct; ++i) {
      if (STREQL(s,ftbl[i].name)) {
	 if (ftbl[i].pname == ftbl[i].name) {
	    if (ftbl[i].mangle == NULL) {
	       ftbl[i].mangle = DDT_demangle_name(ftbl[i].name);
	     };
	    DDT_mangle_output(ftbl[i].mangle,buf);
	    ftbl[i].pname = SALLOC(buf);
	  };
	 return ftbl[i].pname;
       };
    };

   return s;
};






/************************************************************************/
/*									*/
/*	DDT_cplus_fix_variable -- map user var to C++ name		*/
/*									*/
/************************************************************************/


String
DDT_cplus_fix_variable(v,buf)
   String v;
   String buf;
{
   String t,p,f1,f2;
   Integer i;
   LOCATION cloc;
   Character fbuf[1024],hbuf[1024],vbuf[1024];
   Boolean colfg,lclfg;


   if (v[0] == '`') return v;

   if (DDT_symbol_inq_type_name(v)) return v;

   DDT_model_inq_location(&cloc);

   if (cloc.file == NULL) f1 = f2 = NULL;
   else {
      i = strlen(cloc.file);
      f1 = cloc.file;
      if (cloc.file[i-2] == '.' && cloc.file[i-1] == 'C') {
	 strcpy(fbuf,cloc.file);
	 fbuf[i-1] = 'c';
	 f2 = fbuf;
       }
      else f2 = NULL;
    };

   colfg = FALSE;
   if ((t = index(v,':')) != NULL) colfg = TRUE;

   lclfg = FALSE;
   if (!colfg && cloc.func != NULL) {
      t = DDT_cplus_fix_function(cloc.func,hbuf);
      p = DDT_symbol_find_fct_local(t,v,vbuf);
      if (strncmp(p,"__",2) == 0 && isdigit(p[2])) {
	 lclfg = TRUE;
	 v = p;
       }
      else {
	 p = DDT_symbol_find_fct_local(t,"this",vbuf);
	 if (p[0] == '_') {
	    if (p != vbuf) strcpy(vbuf,p);
	    t = DDT_cplus_fix_field(v,p,hbuf);
	    strcat(vbuf,"->");
	    strcat(vbuf,t);
	    if (DDT_x_valid_name(vbuf)) {
	       strcpy(hbuf,vbuf);
	       sprintf(vbuf,"(%s)",hbuf);
	       v = vbuf;
	       lclfg = TRUE;
	     };
	  };
       };
    };

   if (!lclfg) p = DDT_symbol_find_variable(v,f1,f2);

   t = rindex(v,'`');
   if (!lclfg && p == NULL && t != NULL) {
      strcpy(hbuf,v);
      p = rindex(hbuf,'`');
      *p = 0;
      p = DDT_cplus_fix_function(hbuf,fbuf);
      ++t;
      v = DDT_symbol_find_fct_local(p,t,fbuf);
    }
   else if (p != NULL) v = p;

   return v;
};





/************************************************************************/
/*									*/
/*	DDT_cplus_unfix_variable - convert name from C++ to user	*/
/*									*/
/************************************************************************/


String
DDT_cplus_unfix_variable(v)
   String v;
{
   String u;

   if (strncmp(v,"__",2) == 0 && isdigit(v[2])) {
      u = &v[3];
      while (isdigit(*u)) ++u;
      if (*u != 0) v = u;
    };

   return v;
};





/************************************************************************/
/*									*/
/*	DDT_cplus_fix_field -- map a field name from user to C++	*/
/*									*/
/************************************************************************/


String
DDT_cplus_fix_field(fld,lhs,buf)
   String fld;
   String lhs;
   String buf;
{
   String s,t,v,w;
   Integer i;
   Character ybuf[1024];

   if (lhs == NULL) return fld;

   if (!DDT_map_field_var_info(lhs,ybuf,TRUE)) return fld;
   s = ybuf;

   i = strlen(fld);

   s = index(s,'{');
   if (s == NULL) return fld;

   w = NULL;

   while ((t = index(s,';')) != NULL) {
      s = t;
      *s++ = 0;

      v = &t[-1];
      while (*v == ']') {
	 while (*v != '[') --v;
	 t = v;
	 *v-- = 0;
       };

      for ( ; isalnum(*v) || *v == '_' || *v == '$'; --v);
      ++v;

      if (strncmp(fld,v,i) == 0 && v[i] == '_' && v[i+1] == '_' && isdigit(v[i+2])) {
	 w = v;
	 break;
       };
    };

   if (w != NULL) {
      strcpy(buf,w);
      fld = buf;
    };

   return fld;
};





/************************************************************************/
/*									*/
/*	DDT_cplus_unfix_field -- convert C++ field name to user name	*/
/*									*/
/************************************************************************/


String
DDT_cplus_unfix_field(fld,lhs)
   String fld;
   String lhs;
{
   String s,t;
   Character ybuf[1024];
   DDT_MANGLE dm;

   if (!DDT_map_field_var_info(lhs,ybuf,FALSE)) s = NULL;
   else {
      s = ybuf;
      s = index(s,' ');
      if (s != NULL) {
	 ++s;
	 t = index(s,' ');
	 if (t != NULL) *t = 0;
	 else s = NULL;
       };
    };

   dm = DDT_demangle_name(fld);
   if (dm->class == NULL) return fld;
   if (s != NULL && STREQL(dm->class,s)) dm->class = NULL;

   DDT_mangle_output(dm,ybuf);

   free(dm);

   strcpy(fld,ybuf);

   return fld;
};






/************************************************************************/
/*									*/
/*	DDT_cplus_find_fct_local -- find var as local in fct		*/
/*									*/
/************************************************************************/


String
DDT_cplus_find_fct_local(var,lcls,buf)
   String var;
   Sequence lcls;
   String buf;
{
   String s,t;
   Sequence l;

   if (lcls != NULL) {
      if (strncmp(var,"__",2) == 0 && isdigit(var[2])) lcls = NULL;
    };

   forin (s,String,l,lcls) {
      if (strncmp(s,"__",2) == 0 && isdigit(s[2])) {
	 t = &s[2];
	 while (isdigit(*t)) ++t;
	 if (STREQL(t,var)) {
	    strcpy(buf,s);
	    var = buf;
	    break;
	  };
       };
    };


   return var;
};







/************************************************************************/
/*									*/
/*	DDT_cplus_local_level -- return level number of local (or -1)	*/
/*									*/
/************************************************************************/


Boolean
DDT_cplus_test_save_local(var)
   String var;
{
   return (strncmp(var,"__",2) == 0 && isdigit(var[2]));
};






/************************************************************************/
/*									*/
/*	pick_alternative -- choose among alternative names		*/
/*									*/
/************************************************************************/


static Integer
pick_alternative(orig,ct,nms)
   String orig;
   Integer ct;
   String nms[];
{
   Character buf[10240];
   Integer i;
   String s;

   if (ct == 0) return -1;
   else if (ct == 1) return 0;
   else if (DDT_state_cmd_quiet()) return 0;

   buf[0] = 0;
   for (i = 0; i < ct; ++i) {
      if (i > 0) strcat(buf,";");
      strcat(buf,nms[i]);
    };

   s = MSGcalla("DEBUG PICK %s %S %d %d %S",DDT__system_name,orig,DDT__picklevel,ct,buf);

   if (s == NULL) i = 0;
   else if (isdigit(s[0])) i = atol(s);
   else if (STREQL(s,"*")) i = -1;
   else {
      for (i = 0; i < ct; ++i) {
	 if (STREQL(s,nms[i])) break;
       };
      if (i >= ct) i = -1;
    };

   return i;
};





/************************************************************************/
/*									*/
/*	type_name -- return type name for expression			*/
/*									*/
/************************************************************************/


static String
type_name(itm,buf)
   String itm;
   String buf;
{
   Character tbuf[10240];
   String s;

   if (!DDT_x_var_info(NULL,NULL,0,itm,FALSE,FALSE,TRUE,tbuf)) return NULL;

   if (strncmp(tbuf,"struct ",7) == 0) s = &tbuf[7];
   else if (strncmp(tbuf,"union ",6) == 0) s = &tbuf[6];
   else s = tbuf;

   while (isspace(*s)) ++s;

   strcpy(buf,s);

   s = index(buf,'{');
   if (s != NULL && buf[0] != '{') {
      *s-- = 0;
      while (isspace(*s)) *s-- = 0;
    }
   else if (buf[0] == '{') return NULL;

   return buf;
};





/* end of ddtcplus20.c */
