/************************************************************************/
/*									*/
/*		ddt_names.h						*/
/*									*/
/*	Type definitions for name and symbols manipulation		*/
/*									*/
/************************************************************************/
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/



#include <sys/types.h>
#include <sys/stat.h>





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_ARGS	64
#define MAX_NAME_LEN	1024





/************************************************************************/
/*									*/
/*	Mangled name types						*/
/*									*/
/************************************************************************/


typedef struct _DDT_MANGLE *	DDT_MANGLE;



typedef enum _DDT_MANGLE_TYPE {
   MANGLE_UNKNOWN,
   MANGLE_FUNCTION,
   MANGLE_FIELD,
   MANGLE_VAR,
   MANGLE_LOCAL,
   MANGLE_TEMP,
   MANGLE_BAD,
} DDT_MANGLE_TYPE;





typedef struct _DDT_MANGLE {
   DDT_MANGLE_TYPE type;
   String file;
   String prefix;
   String base;
   String class;
   Integer numargs;
   String args[MAX_ARGS];
   Character buf[MAX_NAME_LEN];
   Character opbuf[64];
   String bufp;
   Boolean isconst;
} DDT_MANGLE_INFO;







/************************************************************************/
/*									*/
/*	Symbol table types						*/
/*									*/
/************************************************************************/


typedef struct _FUN_INFO {
   String name;
   String pname;
   Short file;
   Integer sline;
   Integer eline;
   Integer eaddr;
   Integer next;
   Sequence locals;
   DDT_MANGLE mangle;
} FUN_INFO;



typedef struct _FILE_INFO {
   String name;
   String pname;
   String dname;
   String tail;
   time_t mtime;
   Integer altfile;
} FILE_INFO;




typedef struct _VAR_INFO {
   String name;
   Short file;
   Boolean ext;
   DDT_MANGLE mangle;
   Integer addr;
   Integer next;
} VAR_INFO;




typedef enum _SUE {
   TYPE_NAME,
   TYPE_STRUCT,
   TYPE_UNION,
   TYPE_ENUM
} SUE;




typedef struct _TYPE_INFO {
   String name;
   String pname;
   Short file;
   Boolean ext;
   SUE sue;
   Integer next;
} TYPE_INFO;





/************************************************************************/
/*									*/
/*	External entries						*/
/*									*/
/************************************************************************/


extern	void			DDT_mangle_init();
extern	DDT_MANGLE		DDT_mangle_name();
extern	DDT_MANGLE		DDT_demangle_name();
extern	Boolean 		DDT_mangle_match();
extern	void			DDT_mangle_output();
extern	String			DDT_mangle_add_name();

extern	void			DDT_cplus12_init();
extern	String			DDT_cplus12_fix_function();
extern	String			DDT_cplus12_unfix_function();
extern	String			DDT_cplus12_fix_variable();
extern	String			DDT_cplus12_unfix_variable();
extern	String			DDT_cplus12_fix_field();
extern	String			DDT_cplus12_unfix_field();
extern	String			DDT_cplus12_find_fct_local();
extern	Boolean 		DDT_cplus12_test_save_local();

extern	void			DDT_cplus_init();
extern	String			DDT_cplus_fix_function();
extern	String			DDT_cplus_fix_member_function();
extern	String			DDT_cplus_unfix_function();
extern	String			DDT_cplus_fix_variable();
extern	String			DDT_cplus_unfix_variable();
extern	String			DDT_cplus_fix_field();
extern	String			DDT_cplus_unfix_field();
extern	String			DDT_cplus_find_fct_local();
extern	Boolean 		DDT_cplus_test_save_local();

extern	void			DDT_pascal_init();
extern	String			DDT_pascal_fix_function();
extern	String			DDT_pascal_fix_variable();
extern	String			DDT_pascal_fix_field();
extern	String			DDT_pascal_fix_outexpr();







/* end of ddt_names.h */
