/************************************************************************/
/*									*/
/*		dbg_local.h						*/
/*									*/
/*	Local definitions for debugger interface			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#define  PROT_NAME	DBG__sema

#include <datatypes.h>
#include <sequence.h>
#include <ash.h>
#include <rip.h>
#include <stem.h>

#include <auxd.h>
#include <edt.h>
#include <pmat.h>
#include <msg.h>
#include <field.h>

#include <dbg.h>




/************************************************************************/
/*									*/
/*	Local Definitions						*/
/*									*/
/************************************************************************/


#define BUTTONS_PER_LINE	9

#define BUTTON_FILE_NAME	".dbgbtn"
#define BUTTON_FILE_SEP 	'#'




/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/



typedef struct _DBG_WIN *	DBG_WIN;
typedef struct _DBG_BTN *	DBG_BTN;
typedef struct _DBG_MATCH *	DBG_MATCH;



typedef enum _DBG_BTN_MODE {
   DBG_MODE_NONE,
   DBG_MODE_STOP,
   DBG_MODE_RUN,
   DBG_MODE_CONTINUE,
} DBG_BTN_MODE;




typedef struct _DBG_WIN {
   ASH_WINDOW	window;
   ASH_WINDOW	dedt_win;
   ASH_WINDOW	menu_win;
   ASH_WINDOW	btn_win;
   EDT_EXEC	exec_info;
   String	filename;
   String	corename;
   Integer	btn_size;
   DBG_BTN	buttons;
   String	function;
   Integer	line;
   Boolean	use_gdb;
} DBG_WIN_INFO;



typedef struct _DBG_BTN {
   String name;
   String output;
   DBG_BTN next;
   String color;
   DBG_WIN win;
   DBG_BTN_MODE mode;
} DBG_BTN_INFO;






/************************************************************************/
/*									*/
/*	Common storage							*/
/*									*/
/************************************************************************/


extern	Integer 	DBG__button_line_size;





/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/


					/* dbgmain.c			*/
extern	void		DBG_init();
extern	void		DBG_exit();



					/* dbgwin.c			*/
extern	void		DBG_win_init();
extern	DBG_WIN 	DBG_create();



					/* dbgbtn.c			*/
extern	void		DBG_btn_init();
extern	void		DBG_btn_setup();
extern	Integer 	DBG_btn_menu();
extern	void		DBG_btn_mode();





/* end of dbg_local.h */
