/************************************************************************/
/*									*/
/*		cbrowdisp.c						*/
/*									*/
/*	Display routines for class browser				*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "cbrow_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define DEFAULT_METHOD		GELO_METHOD_LEVEL
#define DEFAULT_CONNMETHOD	GELO_CONN_METHOD_DIRECT_RECT
#define DEFAULT_FIXED		FALSE
#define DEFAULT_STANDARD	FALSE
#define DEFAULT_CENTERED	TRUE
#define DEFAULT_WHITESPACE	0

#define SIMPLE_SHAPE		GELO_SHAPE_ELLIPSE
#define SHAPE_RECTANGLE 	GELO_SHAPE_RECTANGLE
#define SHAPE_LINE		GELO_SHAPE_VLINE

#define FRIEND_STYLE		ASH_STYLE_DASHED
#define PUBLIC_STYLE		ASH_STYLE_THICK
#define PRIVATE_STYLE		ASH_STYLE_SOLID
#define TYPE_STYLE		ASH_STYLE_DOTTED

#define DATA_SHAPE		GELO_SHAPE_TBOX_LEFT
#define FUNCT_SHAPE		GELO_SHAPE_TBOX_RIGHT
#define FRIEND_SHAPE		GELO_SHAPE_RECTANGLE
#define PRIVATE_FILL		ASH_FILL_SOLID
#define PROTECTED_FILL		ASH_FILL_LIGHT_HALFTONE
#define PUBLIC_FILL		ASH_FILL_HOLLOW
#define ABSTRACT_FILL		ASH_FILL_HALFTONE

#define SHAPE_NULL		GELO_SHAPE_NULL_PTR
#define SHAPE_FIELD		GELO_SHAPE_FLD_PTR

#define SELECT_STYLE		1
#define MEMBER_STYLE		2
#define SUBMEMBER_STYLE 	3
#define SUPMEMBER_STYLE 	4
#define DEFMEMBER_STYLE 	6
#define EVAL_STYLE		5

#define MAX_MEMBS		64

#define DEFAULT_DISPLAY_ALL	FALSE
#define DEFAULT_DISPLAY_SUPER	TRUE
#define DEFAULT_DISPLAY_SUB	TRUE
#define DEFAULT_DISPLAY_LEVELS	-1
#define DEFAULT_DISPLAY_FORCE	TRUE
#define DEFAULT_DCLASS_SIMPLE	FALSE
#define DEFAULT_DCLASS_DETAIL	TRUE
#define DEFAULT_DCLASS_ZOOM	1
#define DEFAULT_DCLASS_FRIEND	TRUE
#define DEFAULT_DCLASS_HIER	TRUE
#define DEFAULT_DCLASS_FIXCUR	TRUE
#define DEFAULT_DMEMB_PUBLIC	FALSE
#define DEFAULT_DMEMB_DATA	TRUE
#define DEFAULT_DMEMB_METHOD	TRUE
#define DEFAULT_DMEMB_INHER	TRUE
#define DEFAULT_DMEMB_LINKS	FALSE
#define DEFAULT_DMEMB_STATE	FALSE
#define DEFAULT_DMEMB_FULLNAMES FALSE







/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	GELO_METHOD		default_method;
static	GELO_CONN_METHOD	default_connmethod;
static	Boolean 		default_fixed;
static	Boolean 		default_standard;
static	Boolean 		default_centered;
static	Integer 		default_whitespace;

static	Boolean 		default_display_all;
static	Boolean 		default_display_super;
static	Boolean 		default_display_sub;
static	Integer 		default_display_levels;
static	Boolean 		default_display_force;
static	Boolean 		default_dclass_simple;
static	Boolean 		default_dclass_detail;
static	Integer 		default_dclass_zoom;
static	Boolean 		default_dclass_friend;
static	Boolean 		default_dclass_hier;
static	Boolean 		default_dclass_fixcur;
static	Boolean 		default_dmemb_public;
static	Boolean 		default_dmemb_data;
static	Boolean 		default_dmemb_method;
static	Boolean 		default_dmemb_inher;
static	Boolean 		default_dmemb_links;
static	Boolean 		default_dmemb_state;
static	Boolean 		default_dmemb_fullnames;

static	Sequence		default_class_exc;
static	Sequence		default_class_inc;
static	Sequence		default_member_exc;
static	Sequence		default_member_inc;




/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	void		disp_clear();
static	Boolean 	compute_displayed();
static	void		display_class();
static	Integer 	display_members();
static	void		display_icon();
static	void		add_arc();
static	Boolean 	use_hier();
static	Boolean 	use_memb();
static	void		hilite_member();
static	Integer 	hilite_style();
static	Sequence	get_auxd_list();





/************************************************************************/
/*									*/
/*	CBROW_disp_init -- module initialization			*/
/*									*/
/************************************************************************/


void
CBROW_disp_init()
{
   AUXD hdl;

   hdl = AUXDget_handle(NULL,"CBROW");

   if (!AUXDget_defined(hdl,"METHOD")) default_method = DEFAULT_METHOD;
   else default_method = (GELO_METHOD) AUXDget_info_int(hdl,"METHOD");

   if (!AUXDget_defined(hdl,"CONNMETHOD")) default_connmethod = DEFAULT_CONNMETHOD;
   else default_connmethod = (GELO_CONN_METHOD) AUXDget_info_int(hdl,"CONNMETHOD");

   if (!AUXDget_defined(hdl,"FIXED")) default_fixed = DEFAULT_FIXED;
   else default_fixed = AUXDget_info_int(hdl,"FIXED");

   if (!AUXDget_defined(hdl,"STANDARD")) default_standard = DEFAULT_STANDARD;
   else default_standard = AUXDget_info_int(hdl,"STANDARD");

   if (!AUXDget_defined(hdl,"CENTERED")) default_centered = DEFAULT_CENTERED;
   else default_centered = AUXDget_info_int(hdl,"CENTERED");

   if (!AUXDget_defined(hdl,"WHITE_SPACE")) default_whitespace = DEFAULT_WHITESPACE;
   else default_whitespace = AUXDget_info_int(hdl,"WHITE_SPACE");

   if (!AUXDget_defined(hdl,"DISPLAY_ALL")) default_display_all = DEFAULT_DISPLAY_ALL;
   else default_display_all = AUXDget_info_int(hdl,"DISPLAY_ALL");

   if (!AUXDget_defined(hdl,"DISPLAY_SUPER")) default_display_super = DEFAULT_DISPLAY_SUPER;
   else default_display_super = AUXDget_info_int(hdl,"DISPLAY_SUPER");

   if (!AUXDget_defined(hdl,"DISPLAY_SUB")) default_display_sub = DEFAULT_DISPLAY_SUB;
   else default_display_sub = AUXDget_info_int(hdl,"DISPLAY_SUB");

   if (!AUXDget_defined(hdl,"DISPLAY_LEVELS")) default_display_levels = DEFAULT_DISPLAY_LEVELS;
   else default_display_levels = AUXDget_info_int(hdl,"DISPLAY_LEVELS");

   if (!AUXDget_defined(hdl,"DISPLAY_FORCE")) default_display_force = DEFAULT_DISPLAY_FORCE;
   else default_display_force = AUXDget_info_int(hdl,"DISPLAY_FORCE");

   if (!AUXDget_defined(hdl,"DCLASS_SIMPLE")) default_dclass_simple = DEFAULT_DCLASS_SIMPLE;
   else default_dclass_simple = AUXDget_info_int(hdl,"DCLASS_SIMPLE");

   if (!AUXDget_defined(hdl,"DCLASS_DETAIL")) default_dclass_detail = DEFAULT_DCLASS_DETAIL;
   else default_dclass_detail = AUXDget_info_int(hdl,"DCLASS_DETAIL");

   if (!AUXDget_defined(hdl,"DCLASS_ZOOM")) default_dclass_zoom = DEFAULT_DCLASS_ZOOM;
   else default_dclass_zoom = AUXDget_info_int(hdl,"DCLASS_ZOOM");

   if (!AUXDget_defined(hdl,"DCLASS_FRIEND")) default_dclass_friend = DEFAULT_DCLASS_FRIEND;
   else default_dclass_friend = AUXDget_info_int(hdl,"DCLASS_FRIEND");

   if (!AUXDget_defined(hdl,"DCLASS_HIER")) default_dclass_hier = DEFAULT_DCLASS_HIER;
   else default_dclass_hier = AUXDget_info_int(hdl,"DCLASS_HIER");

   if (!AUXDget_defined(hdl,"DCLASS_FIXCUR")) default_dclass_fixcur = DEFAULT_DCLASS_FIXCUR;
   else default_dclass_fixcur = AUXDget_info_int(hdl,"DCLASS_FIXCUR");

   if (!AUXDget_defined(hdl,"DMEMB_PUBLIC")) default_dmemb_public = DEFAULT_DMEMB_PUBLIC;
   else default_dmemb_public = AUXDget_info_int(hdl,"DMEMB_PUBLIC");

   if (!AUXDget_defined(hdl,"DMEMB_DATA")) default_dmemb_data = DEFAULT_DMEMB_DATA;
   else default_dmemb_data = AUXDget_info_int(hdl,"DMEMB_DATA");

   if (!AUXDget_defined(hdl,"DMEMB_METHOD")) default_dmemb_method = DEFAULT_DMEMB_METHOD;
   else default_dmemb_method = AUXDget_info_int(hdl,"DMEMB_METHOD");

   if (!AUXDget_defined(hdl,"DMEMB_INHER")) default_dmemb_inher = DEFAULT_DMEMB_INHER;
   else default_dmemb_inher = AUXDget_info_int(hdl,"DMEMB_INHER");

   if (!AUXDget_defined(hdl,"DMEMB_LINKS")) default_dmemb_links = DEFAULT_DMEMB_LINKS;
   else default_dmemb_links = AUXDget_info_int(hdl,"DMEMB_LINKS");

   if (!AUXDget_defined(hdl,"DMEMB_STATE")) default_dmemb_state = DEFAULT_DMEMB_STATE;
   else default_dmemb_state = AUXDget_info_int(hdl,"DMEMB_STATE");

   if (!AUXDget_defined(hdl,"DMEMB_FULLNAMES")) default_dmemb_fullnames = DEFAULT_DMEMB_FULLNAMES;
   else default_dmemb_fullnames = AUXDget_info_int(hdl,"DMEMB_FULLNAMES");

   default_class_exc = get_auxd_list(hdl,"CLASS_EXCLUDE");
   default_class_inc = get_auxd_list(hdl,"CLASS_INCLUDE");
   default_member_exc = get_auxd_list(hdl,"MEMBER_EXCLUDE");
   default_member_inc = get_auxd_list(hdl,"MEMBER_INCLUDE");
};





/************************************************************************/
/*									*/
/*	CBROW_disp_setup -- initial setup of GELO display for browser	*/
/*									*/
/************************************************************************/


void
CBROW_disp_setup(cw)
   CBROW_WIN cw;
{
   cw->gid = NULL;
   if (cw->disp_win == NULL) return;

   GELOwindow_open(cw->disp_win);

   cw->method = default_method;
   cw->connmethod = default_connmethod;
   cw->fixed = default_fixed;
   cw->standard = default_standard;
   cw->centered = default_centered;
   cw->whitespace = default_whitespace;

   cw->display = NULL;

   cw->display_all = default_display_all;
   cw->display_super = default_display_super;
   cw->display_sub = default_display_sub;
   cw->display_levels = default_display_levels;
   cw->display_force = default_display_force;
   cw->dclass_simple = default_dclass_simple;
   cw->dclass_detail = default_dclass_detail;
   cw->dclass_zoom = default_dclass_zoom;
   cw->dclass_friend = default_dclass_friend;
   cw->dclass_hier = default_dclass_hier;
   cw->dclass_fixcur = default_dclass_fixcur;
   cw->dmemb_public = default_dmemb_public;
   cw->dmemb_data = default_dmemb_data;
   cw->dmemb_method = default_dmemb_method;
   cw->dmemb_inher = default_dmemb_inher;
   cw->dmemb_links = default_dmemb_links;
   cw->dmemb_state = default_dmemb_state;
   cw->dmemb_fullnames = default_dmemb_fullnames;

   disp_clear(cw,TRUE);
};





/************************************************************************/
/*									*/
/*	CBROW_disp_reset -- reset display to include all items		*/
/*									*/
/************************************************************************/


void
CBROW_disp_reset(cw)
   CBROW_WIN cw;
{
   disp_clear(cw,TRUE);
};





/************************************************************************/
/*									*/
/*	CBROW_disp_redraw -- redraw display using new parameters	*/
/*									*/
/************************************************************************/


void
CBROW_disp_redraw(cw)
   CBROW_WIN cw;
{
   if (cw->disp_win == NULL) return;

   ASHinput_lock_makelong(cw->window);

   if (cw->gid != NULL) {
      CBROW_disp_free(cw);
    }
   else disp_clear(cw,FALSE);

   if (cw->display != NULL && cw->display->ignore) cw->display = NULL;

   cw->gid = GELOdefine_layout();
   GELOset_owner(cw->gid,cw);
   GELOdefine_layout_method(cw->gid,cw->method);
   GELOdefine_layout_conn_method(cw->gid,cw->connmethod);
   GELOdefine_layout_fixed(cw->gid,cw->fixed);
   GELOdefine_layout_standard(cw->gid,cw->standard);
   GELOdefine_layout_centered(cw->gid,cw->centered);
   GELOdefine_layout_white_space(cw->gid,cw->whitespace);

   if (!compute_displayed(cw)) {
      STEMdialog1(cw->window," No class hierarchy to display \n\n%M   %a");
    };

   GELOwindow_draw(cw->disp_win,cw->gid);

   if (cw->display != NULL && cw->display->gid != NULL) {
      GELOwindow_select(cw->disp_win,cw->display->gid,SELECT_STYLE,TRUE);
    };

   CBROW_disp_eval(cw,cw->cureval);
   CBROW_disp_member(cw,cw->curmemb);
};





/************************************************************************/
/*									*/
/*	CBROW_disp_member -- display a member and it derivatives	*/
/*									*/
/************************************************************************/


void
CBROW_disp_member(cw,cm)
   CBROW_WIN cw;
   CBROW_MEMB cm;
{
   if (cw->memb_select) {
      hilite_member(cw,cw->curmemb,cw->curmemb->real_cls,FALSE);
      cw->memb_select = FALSE;
    };

   cw->curmemb = cm;
   if (cm != NULL) {
      hilite_member(cw,cm,cm->real_cls,TRUE);
      cw->memb_select = TRUE;
    };
};





/************************************************************************/
/*									*/
/*	CBROW_disp_eval -- display current evaluation item		*/
/*									*/
/************************************************************************/


void
CBROW_disp_eval(cw,cm)
   CBROW_WIN cw;
   CBROW_MEMB cm;
{
   if (cw->eval_select) {
      if (cw->cureval != NULL && cw->cureval->gid != NULL) {
	 GELOwindow_select(cw->disp_win,cw->cureval->gid,EVAL_STYLE,FALSE);
       };
      cw->eval_select = FALSE;
    };

   cw->cureval = cm;
   if (cm != NULL) {
      if (cm->gid != NULL) {
	 GELOwindow_select(cw->disp_win,cm->gid,EVAL_STYLE,TRUE);
	 cw->eval_select = TRUE;
       };
    };
};





/************************************************************************/
/*									*/
/*	CBROW_disp_free -- free current display 			*/
/*									*/
/************************************************************************/


void
CBROW_disp_free(cw)
   CBROW_WIN cw;
{
   if (cw->gid != NULL) {
      GELOwindow_free(cw->disp_win,cw->gid);
      cw->gid = NULL;
      disp_clear(cw,FALSE);
    };
};





/************************************************************************/
/*									*/
/*	CBROW_disp_current -- setup current class			*/
/*									*/
/************************************************************************/


void
CBROW_disp_current(cw,cc,cm,btn,infg)
   CBROW_WIN cw;
   CBROW_CLASS cc;
   CBROW_MEMB cm;
   String btn;
   Boolean infg;
{
   Boolean redraw;

   if (btn != NULL && cc->file != NULL && cc->line > 0) {
      MSGsenda("XREF SET %s %d %s",cc->file,cc->line,btn);
    };

   if (cw->display_all && cw->dclass_zoom <= 1) redraw = FALSE;
   else redraw = cw->display_force;
   if (!redraw && cc != NULL && cc->gid == NULL) redraw = TRUE;

   if (cw->display != cc && redraw) {
      cw->curmemb = cm;
      cw->display = cc;
      CBROW_disp_redraw(cw);
    }
   else if (cw->display != cc) {
      if (cw->display != NULL && cw->display->gid != NULL) {
	 GELOwindow_select(cw->disp_win,cw->display->gid,SELECT_STYLE,FALSE);
       }
      cw->display = cc;
      if (cw->display != NULL && cw->display->gid != NULL) {
	 GELOwindow_select(cw->disp_win,cw->display->gid,SELECT_STYLE,TRUE);
       };
      CBROW_disp_member(cw,cm);
    }
   else {
      CBROW_disp_member(cw,cm);
    };

   if (cc != NULL && infg) CBROW_info_class(cw,cc);
};






/************************************************************************/
/*									*/
/*	CBROW_disp_class_regex -- select classes by reg exprs		*/
/*									*/
/************************************************************************/


void
CBROW_disp_class_regex(cw,inc,exfg,exc,infg)
   CBROW_WIN cw;
   String inc;
   Boolean exfg;
   String exc;
   Boolean infg;
{
   CBROW_CLASS cc;

   if (inc != NULL && inc[0] != 0 && re_comp(inc) == NULL) {
      for (cc = cw->classes; cc != NULL; cc = cc->next) {
	 if (re_exec(cc->name)) {
	    cc->ignore = FALSE;
	  }
	 else if (exfg) cc->ignore = TRUE;
       };
    };

   if (exc != NULL && exc[0] != 0 && re_comp(exc) == NULL) {
      for (cc = cw->classes; cc != NULL; cc = cc->next) {
	 if (re_exec(cc->name)) {
	    cc->ignore = TRUE;
	  }
	 else if (infg) cc->ignore = FALSE;
       };
    };
};






/************************************************************************/
/*									*/
/*	CBROW_disp_member_regex -- handle member selection by regex	*/
/*									*/
/************************************************************************/


void
CBROW_disp_member_regex(cw,cls,inc,exfg,exc,infg)
   CBROW_WIN cw;
   String cls;
   String inc;
   Boolean exfg;
   String exc;
   Boolean infg;
{
   CBROW_CLASS cc;
   CBROW_MEMB cm;
   Boolean alfg;

   if (cls == NULL || cls[0] == 0) alfg = TRUE;
   else alfg = FALSE;

   for (cc = cw->classes; cc != NULL; cc = cc->next) {
      if (!alfg) {
	 if (re_comp(cls) != NULL) alfg = TRUE;
	 else if (!re_exec(cc->name)) continue;
       };

      if (inc != NULL && inc[0] != 0 && re_comp(inc) == NULL) {
	 for (cm = cc->members; cm != NULL; cm = cm->next) {
	    if (re_exec(cm->name)) {
	       cm->ignore = FALSE;
	     }
	    else if (exfg) cm->ignore = TRUE;
	  };
       }
      else inc = NULL;

      if (exc != NULL && exc[0] != 0 && re_comp(exc) == NULL) {
	 for (cm = cc->members; cm != NULL; cm = cm->next) {
	    if (re_exec(cm->name)) {
	       cm->ignore = TRUE;
	     }
	    else if (infg) cm->ignore = FALSE;
	  };
       }
      else exc = NULL;
    };
};






/************************************************************************/
/*									*/
/*	disp_clear -- clear display information for all items		*/
/*									*/
/************************************************************************/


static void
disp_clear(cw,reset)
   CBROW_WIN cw;
   Boolean reset;
{
   CBROW_CLASS cc;
   CBROW_HIER ch;
   CBROW_MEMB cm;
   Sequence l;
   String s;
   Boolean fg;

   cw->memb_select = FALSE;
   cw->eval_select = FALSE;

   for (cc = cw->classes; cc != NULL; cc = cc->next) {
      if (reset) cc->ignore = FALSE;
      cc->gid = NULL;
      cc->done = FALSE;
      for (ch = cc->supers; ch != NULL; ch = ch->next_super) {
	 ch->gid = NULL;
       };
      for (cm = cc->members; cm != NULL; cm = cm->next) {
	 if (reset) cm->ignore = FALSE;
	 cm->gid = NULL;
       };
    };

   if (reset) {
     forin (s,String,l,default_class_exc) {
	CBROW_disp_class_regex(cw,NULL,FALSE,s,FALSE);
      };
     fg = (default_class_exc == NULL);
     forin (s,String,l,default_class_inc) {
	CBROW_disp_class_regex(cw,s,fg,NULL,FALSE);
	fg = FALSE;
      };

     forin (s,String,l,default_member_exc) {
	CBROW_disp_member_regex(cw,NULL,NULL,FALSE,s,FALSE);
      };
     fg = (default_member_exc == NULL);
     forin (s,String,l,default_member_inc) {
	CBROW_disp_member_regex(cw,NULL,s,fg,NULL,FALSE);
	fg = FALSE;
      };
   };
};





/************************************************************************/
/*									*/
/*	compute_displayed -- determine what should be displayed 	*/
/*									*/
/************************************************************************/


static Boolean
compute_displayed(cw)
   CBROW_WIN cw;
{
   CBROW_CLASS cc;
   Boolean fg;

   fg = FALSE;

   if (cw->display != NULL && !cw->display_all) {
      display_class(cw,cw->display,cw->display_super,cw->display_sub,cw->display_levels);
      fg = TRUE;
    }
   else {
      for (cc = cw->classes; cc != NULL; cc = cc->next) {
	 display_class(cw,cc,cw->display_super,cw->display_sub,cw->display_levels);
	 if (cc->gid != NULL) fg = TRUE;
       };
    };

   return fg;
};





/************************************************************************/
/*									*/
/*	display_class -- display a class and its super/sub classes	*/
/*									*/
/************************************************************************/


static void
display_class(cw,cc,sup,sub,lvls)
   CBROW_WIN cw;
   CBROW_CLASS cc;
   Boolean sup;
   Boolean sub;
   Integer lvls;
{
   CBROW_HIER ch;
   GELO_OBJECT go,gof;
   GELO_CONNECT gc;
   CBROW_MEMB cm;
   Integer i,j,ct,rh,lh;
   Integer mst;
   Float f;
   CBROW_MEMB dmem[MAX_MEMBS];
   Character buf[32];
   String s;

   if (cc->done) return;
   cc->done = TRUE;

   if (sup && lvls != 0 && !cc->ignore) {
      for (ch = cc->supers; ch != NULL; ch = ch->next_super) {
	 if (use_hier(cw,ch)) display_class(cw,ch->super,TRUE,FALSE,lvls-1);
       };
    };

   if (cc->gid == NULL && !cc->ignore) {
      go = GELOdefine_data();
      GELOdefine_data_text(go,cc->name);
      GELOset_owner(go,cw);
      GELOset_contents(go,0);
      GELOset_user_structure(go,cc);
      if (cc->isabstract) GELOdefine_data_fill(go,ABSTRACT_FILL);

      rh = ((cw->dmemb_links && cw->display == cc) ? 9 : 10);
      lh = (cw->dmemb_state ? 2 : 1);

      if (cw->dclass_simple && (cw->display != cc || cw->dclass_zoom == 0)) {
	 cc->gid = go;
	 GELOdefine_data_shape(cc->gid,SIMPLE_SHAPE);
       }
      else {
	 ct = display_members(cw,cc,MAX_MEMBS,dmem);
	 cc->gid = GELOdefine_tiled();
	 GELOdefine_tiled_box(cc->gid,TRUE);
	 GELOset_owner(cc->gid,cw);
	 GELOset_contents(cc->gid,0);
	 GELOset_user_structure(cc->gid,cc);
	 GELOdefine_data_shape(go,SHAPE_RECTANGLE);
	 GELOuse_default_y(go,TRUE);
	 GELOdefine_tiled_component(cc->gid,go,0,1,10,0,10.0,1.0,0.95);
	 if (ct > 0 && !cw->dclass_detail) {
	    go = GELOdefine_data();
	    GELOset_owner(go,cw);
	    GELOset_contents(go,0);
	    GELOset_user_structure(go,cc);
	    GELOdefine_data_shape(go,SHAPE_LINE);
	    GELOdefine_tiled_component(cc->gid,go,0,ct+1,1,1,1.0,1.0,0.9);
	    GELOuse_zero_size_y(go,TRUE);
	  };
	 j = -1;
	 mst = 0;
	 gof = NULL;
	 for (i = 0; i < ct; ++i) {
	    cm = dmem[i];
	    GELOuse_zero_size_y(cm->gid,TRUE);
	    GELOdefine_tiled_component(cc->gid,cm->gid,lh,i+2,rh,i+1,9.0,1.0,0.9);
	    if (cw->dclass_detail) {
	       if (j < 0) j = i;
	       else if (dmem[j]->isprivate != cm->isprivate ||
			   dmem[j]->isprotected != cm->isprotected ||
			   dmem[j]->isfriend != cm->isfriend ||
			   dmem[j]->isdata != cm->isdata) {
		  display_icon(cw,cc,dmem[j],i,j);
		  j = i;
		};
	     };

	    if (lh == 2) {
	       go = GELOdefine_data();
	       GELOset_owner(go,cw);
	       GELOset_contents(go,1);
	       GELOset_user_structure(go,cm);
	       GELOdefine_data_shape(go,SHAPE_RECTANGLE);
	       GELOuse_zero_size_y(go,TRUE);
	       GELOdefine_tiled_component(cc->gid,go,1,i+2,2,i+1,1.0,1.0,0.9);
	       s = buf;
	       if (dmem[i]->isconst) *s++ = 'C';
	       else if (dmem[i]->isstatic) *s++ = 'S';
	       if (dmem[i]->ispure) *s++ = 'P';
	       else if (dmem[i]->isvirtual) *s++ = 'V';
	       else if (dmem[i]->isfriend) *s++ = 'F';
	       if (dmem[i]->isinline) *s++ = 'I';
	       *s = 0;
	       if (buf[0] != 0) {
		  if (strlen(buf) > mst) {
		     mst = strlen(buf);
		     gof = go;
		   };
		  GELOdefine_data_text(go,CBROW_find_string(cw,buf));
		};
	     };

	    if (rh == 9) {
	       go = GELOdefine_data();
	       GELOset_owner(go,cw);
	       GELOset_contents(go,1);
	       GELOset_user_structure(go,cm);
	       GELOuse_zero_size_y(go,TRUE);
	       if (cm->defcls == NULL) {
		  GELOdefine_data_shape(go,SHAPE_NULL);
		}
	       else {
		  display_class(cw,cm->defcls,FALSE,FALSE,0);
		  GELOdefine_data_shape(go,SHAPE_FIELD);
		  if (cm->defcls->gid != NULL) {
		     gc = GELOnew_connect(go,GELO_PORT_RIGHT,cm->defcls->gid,GELO_PORT_ANY);
		     if (cw->connmethod == GELO_CONN_METHOD_PERT)
			GELOconnect_arc_style(gc,TYPE_STYLE,GELO_ARROW_SINGLE);
		     else
			GELOconnect_arc_style(gc,TYPE_STYLE,GELO_ARROW_SINGLE_ALL);
		     GELOdefine_layout_connect(cw->gid,gc);
		   };
		};
	       GELOdefine_tiled_component(cc->gid,go,9,i+2,10,i+1,1.0,1.0,0.9);
	     };
	  };
	 if (j >= 0) {
	    display_icon(cw,cc,dmem[j],i,j);
	  };
	 if (gof != NULL) {
	    GELOuse_default_x(gof,TRUE);
	    for (i = 1; i < ct; ++i) {
	       GELOdefine_tiled_constraint(cc->gid,dmem[0]->gid,dmem[i]->gid,
					      FALSE,FALSE,1.0,0.0);
	     };
	  };
       };

      if (cc == cw->display && cw->dclass_zoom > 0) {
	 f = cw->dclass_zoom;
	 GELOset_priority_x(cc->gid,f);
	 GELOset_priority_y(cc->gid,f);
	 if (cw->dclass_fixcur) GELOuse_default_y(cc->gid,TRUE);
       };

      GELOdefine_layout_component(cw->gid,cc->gid);
    };

   if (sub && lvls != 0 && !cc->ignore) {
      for (ch = cc->subs; ch != NULL; ch = ch->next_sub) {
	 if (use_hier(cw,ch)) display_class(cw,ch->sub,FALSE,TRUE,lvls-1);
       };
    };

   for (ch = cc->supers; ch != NULL; ch = ch->next_super) {
      add_arc(cw,ch);
    };

   for (ch = cc->subs; ch != NULL; ch = ch->next_sub) {
      add_arc(cw,ch);
    };
};






/************************************************************************/
/*									*/
/*	display_members -- create displays for members			*/
/*									*/
/************************************************************************/


static Integer
display_members(cw,cc,max,dmem)
   CBROW_WIN cw;
   CBROW_CLASS cc;
   Integer max;
   CBROW_MEMB dmem[];
{
   Integer i,ct;
   CBROW_MEMB cm;
   GELO_OBJECT go;

   ct = 0;

   for (cm = cc->members; cm != NULL; cm = cm->next) {
      if (ct < max && use_memb(cw,cm)) dmem[ct++] = cm;
    };

   qsort(dmem,ct,sizeof(CBROW_MEMB),CBROW_member_compare);

   for (i = 0; i < ct; ++i) {
      cm = dmem[i];
      go = GELOdefine_data();
      if (cw->dmemb_fullnames) GELOdefine_data_text(go,cm->pname);
      else GELOdefine_data_text(go,cm->dname);
      GELOset_owner(go,cw);
      GELOset_contents(go,1);
      GELOset_user_structure(go,cm);
      GELOdefine_data_shape(go,SHAPE_RECTANGLE);
      cm->gid = go;
    };

   return ct;
};






/************************************************************************/
/*									*/
/*	display_icon -- display icon showing member type		*/
/*									*/
/************************************************************************/


static void
display_icon(cw,cc,cm,i,j)
   CBROW_WIN cw;
   CBROW_CLASS cc;
   CBROW_MEMB cm;
   Integer i,j;
{
   GELO_OBJECT go;
   GELO_CONNECT gc;

   go = GELOdefine_data();
   GELOset_owner(go,cw);
   GELOset_contents(go,0);
   GELOset_user_structure(go,cc);

   if (cm->isdata) GELOdefine_data_shape(go,DATA_SHAPE);
   else if (cm->isfriend) GELOdefine_data_shape(go,FRIEND_SHAPE);
   else GELOdefine_data_shape(go,FUNCT_SHAPE);

   if (cm->isprivate) GELOdefine_data_fill(go,PRIVATE_FILL);
   else if (cm->isprotected) GELOdefine_data_fill(go,PROTECTED_FILL);
   else GELOdefine_data_fill(go,PUBLIC_FILL);

   GELOuse_default_x(go,TRUE);
   GELOuse_zero_size_y(go,TRUE);

   GELOdefine_tiled_component(cc->gid,go,0,i+1,1,j+1,1.0,1.0,0.9);

   if (!cm->isdata && cm->isfriend) {
      gc = GELOnew_connect(go,GELO_PORT_TOP_LEFT,go,GELO_PORT_BOTTOM_RIGHT);
      GELOconnect_arc_style(gc,ASH_STYLE_SOLID,GELO_ARROW_NONE);
      GELOdefine_tiled_connect(cc->gid,gc);
      gc = GELOnew_connect(go,GELO_PORT_TOP_RIGHT,go,GELO_PORT_BOTTOM_LEFT);
      GELOconnect_arc_style(gc,ASH_STYLE_SOLID,GELO_ARROW_NONE);
      GELOdefine_tiled_connect(cc->gid,gc);
    };
};





/************************************************************************/
/*									*/
/*	add_arc -- add arc object for hierarchy 			*/
/*									*/
/************************************************************************/


static void
add_arc(cw,ch)
   CBROW_WIN cw;
   CBROW_HIER ch;
{
   GELO_OBJECT go;
   GELO_CONNECT gc;
   ASH_LINE_STYLE sty;
   GELO_ARC_ARROW arc;

   if (ch->gid != NULL) return;
   if (!use_hier(cw,ch)) return;

   if (ch->super->gid == NULL || ch->sub->gid == NULL) return;

   arc = GELO_ARROW_SINGLE;
   if (ch->isvirtual) arc = GELO_ARROW_MARK;

   if (ch->isfriend) sty = FRIEND_STYLE;
   else if (ch->ispublic) sty = PUBLIC_STYLE;
   else sty = PRIVATE_STYLE;


   go = GELOdefine_arc();
   gc = GELOnew_connect(ch->super->gid,GELO_PORT_ANY,ch->sub->gid,GELO_PORT_ANY);

   GELOconnect_arc_style(gc,sty,arc);
   GELOdefine_arc_connect(go,gc);
   GELOset_contents(go,2);
   GELOset_owner(go,cw);
   GELOset_user_structure(go,ch);
   GELOdefine_layout_arc(cw->gid,go);
   ch->gid = go;
};





/************************************************************************/
/*									*/
/*	use_hier -- check if we should use hierarchy information	*/
/*									*/
/************************************************************************/


static Boolean
use_hier(cw,ch)
   CBROW_WIN cw;
   CBROW_HIER ch;
{
   if (cw->dclass_hier && !ch->isfriend) return TRUE;
   else if (cw->dclass_friend && ch->isfriend) return TRUE;

   return FALSE;
};




/************************************************************************/
/*									*/
/*	use_memb -- check if member should be displayed 		*/
/*									*/
/************************************************************************/


static Boolean
use_memb(cw,cm)
   CBROW_WIN cw;
   CBROW_MEMB cm;
{
   if (cw->dmemb_public && (cm->isprivate || cm->isprotected)) return FALSE;

   if (cm->isdata && !cw->dmemb_data) return FALSE;
   if (!cm->isdata && !cw->dmemb_method) return FALSE;
   if (cm->cls != cm->real_cls && !cw->dmemb_inher) return FALSE;
   if (cm->ignore) return FALSE;

   return TRUE;
};





/************************************************************************/
/*									*/
/*	hilite_member -- hilite member and its derivatives		*/
/*									*/
/************************************************************************/


static void
hilite_member(cw,cm,cc,fg)
   CBROW_WIN cw;
   CBROW_MEMB cm;
   CBROW_CLASS cc;
   Boolean fg;
{
   CBROW_MEMB sm;
   CBROW_HIER ch;
   Integer sty;

   for (sm = cc->members; sm != NULL; sm = sm->next) {
      if (sm->real_cls == cm->real_cls && STREQL(sm->name,cm->name) &&
	     STREQL(sm->file,cm->file) && sm->line == cm->line) {
	 if (sm->gid != NULL) {
	    sty = hilite_style(cw,cm,sm);
	    if (sty >= 0) GELOwindow_select(cw->disp_win,sm->gid,sty,fg);
	  };
	 for (ch = cc->subs; ch != NULL; ch = ch->next_sub) {
	    if (!ch->isfriend) hilite_member(cw,cm,ch->sub,fg);
	  };
	 break;
       };
    };
};





/************************************************************************/
/*									*/
/*	hilite_style -- find style for hilighting a member		*/
/*									*/
/************************************************************************/


static Integer
hilite_style(cw,cm,sm)
   CBROW_WIN cw;
   CBROW_MEMB cm;
   CBROW_MEMB sm;
{
   if (cm == sm) return MEMBER_STYLE;

   if (sm->cls == sm->real_cls) return DEFMEMBER_STYLE;

   if (CBROW_class_test_super(cm->cls,sm->cls)) return SUBMEMBER_STYLE;

   if (CBROW_class_test_super(sm->cls,cm->cls)) return SUPMEMBER_STYLE;

   return -1;
};





/************************************************************************/
/*									*/
/*	get_auxd_list -- get list of AUXD strings as Sequence		*/
/*									*/
/************************************************************************/


static Sequence
get_auxd_list(hdl,id)
   AUXD hdl;
   String id;
{
   String txt[1024];
   Integer ct,i;
   Sequence l;

   if (!AUXDget_defined(hdl,id)) return NULL;

   ct = AUXDget_info_list(hdl,id,1024,txt);

   l = NULL;
   for (i = ct-1; i >= 0; --i) l = CONS(txt[i],l);

   return l;
};





/* end of cbrowdisp.c */
