/************************************************************************/
/*									*/
/*		buildgraph.c						*/
/*									*/
/*	Dependency graph display for Make interface			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "build_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define SYSTEM_SHAPE		GELO_SHAPE_HEXAGON
#define BINARY_SHAPE		GELO_SHAPE_RECTANGLE
#define SOURCE_SHAPE		GELO_SHAPE_CIRCLE
#define HEADER_SHAPE		GELO_SHAPE_DIAMOND
#define OTHER_SHAPE		GELO_SHAPE_ROUND_RECTANGLE
#define DEFAULT_ARC_STYLE	ASH_STYLE_THICK
#define AUTOMATIC_ARC_STYLE	ASH_STYLE_SOLID
#define IMPLICIT_ARC_STYLE	ASH_STYLE_DASHED
#define DEFAULT_ARROW		GELO_ARROW_SINGLE_ALL





/************************************************************************/
/*									*/
/*	Local types							*/
/*									*/
/************************************************************************/


typedef struct _GRAPH_ITEM *	GRAPH_ITEM;


typedef struct _GRAPH_ITEM {
   BUILD_FILE file;
   BUILD_DEPEND depend;
   GELO_OBJECT item;
} GRAPH_ITEM_INFO;





/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	GELO_OBJECT	add_graph_file();
static	GELO_OBJECT	add_graph_conn();
static	void		add_graph_macro();





/************************************************************************/
/*									*/
/*	BUILD_graph_init -- module initialization			*/
/*									*/
/************************************************************************/


void
BUILD_graph_init()
{
};





/************************************************************************/
/*									*/
/*	BUILD_graph_setup -- setup dependency graph display		*/
/*									*/
/************************************************************************/


void
BUILD_graph_setup(bw)
   BUILD_WIN bw;
{
   if (bw->edit_win == NULL) return;

   GELOwindow_open(bw->edit_win);

   bw->gid = NULL;
   bw->items = NULL;

   BUILD_graph_update(bw);
};





/************************************************************************/
/*									*/
/*	BUILD_graph_remove -- remove dependency display 		*/
/*									*/
/************************************************************************/


void
BUILD_graph_remove(bw)
   BUILD_WIN bw;
{
   GRAPH_ITEM gi;
   Sequence l;

   if (bw->gid != NULL) {
      GELOwindow_close(bw->edit_win);
      bw->gid = NULL;
    };

   if (bw->items != NULL) {
      forin (gi,GRAPH_ITEM,l,bw->items) {
	 free(gi);
       };
      LFREE(bw->items);
      bw->items = NULL;
    };
};






/************************************************************************/
/*									*/
/*	BUILD_graph_update -- update dependency graph			*/
/*									*/
/************************************************************************/


void
BUILD_graph_update(bw)
   BUILD_WIN bw;
{
   Sequence l;
   GRAPH_ITEM gi;

   if (bw->gid != NULL) {
      GELOwindow_free(bw->edit_win,bw->gid);
      bw->gid = NULL;
    };
   if (bw->items != NULL) {
      forin (gi,GRAPH_ITEM,l,bw->items) {
	 free(gi);
       };
      LFREE(bw->items);
      bw->items = NULL;
    };

   bw->gid = GELOdefine_layout();
   GELOset_owner(bw->gid,bw);
   GELOdefine_layout_method(bw->gid,bw->method);
   GELOdefine_layout_conn_method(bw->gid,bw->connmethod);
   GELOdefine_layout_fixed(bw->gid,bw->fixed);
   GELOdefine_layout_standard(bw->gid,bw->standard);
   GELOdefine_layout_centered(bw->gid,bw->centered);

   if (bw->file != NULL) {
      add_graph_file(bw,bw->file);
    };

   GELOwindow_draw(bw->edit_win,bw->gid);
};





/************************************************************************/
/*									*/
/*	add_graph_file -- add item to layout for dependency graph	*/
/*									*/
/************************************************************************/


static GELO_OBJECT
add_graph_file(bw,bf)
   BUILD_WIN bw;
   BUILD_FILE bf;
{
   GRAPH_ITEM gi;
   Sequence l;
   BUILD_DEPEND bd;

   forin (gi,GRAPH_ITEM,l,bw->items) {
      if (bf == gi->file) return gi->item;
    };

   gi = PALLOC(GRAPH_ITEM_INFO);
   gi->item = GELOdefine_data();
   gi->file = bf;
   gi->depend = NULL;
   bw->items = APPEND(gi,bw->items);

   if (bf->type & (BUILD_TYPE_SYSTEM|BUILD_TYPE_BASIC)) {
      GELOdefine_data_shape(gi->item,SYSTEM_SHAPE);
    }
   else if (bf->type & BUILD_TYPE_BINARY) {
      GELOdefine_data_shape(gi->item,BINARY_SHAPE);
    }
   else if (bf->type & BUILD_TYPE_SOURCE) {
      GELOdefine_data_shape(gi->item,SOURCE_SHAPE);
    }
   else if (bf->type & BUILD_TYPE_HEADER) {
      GELOdefine_data_shape(gi->item,HEADER_SHAPE);
    }
   else {
      GELOdefine_data_shape(gi->item,OTHER_SHAPE);
    };

   GELOdefine_data_text(gi->item,bf->name);
   GELOdefine_layout_component(bw->gid,gi->item);
   GELOset_owner(gi->item,bw);
   GELOset_contents(gi->item,0);
   GELOset_user_structure(gi->item,bf);

   forin (bd,BUILD_DEPEND,l,bf->depends) {
      if (bd->file->type & BUILD_TYPE_MACRO) add_graph_macro(bw,bf,bd,gi->item);
      else add_graph_conn(bw,bd,gi->item,bd->file);
    };

   return gi->item;
};





/************************************************************************/
/*									*/
/*	add_graph_conn -- add connection in graph			*/
/*									*/
/************************************************************************/


static GELO_OBJECT
add_graph_conn(bw,bd,fit,tbf)
   BUILD_WIN bw;
   BUILD_DEPEND bd;
   GELO_OBJECT fit;
   BUILD_FILE tbf;
{
   GELO_OBJECT to;
   GRAPH_ITEM agi;
   GELO_CONNECT gc;

   to = add_graph_file(bw,tbf);

   agi = PALLOC(GRAPH_ITEM_INFO);
   agi->item = GELOdefine_arc();
   agi->file = NULL;
   agi->depend = bd;
   bw->items = APPEND(agi,bw->items);

   gc = GELOnew_connect(fit,GELO_PORT_ANY,to,GELO_PORT_ANY);
   if (bd->automatic) {
      GELOconnect_arc_style(gc,AUTOMATIC_ARC_STYLE,DEFAULT_ARROW);
    }
   else if (bd->implicit) {
      GELOconnect_arc_style(gc,IMPLICIT_ARC_STYLE,DEFAULT_ARROW);
    }
   else {
      GELOconnect_arc_style(gc,DEFAULT_ARC_STYLE,DEFAULT_ARROW);
    };

   GELOdefine_arc_connect(agi->item,gc);
   GELOset_contents(agi->item,1);
   GELOset_owner(agi->item,bw);
   GELOset_user_structure(agi->item,bd);
   GELOdefine_layout_arc(bw->gid,agi->item);

   return to;
};





/************************************************************************/
/*									*/
/*	add_graph_macro -- add macro to graph				*/
/*									*/
/************************************************************************/


static void
add_graph_macro(bw,bf,bd,fit)
   BUILD_WIN bw;
   BUILD_FILE bf;
   BUILD_DEPEND bd;
   GELO_OBJECT fit;
{
   BUILD_MACRO bm;
   BUILD_PROJ bp;
   String s;
   Integer i,bct;
   BUILD_FILE nbf;
   Character buf[1024];
   GELO_OBJECT nobj;
   Sequence l;
   BUILD_DEPEND bda;

   s = bd->file->name;
   if (s[0] == '$' && s[1] == '(') {
      strcpy(buf,&s[2]);
      s = rindex(buf,')');
      if (s != NULL) *s = 0;
      s = buf;
    };

   bm = BUILD_find_macro(bw->project,s);
   if (bm == NULL) {
      add_graph_conn(bw,bd,fit,bd->file);
      return;
    };

   bp = bw->project;
   s = bm->body;
   if (s == NULL) s = "";

   bct = 0;
   i = 0;
   for ( ; ; ) {
      if (isspace(*s) || *s == 0) {
	 if (i != 0) {
	    buf[i] = 0;
	    nbf = BUILD_find_file(buf,BUILD_TYPE_UNKNOWN,&bp);
	    if (nbf != NULL) {
	       nobj = add_graph_conn(bw,bd,fit,nbf);
	       forin (bda,BUILD_DEPEND,l,bd->file->depends) {
		  if (bda->file->type & BUILD_TYPE_MACRO) add_graph_macro(bw,nbf,bda,nobj);
		  else add_graph_conn(bw,bda,nobj,bda->file);
		};
	       ++bct;
	     };
	  }
	 i = 0;
       }
      else buf[i++] = *s;
      if (*s == 0) break;
      ++s;
    };

   if (bct == 0) {
      add_graph_conn(bw,bd,fit,bd->file);
    };
};





/* end of buildgraph.c */
