/************************************************************************/
/*									*/
/*		build_local.h						*/
/*									*/
/*	Local definitions for make interface package			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#define  PROT_NAME	BUILD__sema

#include <datatypes.h>
#include <sequence.h>
#include <ash.h>
#include <rip.h>
#include <stem.h>
#include <leaf.h>
#include <gelo.h>

#include <auxd.h>
#include <edt.h>
#include <msg.h>
#include <pmat.h>

#include <build.h>





/************************************************************************/
/*									*/
/*	Local Definitions						*/
/*									*/
/************************************************************************/


#define AVERAGE_METHOD		GELO_METHOD_DAVG2
#define DFS_METHOD		GELO_METHOD_DFS2
#define LEVEL_METHOD		(GELO_METHOD_BIT_LEVEL|GELO_METHOD_DAVG)
#define ANNEAL_METHOD		(GELO_METHOD_DAVG|GELO_METHOD_BIT_ANNEAL)

#define DEFAULT_METHOD		AVERAGE_METHOD
#define DEFAULT_CONNMETHOD	GELO_CONN_METHOD_DIRECT_RECT
#define DEFAULT_FIXED		FALSE
#define DEFAULT_STANDARD	FALSE
#define DEFAULT_CENTERED	TRUE




/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/



typedef struct _BUILD_PROJ *	BUILD_PROJ;
typedef struct _BUILD_FILE *	BUILD_FILE;
typedef struct _BUILD_DEPEND *	BUILD_DEPEND;
typedef struct _BUILD_MACRO *	BUILD_MACRO;
typedef struct _BUILD_WIN *	BUILD_WIN;
typedef struct _BUILD_FLAG *	BUILD_FLAG;
typedef struct _BUILD_FVAL *	BUILD_FVAL;
typedef struct _BUILD_FDEF *	BUILD_FDEF;



typedef Integer 	BUILD_TYPE;

#define BUILD_TYPE_UNKNOWN	0x0
#define BUILD_TYPE_SOURCE	0x1
#define BUILD_TYPE_HEADER	0x2
#define BUILD_TYPE_BINARY	0x4
#define BUILD_TYPE_SYSTEM	0x8
#define BUILD_TYPE_COMMAND	0x10
#define BUILD_TYPE_DEFAULT	0x20
#define BUILD_TYPE_SPECIAL	0x40
#define BUILD_TYPE_DIRECTORY	0x80

#define BUILD_TYPE_MATCH	0x100
#define BUILD_TYPE_BASIC	0x200
#define BUILD_TYPE_SCCS 	0x400

#define BUILD_TYPE_C		0x1000
#define BUILD_TYPE_PASCAL	0x2000
#define BUILD_TYPE_YACC 	0x4000
#define BUILD_TYPE_LEX		0x8000

#define BUILD_TYPE_USER1	0x10000
#define BUILD_TYPE_USER2	0x20000
#define BUILD_TYPE_USER3	0x40000
#define BUILD_TYPE_USER4	0x80000

#define BUILD_TYPE_MACRO	0x1000000
#define BUILD_TYPE_DEPEND	0x2000000
#define BUILD_TYPE_LIBRARY	0x4000000

#define BUILD_TYPE_GET_DFLT	0x40000000
#define BUILD_TYPE_ASK_MACRO	0x80000000

#define BUILD_TYPE_BASE_BITS	((0xff)|BUILD_TYPE_DEPEND|BUILD_TYPE_LIBRARY)
#define BUILD_TYPE_LANG_BITS	0xf000
#define BUILD_TYPE_BASE(t)	((t) & BUILD_TYPE_BASE_BITS)
#define BUILD_TYPE_LANG(t)	((t) & BUILD_TYPE_LANG_BITS)





typedef enum _BUILD_DISP {
   BUILD_DISP_NONE,
   BUILD_DISP_TRANSCRIPT,
   BUILD_DISP_INFO,
   BUILD_DISP_GRAPH,
   BUILD_DISP_FILES,
} BUILD_DISP;





typedef struct _BUILD_PROJ {
   String	system_name;
   String	system_dir;
   Sequence	systems;
   Sequence	commands;
   Sequence	files;
   Sequence	defaults;
   Sequence	macros;
   Sequence	librarys;
   String	make_name;
   String	temp_make;
   Integer	pipe_fd;
   Integer	cmd_pid;
   FILE *	trans_fd;
   String	transcript;
   Integer	trans_size;
   Integer	trans_len;
   String	trans_data;
   String	source_dir;
   String	last_file;
   Integer	last_line;
   String	last_proc;
   Integer	respond_id;
   String	last_cmd;
   Boolean	uptodate;
   Boolean	continue_opt;
   Boolean	show_opt;
   Boolean	touch_opt;
   Boolean	ignore_opt;
   Boolean	autodepend;
   Boolean	nosuffix;
   Integer	match_bits;
   Character	xtra[256];
} BUILD_PROJ_INFO;





typedef struct _BUILD_FILE {
   String	name;
   String	real_name;
   BUILD_FILE	from;
   Sequence	depends;
   String	build;
   BUILD_TYPE	type;
   BUILD_FILE	dflt;
   Sequence	expand_list;
   Integer	match_bits;
   Boolean	generated;
   Boolean	uptodate;
   Boolean	library;
   Boolean	autodepend;
   Boolean	silent;
   Boolean	ignore;
   Boolean	precious;
} BUILD_FILE_INFO;




typedef struct _BUILD_DEPEND {
   BUILD_FILE	file;
   Boolean	automatic;
   Boolean	implicit;
   Boolean	macro;
} BUILD_DEPEND_INFO;



typedef struct _BUILD_MACRO {
   String	name;
   String	body;
   String	option_name;
   Integer	bit_value;
   Boolean	defined;
   Boolean	perm;
   Boolean	library;
   BUILD_TYPE	dflt_type;
} BUILD_MACRO_INFO;




typedef struct _BUILD_FLAG {
   String name;
   Sequence defs;
} BUILD_FLAG_INFO;




typedef enum _BUILD_FDEF_TYPE {
   FDEF_CHOICE,
   FDEF_STRING,
   FDEF_MULTIPLE
} BUILD_FDEF_TYPE;




typedef struct _BUILD_FVAL {
   String option;
   String show;
} BUILD_FVAL_INFO;



typedef struct _BUILD_FDEF {
   BUILD_FDEF_TYPE type;
   Integer numvalues;
   BUILD_FVAL values;
} BUILD_FDEF_INFO;




typedef struct _BUILD_WIN {
   ASH_WINDOW	window;
   ASH_WINDOW	menu_win;
   ASH_WINDOW	disp_win;
   ASH_WINDOW	edit_win;
   BUILD_PROJ	project;
   BUILD_FILE	file;
   BUILD_MACRO	macro;
   EDT_ID	edit_info;
   BUILD_DISP	disp_type;
   Boolean	willow_fg;
   Boolean	trans_only;
   GELO_OBJECT gid;
   GELO_METHOD method;
   GELO_CONN_METHOD connmethod;
   Boolean fixed;
   Boolean standard;
   Boolean centered;
   Sequence items;
} BUILD_WIN_INFO;






/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/


					/* buildmain.c			*/
extern	void		BUILD_error();


					/* buildwin.c			*/
extern	void		BUILD_win_init();
extern	BUILD_WIN	BUILD_create();
extern	BUILD_WIN	BUILD_find_window();
extern	BUILD_WIN	BUILD_find_window_by_project();
extern	void		BUILD_update_project();
extern	void		BUILD_set_project();
extern	void		BUILD_set_file();
extern	void		BUILD_set_macro();
extern	void		BUILD_set_display();
extern	void		BUILD_update();



					/* buildmenu.c			*/
extern	void		BUILD_menu_init();
extern	void		BUILD_menu_setup();
extern	int		BUILD_button_project();
extern	int		BUILD_button_file();
extern	int		BUILD_button_display();
extern	void		BUILD_get_project();
extern	BUILD_FILE	BUILD_select_file();



					/* builddisp.c			*/
extern	void		BUILD_disp_init();
extern	void		BUILD_disp_setup();
extern	void		BUILD_disp_update();
extern	void		BUILD_disp_remove();
extern	void		BUILD_disp_transcript();



					/* buildcmd.c			*/
extern	void		BUILD_cmd_init();
extern	void		BUILD_cmd_make();
extern	void		BUILD_cmd_compile();
extern	void		BUILD_cmd_compile_go();
extern	void		BUILD_cmd_depends();



					/* builddata.c			*/
extern	void		BUILD_data_init();
extern	BUILD_PROJ	BUILD_find_project();
extern	BUILD_PROJ	BUILD_find_proj_by_file();
extern	void		BUILD_data_macro_define();
extern	BUILD_FILE	BUILD_data_file();
extern	void		BUILD_data_depend();
extern	void		BUILD_data_command();
extern	void		BUILD_data_set_rules();
extern	void		BUILD_data_macro_body();
extern	void		BUILD_data_macro_option();
extern	Boolean 	BUILD_data_cleanup();
extern	Integer 	BUILD_data_inq_projects();
extern	Integer 	BUILD_data_inq_info();
extern	Integer 	BUILD_data_inq_macros();
extern	BUILD_FILE	BUILD_find_file();
extern	BUILD_MACRO	BUILD_find_macro();
extern	void		BUILD_data_remove();
extern	void		BUILD_data_new_wd();



					/* buildfile.c			*/
extern	void		BUILD_file_init();
extern	void		BUILD_file_setup();
extern	void		BUILD_file_gen_makefile();
extern	void		BUILD_file_depends();



					/* buildsyn.y/buildlex.l	*/
extern	void		BUILD_syn_init();
extern	Boolean 	BUILD_read_file();




					/* buildmon.c			*/
extern	void		BUILD_mon_init();
extern	void		BUILD_mon_setup();
extern	void		BUILD_check_output();



					/* buildflag.c			*/
extern	void		BUILD_flag_init();
extern	Boolean 	BUILD_set_flags();



					/* buildgraph.c 		*/
extern	void		BUILD_graph_init();
extern	void		BUILD_graph_setup();
extern	void		BUILD_graph_remove();
extern	void		BUILD_graph_update();




/* end of build_local.h */







