/************************************************************************/
/*									*/
/*		annotdef.c						*/
/*									*/
/*	Definition routines for annotations				*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "annot_local.h"





/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


static	Sequence	all_annot_wdef;
static	Sequence	all_annot_bdef;
static	Sequence	all_annot_def;




/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	void		get_annot_defs();
static	void		get_button_defs();
static	void		get_window_defs();
static	void		get_icon_defs();





/************************************************************************/
/*									*/
/*	ANNOT_def_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
ANNOT_def_init()
{
   all_annot_wdef = NULL;
   all_annot_bdef = NULL;
   all_annot_def = NULL;

   get_annot_defs();
   get_button_defs();
   get_window_defs();
   get_icon_defs();
};





/************************************************************************/
/*									*/
/*	ANNOT_find_window_desc -- find window description by name	*/
/*	ANNOT_find_desc -- find annotation description by name		*/
/*	ANNOT_find_button_desc -- find button description by name	*/
/*									*/
/************************************************************************/


ANNOT_WDESC
ANNOT_find_window_desc(nm)
   String nm;
{
   Sequence l;
   ANNOT_WDESC wd;

   forin (wd,ANNOT_WDESC,l,all_annot_wdef) {
      if (STREQL(wd->name,nm)) break;
    };

   return wd;
};





ANNOT_DESC
ANNOT_find_desc(aw,nm)
   ANNOT_WIN aw;
   String nm;
{
   ANNOT_DESC ad;
   Sequence l,la;

   if (aw == NULL) la = all_annot_def;
   else la = aw->allowed;

   forin (ad,ANNOT_DESC,l,la) {
      if (STREQL(ad->name,nm)) break;
    };

   return ad;
};





ANNOT_BDESC
ANNOT_find_button_desc(aw,nm)
   ANNOT_WIN aw;
   String nm;
{
   ANNOT_BDESC bd;
   Sequence l,la;

   if (aw == NULL) la = all_annot_bdef;
   else la = aw->desc->buttons;

   forin (bd,ANNOT_BDESC,l,la) {
      if (STREQL(bd->name,nm)) break;
    };

   return bd;
};





/************************************************************************/
/*									*/
/*	ANNOT_inq_window_types -- return types of annotation windows	*/
/*	ANNOT_inq_types -- return types of annotations allowed		*/
/*									*/
/************************************************************************/


Integer
ANNOT_inq_window_types(mx,typ)
   Integer mx;
   ANNOT_WDESC typ[];
{
   Integer ct;
   Sequence l;
   ANNOT_WDESC ad;

   ct = 0;
   forin (ad,ANNOT_WDESC,l,all_annot_wdef) {
      typ[ct++] = ad;
      if (ct >= mx) break;
    };

   return ct;
};





Integer
ANNOT_inq_types(aw,mx,typ)
   ANNOT_WIN aw;
   Integer mx;
   ANNOT_DESC typ[];
{
   Integer ct;
   Sequence l,la;
   ANNOT_DESC ad;

   if (aw == NULL) la = all_annot_def;
   else la = aw->allowed;

   ct = 0;
   forin (ad,ANNOT_DESC,l,la) {
      typ[ct++] = ad;
      if (ct >= mx) break;
    };

   return ct;
};





/************************************************************************/
/*									*/
/*	get_annot_defs -- read in and create annotation definitions	*/
/*									*/
/************************************************************************/


static void
get_annot_defs()
{
   AUXD hdl;
   ANNOT_DESC ad;
   String s;
   Integer i;

   hdl = AUXDget_handle(NULL,"ANNOT");

   for (hdl = AUXDget_handle(hdl,"ANNOTATION"); hdl != NULL; hdl = AUXDnext_handle(hdl)) {
      ad = PALLOC(ANNOT_DESC_INFO);
      ad->name = AUXDget_info(hdl,"NAME");
      if (ad->name == NULL) continue;
      ad->display_text = AUXDget_info(hdl,"DISPLAY");
      s = AUXDget_info(hdl,"DISPLAY_FONT");
      if (s == NULL || *s == 0) ad->display_font = ASH_ICON_FONT;
      else ad->display_font = ASHloadfont(s);
      if (AUXDget_defined(hdl,"LEVEL")) ad->display_level = AUXDget_info_int(hdl,"LEVEL");
      else ad->display_level = 1;
      ad->msg_add = AUXDget_info(hdl,"MSG_ADD");
      ad->msg_remove = AUXDget_info(hdl,"MSG_REMOVE");
      ad->msg_set = AUXDget_info(hdl,"MSG_SET");
      ad->msg_unset = AUXDget_info(hdl,"MSG_UNSET");
      ad->msg_update = AUXDget_info(hdl,"MSG_UPDATE");

      ad->unique = AUXDget_defined(hdl,"UNIQUE");
      s = AUXDget_info(hdl,"UNIQUE_WITH");
      if (s != NULL) ad->unique_with = ANNOT_find_desc(NULL,s);
      else ad->unique_with = NULL;
      if (ad->unique_with == NULL) {
	 if (ad->unique) ad->unique_with = ad;
       }
      else ad->unique = TRUE;

      ad->display = AUXDget_defined(hdl,"IMMEDIATE");
      ad->save = AUXDget_defined(hdl,"SAVE");
      ad->private = AUXDget_defined(hdl,"PRIVATE");
      ad->position = POS_TEXT_BEGIN;
      ad->accumulate = AUXDget_defined(hdl,"ACCUMULATE");
      ad->query = AUXDget_defined(hdl,"QUERY");
      ad->multiple = AUXDget_defined(hdl,"MULTIPLE");
      ad->hilite = AUXDget_defined(hdl,"HILITE");
      ad->alternate = AUXDget_defined(hdl,"ALTERNATE");
      ad->join = AUXDget_defined(hdl,"JOIN");
      ad->splitonly = AUXDget_defined(hdl,"SPLIT_ONLY");
      s = AUXDget_info(hdl,"COLOR");
      if (s == NULL || ASHinq_configuration_depth(ASHinq_top()) == 1)
	 ad->color = ASHinq_foreground(ASHinq_top());
      else ad->color = ASHlookup_color(ASHinq_top(),s);
      i = AUXDget_info_list(hdl,"INFO",NUM_TEXT,ad->textinfo);
      for ( ; i < NUM_TEXT; ++i) ad->textinfo[i] = NULL;
      all_annot_def = APPEND(ad,all_annot_def);
    };
};





/************************************************************************/
/*									*/
/*	get_button_defs -- read in and create button definitions	*/
/*									*/
/************************************************************************/


static void
get_button_defs()
{
   AUXD hdl;
   ANNOT_BDESC bd;
   Integer i,ct;
   String defs[64];
   Sequence l;
   ANNOT_DESC ad;

   hdl = AUXDget_handle(NULL,"ANNOT");

   for (hdl = AUXDget_handle(hdl,"BUTTON"); hdl != NULL; hdl = AUXDnext_handle(hdl)) {
      bd = PALLOC(ANNOT_BDESC_INFO);
      bd->name = AUXDget_info(hdl,"NAME");
      if (bd->name == NULL) continue;
      bd->msg = AUXDget_info(hdl,"OUTPUT");
      bd->waitmsg = AUXDget_info(hdl,"WAIT_MSG");
      bd->save = AUXDget_defined(hdl,"SAVE");
      if (bd->waitmsg != NULL) bd->wait = TRUE;
      else bd->wait = AUXDget_defined(hdl,"WAIT");
      bd->file = AUXDget_defined(hdl,"FILE");
      ct = AUXDget_info_list(hdl,"REMOVE",64,defs);
      l = NULL;
      for (i = ct-1; i >= 0; --i) {
	 ad = ANNOT_find_desc(NULL,defs[i]);
	 if (ad == NULL) {
	    fprintf(stderr,"ANNOT: Unknown annotation type: %s\n",defs[i]);
	  }
	 else {
	    l = CONS(ad,l);
	  };
       };
      bd->remove = l;
      all_annot_bdef = APPEND(bd,all_annot_bdef);
    };
};





/************************************************************************/
/*									*/
/*	get_window_defs -- read in and create window definitions	*/
/*									*/
/************************************************************************/


static void
get_window_defs()
{
   AUXD hdl;
   ANNOT_WDESC wd;
   String defs[64];
   Integer i,ct;
   Sequence l;
   ANNOT_DESC ad;
   ANNOT_BDESC bd;
   Boolean pfg;

   hdl = AUXDget_handle(NULL,"ANNOT");

   for (hdl = AUXDget_handle(hdl,"WINDOW"); hdl != NULL; hdl = AUXDnext_handle(hdl)) {
      wd = PALLOC(ANNOT_WDESC_INFO);
      wd->name = AUXDget_info(hdl,"NAME");
      if (wd->name == NULL) continue;
      pfg = AUXDget_defined(hdl,"PARSE");

      ct = AUXDget_info_list(hdl,"USE",64,defs);
      l = NULL;
      for (i = ct-1; i >= 0; --i) {
	 ad = ANNOT_find_desc(NULL,defs[i]);
	 if (ad == NULL) {
	    fprintf(stderr,"ANNOT: Unknown annotation type: %s\n",defs[i]);
	  }
	 else {
	    pfg |= ad->save;
	    l = CONS(ad,l);
	  };
       };
      wd->allowed = l;

      ct = AUXDget_info_list(hdl,"SET",64,defs);
      l = NULL;
      for (i = ct-1; i >= 0; --i) {
	 ad = ANNOT_find_desc(NULL,defs[i]);
	 if (ad == NULL) {
	    fprintf(stderr,"ANNOT: Unknown annotation type: %s\n",defs[i]);
	  }
	 else {
	    l = CONS(ad,l);
	  };
       };
      wd->set_on = l;

      ct = AUXDget_info_list(hdl,"SEARCH",64,defs);
      l = NULL;
      for (i = ct-1; i >= 0; --i) {
	 ad = ANNOT_find_desc(NULL,defs[i]);
	 if (ad == NULL) {
	    fprintf(stderr,"ANNOT: Unknown annotation type: %s\n",defs[i]);
	  }
	 else {
	    l = CONS(ad,l);
	  };
       };
      wd->search_for = l;

      ct = AUXDget_info_list(hdl,"BUTTONS",64,defs);
      l = NULL;
      for (i = ct-1; i >= 0; --i) {
	 bd = ANNOT_find_button_desc(NULL,defs[i]);
	 if (bd == NULL) {
	    fprintf(stderr,"ANNOT: Unknown button type: %s\n",defs[i]);
	  }
	 else {
	    l = CONS(bd,l);
	  };
       };
      wd->buttons = l;

      wd->readonly = AUXDget_defined(hdl,"READONLY");
      wd->create = AUXDget_defined(hdl,"CREATE");
      wd->sensitive = AUXDget_info_int(hdl,"SENSITIVE");
      wd->savectl = AUXDget_defined(hdl,"CONTROL");
      wd->autofile = AUXDget_defined(hdl,"AUTOFILE");
      ct = AUXDget_info_list(hdl,"MSG_OPEN",64,defs);
      wd->msg_open = NULL;
      for (i = 0; i < ct; ++i) wd->msg_open = APPEND(defs[i],wd->msg_open);
      wd->msg_close = AUXDget_info(hdl,"MSG_CLOSE");
      wd->title = AUXDget_info(hdl,"TITLE");
      wd->parse = pfg;
      wd->mode = AUXDget_info(hdl,"MODE");
      wd->choicepdm = AUXDget_defined(hdl,"CHOICEMENU");
      wd->nopdm = AUXDget_defined(hdl,"NOMENU");
      wd->nowindow = AUXDget_defined(hdl,"NOWINDOW");
      wd->disable = AUXDget_defined(hdl,"DISABLE");
      if (AUXDget_defined(hdl,"LEVEL")) wd->level = AUXDget_info_int(hdl,"LEVEL");
      else wd->level = 1024;

      all_annot_wdef = APPEND(wd,all_annot_wdef);
    };
};





/************************************************************************/
/*									*/
/*	get_icon_defs							*/
/*									*/
/************************************************************************/


static void
get_icon_defs()
{
   AUXD hdl;
   String name;
   Integer xsz,ysz;
   Integer data[128];

   hdl = AUXDget_handle(NULL,"ANNOT");

   for (hdl = AUXDget_handle(hdl,"ICON"); hdl != NULL; hdl = AUXDnext_handle(hdl)) {
      name = AUXDget_info(hdl,"NAME");
      xsz = AUXDget_info_int(hdl,"XSIZE");
      ysz = AUXDget_info_int(hdl,"YSIZE");
      AUXDget_info_list_int(hdl,"DATA",128,data);
      if (name == NULL || xsz == 0 || ysz == 0) continue;
      ASHicon_define(name,xsz,ysz,data);
    };
};





/* end of annotdef.c */


