/************************************************************************/
/*									*/
/*		threaddummy.c						*/
/*									*/
/*	Stubs for when we don't want to use threads                     */
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "DATATYPES.h"
#include <syscall.h>
#include "bwethread.h"


/************************************************************************/
/*									*/
/*	Storage 							*/
/*									*/
/************************************************************************/


#ifdef THREADcurrent
#undef THREADcurrent
#endif

	THREAD			THREADcurrent = NULL;
	THREAD_QUEUE_HEAD	THREADrunq = NULL;




/************************************************************************/
/*									*/
/*	Thread stubs							*/
/*									*/
/************************************************************************/


void
THREADbeing(pr) { };

void
THREADend() { };

void
THREADreschedule() { };

int
THREADstackspaceinit(sz,num) { return 1; }

void
THREADsetpriority(th,pr) { };

THREAD
THREADwaitforchild() { return NULL; }

int
THREADeliminatechile(th) { return 1; }

int
THREADreturnvalue(th) { return 0; }

void
THREADmurder(tcb) { return; }

THREAD_QUEUE
THREADmakequeuehead() { return NULL; }

THREAD
THREADqueuenext(q) { return NULL; }

int
THREADmovetorunq(th) { return 1; }

int
THREADmovetowaitq(th,q) { return 0; }

THREAD
THREADpullfromq(th) { return NULL; }

int
THREADanyonewantthecpu() { return 1; }

int
THREADsetexception(hdlr,olds) { return 0; }

void
THREADrestoreexception(ols) { };

int
THREADraiseexception(th,p) { return 0; }

EXCEPTION
THREADgetexceptionspace() { return NULL; }

void
THREADfreeexceptionspace(sp) { };

int
THREADgetexceptionreturn() { return NULL; }

void
THREADfakesignal(t,f,p,s) { };

int
THREADstackremaining() { return 262144; }

void
THREADstartclock(s,us) { };

void
THREADstopclock() { };

int
THREADtype1_register(sz,f1,f2,f3,f4) { return 0; }

char *
THREADdynamic(th,off) { return NULL; }

SEMAPHORE
THREADseminit(ct) { return NULL; }

void
THREADpsem(s) { };

void
THREADvsem(s) { };

THREAD_MONITOR
THREADmonitorinit() { return NULL; }

void
THREADmonitorfree(m) { };

int
THREADmonitorentry(m) { return 0; }

int
THREADmonitorexit(m) { return 0; }

int
THREADmonitorsignalandexit(m) { return 0; }

int
THREADmonitorwait(m) { return 0; }

int
THREADmonitorwaitevent(m) { return 0; }

int
THREADregistersignal(sig,nhd,ohd) { return NULL; }

int
THREADfrozen(th) { return 0; }

THREAD
THREADfrozenparent(th) { return NULL; }

int
THREADopen(f) { return 1; }

int
THREADread(f,buf,ct) { return read(f,buf,ct); }

int
THREADwrite(f,buf,ct) { return write(f,buf,ct); }

int
THREADaccept(f,addr,ln) { return accept(f,addr,ln); }

int
THREADconnect(f,addr,ln) { return connect(f,addr,ln); }

int
THREADclose(f) { return close(f); }

void
THREADsetnononblockingio() { }

int
THREADgo(np,dsz,f,a,asz,ssz,p)
   int np;
   int dsz;
   void (*f)();
   int * a;
   int asz;
   int ssz;
   int p;
{
   if (asz == 0) (*f)(a);
   else (*f)(&a);

   return 0;
};

THREAD
THREADcreate(f,a,asz,det,ssz,pr)
   void (*f)();
   int * a;
   int asz;
   int det;
   int ssz;
   int pr;
{
   if (asz == 0) (*f)(a);
   else (*f)(&a);

   return NULL;
};






/************************************************************************/
/*									*/
/*	getc and putc -- IO stubs					*/
/*	select, fcntl and read -- syscall stubs 			*/
/*									*/
/************************************************************************/


int
getc(st)
   FILE * st;
{
   return fgetc(st);
};


int
putc(c,st)
   char c;
   FILE * st;
{
   return fputc(c,st);
};




#ifdef sun

int
select(c,r,w,e,t)
{
   return syscall(SYS_select,c,r,w,e,t);
};

int
fcntl(f,o,v)
{
   return syscall(SYS_fcntl,f,o,v);
};

int
read(f,b,l)
{
   return syscall(SYS_read,f,b,l);
};

#endif




/* end of threaddummy.c */


