/*

 thread - thread package.

 Copyright 1986 Thomas W. Doeppner Jr. - Brown University - All rights reserved.

*/

#ifndef _THREADS_
#define _THREADS_

/* opaque types */
/* (I.e, none of your goddam business) */

typedef struct thread_control_block *THREAD;
typedef struct thread_queue *THREAD_QUEUE;
typedef struct {
   int guts[5];
} THREAD_QUEUE_HEAD;

typedef struct semaphore *SEMAPHORE;

typedef struct exception_state *EXCEPTION;
typedef struct {
#ifdef mips
   int guts[40];
#else
   int guts[24];
#endif mips
} EXCEPTION_BLOCK;

typedef struct thread_monitor_condition *THREAD_MONITOR_CONDITION;
typedef struct {
   int guts[4];
} THREAD_MONITOR_CONDITION_HEAD;

typedef struct thread_monitor_block *THREAD_MONITOR;
typedef struct {
   int guts[25];
} THREAD_MONITOR_BLOCK;

typedef struct thread_manager_block *THREAD_MANAGER;
typedef struct {
   int guts[10];
} THREAD_MANAGER_BLOCK;

typedef struct sighandler {
   int type;
   THREAD (*whichthread)();
   void (*func)();
   int stacksize;
   int priority;
} SIGHANDLER;

#define SIG_EXCEPTION		1
#define SIG_SENDSIG		2
#define SIG_CREATETHREAD	3

typedef struct uthreadcontrol *UTHREAD_CONTROL;

/* entry points */

#ifdef abetterworld
extern void free();
#endif
extern char *malloc();
extern char *memalign();
extern char *realloc();
extern int THREADaccept();
extern int THREADanyonewantthecpu();
extern void THREADbegin();
extern char *THREADbeginstack();
extern void THREADclockhandler();
extern int THREADclose();
extern int THREADconnect();
extern THREAD THREADcreate();
extern char *THREADdynamic();
extern int THREADeliminatechild();
extern void THREADend();
extern char *THREADendstack();
extern THREAD THREADexternal();
extern void THREADfakesignal();
extern void THREADfreeexceptionspace();
extern int THREADfrozen();
extern THREAD THREADfrozenparent();
extern int THREADgetexceptionreturn();
extern EXCEPTION THREADgetexceptionspace();
extern THREAD_QUEUE THREADmakequeuehead();
extern int THREADmonitorentry();
extern int THREADmonitorexit();
extern void THREADmonitorfree();
extern THREAD_MONITOR THREADmonitorinit();
extern int THREADmonitorsignalandexit();
extern int THREADmonitorwait();
extern int THREADmonitorwaitevent();
extern int THREADmovetorunq();
extern int THREADmovetowaitq();
extern void THREADmurder();
extern int THREADopen();
extern THREAD THREADparent();
extern void THREADprotect();
extern void THREADpsem();
extern THREAD THREADpullfromq();
extern THREAD THREADqueuenext();
extern int THREADraiseexception();
extern int THREADread();
extern int THREADregistersignal();
extern void THREADreschedule();
extern void THREADrestoreexception();
extern int THREADreturnvalue();
extern SEMAPHORE THREADseminit();
extern void THREADseterrorlevel();
extern int THREADsetexception();
extern void THREADsetpriority();
extern void THREADsetnononblockingio();
extern void THREADsignotify();
extern int THREADstackremaining();
extern int THREADstackspaceinit();
extern void THREADstartclock();
extern void THREADstdiorelease();
extern void THREADstdiotake();
extern void THREADstopclock();
extern void THREADsuicide();
extern void THREADtellmanagement();
extern void THREADunprotect();
extern UTHREAD_CONTROL THREADuthread_create();
extern void THREADuthread_go();
extern void THREADuthread_kill();
extern void THREADuthread_park();
extern void THREADuthread_ready();
extern void THREADvsem();
extern THREAD THREADwaitforchild();
extern int THREADwrite();

/* well-known globals */
#ifndef ns32000
extern THREAD THREADcurrent;
#else ns32000
/* this is the multiprocessor case */
#ifndef NBPG
#define NBPG (4*1024)
#include <privatedata.h>
#undef NBPG
#else
#include <privatedata.h>
#endif NBPG
#define THREADcurrent (processor_private.current)
#endif ns32000

/* useful macros */

#define THREADinq_current()  THREADcurrent

extern int errno;

#define THREADerrno							     \
	((THREADcurrent != NULL) ? (*(int *)THREADcurrent) : errno)

#define THREADseterrno(errcode) 					     \
	{								     \
	   if (THREADcurrent != NULL)					     \
	      (*(int *)THREADcurrent) = errcode;			     \
	   errno = errcode;						     \
	}

/* standard I/O */

#include <stdio.h>

THREAD_MONITOR THREADstdiomon[64];    /* This should be NOFILE */
THREAD_MONITOR THREADstdiobufmon;
#undef getc
#undef putc
#define _getc(p)	 (--(p)->_cnt>=0? \
	(int)(*(unsigned char *)(p)->_ptr++) : _filbuf(p))
#define _putc(x, p)	 (--(p)->_cnt >= 0 ?\
	(int)(*(unsigned char *)(p)->_ptr++ = (x)) :\
	(((p)->_flag & _IOLBF) && -(p)->_cnt < (p)->_bufsiz ?\
		((*(p)->_ptr = (x)) != '\n' ?\
			(int)(*(unsigned char *)(p)->_ptr++) :\
			_flsbuf(*(unsigned char *)(p)->_ptr, p)) :\
		_flsbuf((unsigned char)(x), p)))

#endif _THREADS_
