/************************************************************************/
/*									*/
/*		DATATYPES.h						*/
/*									*/
/*	Basic data type definitions and language extensions		*/
/*									*/
/************************************************************************/
/*	Copyright 1984 Brown University 				*/

#ifndef DATATYPES_ALREADY_INCLUDED
#define DATATYPES_ALREADY_INCLUDED

#include <ctype.h>





/************************************************************************/
/*									*/
/*	Basic types							*/
/*									*/
/************************************************************************/


typedef int	Integer;
typedef double	Float;
typedef char	Boolean;
typedef short	Short;
typedef char	Byte;
typedef char *	String;
typedef int	Universal;
typedef char *	Univ_Ptr;
typedef char	Character;
typedef long	Set;
typedef int	(*Function_Ptr)();
typedef void	(*VoidFunction_Ptr)();





/************************************************************************/
/*									*/
/*	Constants							*/
/*									*/
/************************************************************************/


#define READONLY static

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef NULL
#define NULL 0
#endif




/************************************************************************/
/*									*/
/*	Language extenions						*/
/*									*/
/************************************************************************/


#define MIN(x,y) ((x) < (y) ? (x) : (y))
#define MAX(x,y) ((x) > (y) ? (x) : (y))
#define ABS(x)	 ((x) < 0 ? -(x) : (x))

#define PALLOC(typ) ((typ *) calloc(1,sizeof(typ)))

#ifdef sparc
#include <alloca.h>
#endif

#ifndef __cplusplus
extern	double		atof();
#endif




/************************************************************************/
/*									*/
/*	String extensions						*/
/*									*/
/************************************************************************/


#define SALLOC(str) ((str == NULL) ? NULL : (strcpy(malloc(strlen(str)+1),str)))
#define SFREE(str) (str != NULL && (free(str),0))

#define STREQL(s1,s2) (strcmp((s1),(s2)) == 0)
#define STRNEQ(s1,s2) (strcmp((s1),(s2)) != 0)
#define STRLSS(s1,s2) (strcmp((s1),(s2)) < 0)
#define STRLEQ(s1,s2) (strcmp((s1),(s2)) <= 0)
#define STRGTR(s1,s2) (strcmp((s1),(s2)) > 0)
#define STRGEQ(s1,s2) (strcmp((s1),(s2)) >= 0)

#define STREMPTY(s1) ((s1) == NULL || *(s1) == 0)

#define NULLSTRING	((String) NULL)

#ifndef __cplusplus
extern	String	index(),rindex(),strcpy(),getenv();
#endif




/************************************************************************/
/*									*/
/*	Set extensions							*/
/*									*/
/************************************************************************/


#define SET_PUTIN(loc,flags) ((loc) |= (flags))
#define SET_TAKEOUT(loc,flags) ((loc) &= ~(flags))
#define SET_ANY_IN(loc,flags) (((loc)&(flags)) != 0)
#define SET_ALL_IN(loc,flags) (((loc)&(flags)) == (flags))
#define SET_NONE_IN(loc,flags) (((loc)&(flags)) == 0)




#endif





