#include "dl_local.h"
#include "table.c"

#define STR_EQUAL(A,B)	(*(A) == *(B) && ! strcmp(A,B))

/*
 * Returns hashed value of a name.  This is the same function as in the
 * "build_table" program that builds the hash table.
 */

static
DL_sys_hashit(name)
char *name;
{
   register int 	i = 0;
   register char	*c;

   for (c = name; *c; c++) i += *c;

   return(i % HASHSIZE);
}

/*
 * This is passed the name of a system routine or variable that is currently
 * undefined.  This loads the .o file that defines the symbol from the archive
 * in which it lives.
 */

DL_FunctionPtr
DLsystem_names(symbol)
char *symbol;
{
   register int 	hash, trip, last;
   register DL_FunctionPtr ret = NULL;

   hash = DL_sys_hashit(symbol);

   /* Look at all triples with same hash key, until symbol is found (or not) */
   for (last = hash + 1; last < HASHSIZE && DL_hashtab[last] < 0; last++) ;

   last = (last == HASHSIZE ? NUMSYMBOLS : DL_hashtab[last]);

   for (trip = DL_hashtab[hash]; trip >= 0 && trip < last; trip++)
      if (STR_EQUAL(DL_symbols[DL_triples[trip][SYMBOL]], symbol)) break;

   /* If we have a match, trip will be < last */
   if (trip >= 0 && trip < last) {

      if (! DLload_archive_element(DL_libs[DL_triples[trip][LIB]],
				   DL_ofiles[DL_triples[trip][OFILE]]))
	 (void) fprintf(stderr, "DL: unable to load %s from %s.\n",
			   DL_ofiles[DL_triples[trip][OFILE]],
			   DL_libs[DL_triples[trip][LIB]]);

      else {
	 if (*symbol == '_') symbol++;
	 ret = DLlookup(symbol);
      }
   }
   return(ret);
}

