/************************************************************************/
/*									*/
/*		dlruntime.c						*/
/*									*/
/*	Primary run time entrys for dynamic loading			*/
/*									*/
/************************************************************************/
/*	Copyright 1987 Brown University -- Steven P. Reiss		*/


#include "dl_local.h"





/************************************************************************/
/*									*/
/*	Global variables						*/
/*									*/
/************************************************************************/


	Boolean 	DL__inited = 0;
	Boolean 	DL__print_errors = 0;

static	Boolean 	DL__prepend_;

extern	Integer 	DL__library_count;
extern	String		DL__librarys[];




/************************************************************************/
/*									*/
/*	Forward references						*/
/*									*/
/************************************************************************/


static	void		load_librarys();




/************************************************************************/
/*									*/
/*	DLinit -- initialize dynamic loader				*/
/*									*/
/************************************************************************/


int
DLinit()
{
   DL_HashKey loc;
   DL_ISYM n;
   Integer i;
   Address link;

   if (!DL__inited && DL__esd != NULL) {
      DL__prepend_ = DL_x_prepend_();
      for (i = 0; i < DL__esd->num_syms; ++i) {
	 n = &DL__esd->sym[i];
	 if (!DL_lookup(n->dn_name,&loc))
	    DL_enter(n,loc,0);
       };

      DL__inited = 1;
      DL_load_init();
      load_librarys();
    };

   return(DL__inited);
};





/************************************************************************/
/*									*/
/*	DLlookup -- lookup address of symbol				*/
/*									*/
/************************************************************************/


DL_FunctionPtr
DLlookup(name)
   char *name;
{
   DL_ISYM n;
   char name_buf[512];
   int nval,i;
   char anm[32];

   if (DL__inited || DLinit()) {
      if (DL__prepend_) {
	 name_buf[0] = '_';
	 strcpy(&name_buf[1],name);
	 name = name_buf;
       };
      n = DL_lookup(name,NULL);
      if (n != NULL && !n->dn_stub) {
	 return((DL_FunctionPtr) n->dn_value);
       };
    };

   return((DL_FunctionPtr) NULL);
}





/************************************************************************/
/*									*/
/*	DLload -- load the specified file				*/
/*	DLload_archive_element -- load member of archive		*/
/*									*/
/************************************************************************/


int
DLload(pathname)
   char *pathname;
{
   if (!DL__inited && !DLinit()) return(0);

   return DL_load_file(pathname, NULL);
}




int
DLload_archive_element(archive,element)
   char *archive;
   char *element;
{
   if (!DL__inited && !DLinit()) return(0);

   return DL_load_file(archive, element);
}




/************************************************************************/
/*									*/
/*	DLnameof -- find name given address				*/
/*									*/
/************************************************************************/


int
DLnameof(function, name, maxlen)
   DL_FunctionPtr function;
   char *name;
   int maxlen;
{
   String local_name;
   Integer len;

   if (!DL__inited && !DLinit() || name == NULL) {
      return FALSE;
    }
   else {
      *name = '\0';
      local_name = DL_nameof(function);
      if (local_name != NULL) {
	 len = strlen(local_name);
	 if (len >= maxlen) {
	    strncpy(name, local_name, maxlen);
	    name[maxlen-1] = '\0';
	    return TRUE;
	  }
	 else {
	    bcopy(local_name, name, len+1);
	    return FALSE;
	  };
       };
    };

   return FALSE;
}




/************************************************************************/
/*									*/
/*	DLprint_errors -- indicate whether errors are printed or not	*/
/*	DL_error -- print error if user desires 			*/
/*									*/
/************************************************************************/


void
DLprint_errors(flag)
   int flag;
{
   DL__print_errors = flag;
}





void
DL_error(s1, s2)
   String s1,s2;
{
   if (DL__print_errors) fprintf(stderr, "DL: %s: %s\n", s1, s2);
}





/************************************************************************/
/*									*/
/*	load_librarys -- load global librarys				*/
/*									*/
/************************************************************************/


static void
load_librarys()
{
   register int i;

   for (i = 0; i < DL__library_count; ++i) {
      if (!DL_load_file(DL__librarys[i],NULL)) {
	 DL_error("DL_init: Problem loading library ",DL__librarys[i]);
       };
    };
};





/* end of dlruntime.c */
