/************************************************************************/
/*									*/
/*		dl_local.h						*/
/*									*/
/*	Local definitions for dynamic loading				*/
/*									*/
/************************************************************************/
/*	Copyright 1987 Brown University -- Steven P. Reiss		*/


#include <stdio.h>
#include "datatypes.h"
#include "dl.h"





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_SEGMENT	8





/************************************************************************/
/*									*/
/*	Relocation information						*/
/*									*/
/*	This type determines the relocation type.  It is meant to	*/
/*	include the standard relocations for most architectures 	*/
/*	(notably sparc).  Machine types should be mapped into these	*/
/*									*/
/************************************************************************/


typedef Short	RELOC_TYPE;

#define RTYPE_NONE	0
#define RTYPE_8 	1		/* 8 bit relocation		*/
#define RTYPE_16	2		/* 16 bit relocation		*/
#define RTYPE_32	3		/* 32 bit relocation		*/
#define RTYPE_DISP8	4		/* 8 bit pc-relative relocation */
#define RTYPE_DISP16	5		/* 16 bit pc-relative		*/
#define RTYPE_DISP32	6		/* 32 bit pc-relative		*/
#define RTYPE_WDISP30	7		/* SR word displacement 	*/
#define RTYPE_WDISP22	8		/* SR word displacement 	*/
#define RTYPE_HI22	9		/* SR 22 bit relocations	*/
#define RTYPE_22	10		/* lo 22 bits			*/
#define RTYPE_13	11		/* 13 bit relocation		*/
#define RTYPE_LO10	12		/* 10 bit relocation		*/
#define RTYPE_SFA_BASE	13		/* sfa base type relocation	*/
#define RTYPE_SFA_OFF13 14		/* sfa offset relocation	*/
#define RTYPE_SEGOFF16	15		/* ShLib offset in segment	*/
#define RTYPE_DELTA8	16		/* ns32000 displacements	*/
#define RTYPE_DELTA16	17
#define RTYPE_DELTA32	18
#define RTYPE_DSDL8	19		/* pc-rel ns32000 displacements */
#define RTYPE_DSDL16	20
#define RTYPE_DSDL32	21
#define RTYPE_IMMED32	22		/* ns32000 immediate		*/
#define RTYPE_SBREL32	23		/* ns32000 base relative	*/
#define RTYPE_HI16	24		/* high order 16 bits -- mips	*/
#define RTYPE_LO16	25		/* low order 16 bits -- mips	*/

#define RTYPE_MACHINE_BASE 64		/* machine specific types	*/
#define RTYPE_MACHINE(n)    (RTYPE_MACHINE_BASE+(n))



#define SEGMENT_ABS	(64)
#define SEGMENT_UNDEF	(65)
#define SEGMENT_COMMON	(66)
#define SEGMENT_IGNORE	(67)





/************************************************************************/
/*									*/
/*	Type definitions						*/
/*									*/
/************************************************************************/


typedef unsigned char * 	Address;

typedef struct _DL_ISYM *	DL_ISYM;

typedef struct _DL_SEGMENT *	DL_SEGMENT;
typedef struct _DL_FILE *	DL_FILE;
typedef struct _DL_ESYM *	DL_ESYM;
typedef struct _DL_RELOC *	DL_RELOC;




typedef struct _DL_ISYM {	/* symbol definitions for internal tbls */
   String  dn_name;
   Integer dn_value;
   Boolean dn_stub;
   Boolean dn_undef;
   Short   dn_dummy;
} DL_ISYM_INFO;




typedef struct DL_esd_s {	/* header from dynload program		*/
   Integer num_syms;		/* number of symbols defined */
   Integer num_linkage; 	/* number of relocation records */
   DL_ISYM_INFO sym[1]; 	/* Varying length */
} DL_ESD;

typedef DL_ISYM *	 DL_HashKey;




typedef struct _DL_SEGMENT {
   Address base;
   DL_RELOC reloc;
   Integer offset;
   Integer poffset;
   Integer reloc_size;
   Integer length;
} DL_SEGMENT_INFO;



typedef struct _DL_FILE {
   DL_FILE next;
   DL_ESYM syms;
   String strings;
   Integer numsym;
   Integer numseg;
   DL_SEGMENT_INFO segs[MAX_SEGMENT];
   Address common;
   String fname;
   String ename;
   Address basereg;
} DL_FILE_INFO;




typedef struct _DL_RELOC {
   unsigned int dr_address;
   Integer	dr_index;		/* symbol index or segment number	*/
   Boolean	dr_symbol;
   Short	dr_type;
   Integer	dr_value;
} DL_RELOC_INFO;




typedef struct _DL_ESYM {	/* symbol definitions for external symbols	*/
   String  ds_name;
   Integer ds_value;
   Short   ds_segment;
   Boolean ds_extern;
} DL_ESYM_INFO;



typedef struct _DL_LINK {	/* linkage table			*/
   Address addr;
   int symid;
} DL_LINK_INFO;




/************************************************************************/
/*									*/
/*	External storage						*/
/*									*/
/************************************************************************/


extern	Boolean 	DL__inited;
extern	Boolean 	DL__print_errors;

extern	DL_ESD *	DL__esd;

extern	DL_LINK_INFO	DL__stub_branch_table[];

extern	String		DL__unresolvable_routine;
extern	String		DL__unresolvable_caller;





/************************************************************************/
/*									*/
/*	External entry points for package use only			*/
/*									*/
/************************************************************************/


					/* dlruntime.c			*/
extern	void		DL_error();


					/* dlsymtab.c			*/
extern	DL_ISYM 	DL_lookup();
extern	String		DL_nameof();
extern	Boolean 	DL_enter();
extern	DL_ISYM 	DL_symbol_at();
extern	Integer 	DL_symbol_index();


					/* dlcommon.c			*/
extern	void		DL_load_init();
extern	void		DL_fill_in_linkage_seg();
extern	void		DL_unable_to_resolve();
extern	DL_FunctionPtr	DL_stub_routine();
extern	String		DL_find_basis_reference();
extern	char *		DL_pro_dir();
extern	char *		DL_arch();



					/* dlloader.c			*/
extern	void		DL_load_subinit();
extern	Boolean 	DL_load_file();
extern	String		DL_find_reference();


					/* dlstub.c			*/
extern	Integer 	DL_stub();
extern	Integer 	DL_ext_stub();
extern	DL_FunctionPtr	DL_stub_routine();



					/* machine dependent routines	*/
extern	Boolean 	DL_x_prepend_();
extern	Boolean 	DL_x_test_archive();
extern	Boolean 	DL_x_next_archive();
extern	Boolean 	DL_x_setup_buffers();
extern	void		DL_x_machine_reloc();
extern	Address 	DL_x_call_address();
extern	Integer 	DL_x_swap();
extern	void		DL_x_nm_command();
extern	void		DL_x_cc_command();
extern	void		DL_x_ld_command();
extern	Boolean 	DL_x_nm_read();
extern	String		DL_x_other_syms();
extern	Boolean 	DL_x_nm_element();
extern	Boolean 	DL_x_nm_extdata();
extern	Boolean 	DL_x_ignore_symbol();
extern	void		DL_x_lib_name();
extern	Boolean 	DL_x_check_arg();
extern	Boolean 	DL_x_gen_stub();





/* end of dl_local.h */
