/************************************************************************/
/*									*/
/*		dl.h							*/
/*									*/
/*	Global definitions for using dynamic loading			*/
/*									*/
/************************************************************************/
/*	Copyright 1987 Brown University -- Steven P. Reiss		*/


#ifndef DL_INCLUDED
#define DL_INCLUDED



/************************************************************************/
/*									*/
/*	Type definitions						*/
/*									*/
/************************************************************************/

typedef int (*DL_FunctionPtr)();





/************************************************************************/
/*									*/
/*	Function Definitions						*/
/*									*/
/************************************************************************/

extern	int		DLinit();

extern	DL_FunctionPtr	DLlookup();
				/* (char * function_name)		*/

extern	int		DLload();
				/* (char * pathname)			*/

extern	int		DLload_archive_element();
				/* (char * archive, * element)		*/

extern	int		DLnameof();
				/* (DL_FunctionPtr function,		*/
				/*    char * name, int maxlen)		*/

extern	void		DLprint_errors();
				/* (int flag)				*/

extern	void		DLload_on_demand_heuristics();
				/* (DL_FunctionPtr (*first)(),		*/
				/*	(*second)())			*/


#endif


/* end of dl.h */
