/************************************************************************/
/*									*/
/*		wormmain.c						*/
/*									*/
/*	Main program and routines for WORM object manager		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "worm_local.h"




/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	Boolean 	initialized = FALSE;

	PROT_DECL;





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	WORM_init -- system initialization				*/
/*									*/
/************************************************************************/


void
WORM_init()
{
   PROT_INIT;

   PROTECT(
      if (!initialized) {
	 initialized = TRUE;
	 WORM_type_init();
	 WORM_op_init();
	 WORM_base_init();
	 WORM_io_init();
	 WORM_type_private();
	 WORM_base_define();
       };
    );
};





/************************************************************************/
/*									*/
/*	WORM_error -- error messages					*/
/*									*/
/************************************************************************/


void
WORM_error(msg,a1,a2,a3)
   String msg;
   String a1,a2,a3;
{
   Character buf[1024];

   sprintf(buf,msg,a1,a2,a3);

   fprintf(stderr,"WORM: %s\n",buf);
   fflush(stderr);
};




/* end of wormmain.c */
