/************************************************************************/
/*									*/
/*		worm_local.h						*/
/*									*/
/*	Local definitions for the WORM object package			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/



#include "worm.h"
#include <DATATYPES.h>





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#ifdef sparc
#define DOUBLE_PAD
#endif




/************************************************************************/
/*									*/
/*	Lightweight process definitions 				*/
/*									*/
/************************************************************************/


#include <bwethread.h>

extern	THREAD_MONITOR	WORM__monitor;
#define PROT_DECL	THREAD_MONITOR WORM__monitor
#define PROT_INIT	if (USE_THREADS) WORM__monitor = THREADmonitorinit(0,NULL)
#define PROTECT(code)	{ THREAD_MANAGER_BLOCK tmb;			\
			  if (WORM__monitor != NULL)			\
			     THREADmonitorentry(WORM__monitor,&tmb);	\
			  code; 					\
			  if (WORM__monitor != NULL)			\
			     THREADmonitorexit(WORM__monitor);		\
			}





/************************************************************************/
/*									*/
/*	Type definitions						*/
/*									*/
/************************************************************************/


typedef struct _WORM_OPDEF *	WORM_OPDEF;

typedef struct _WORM_OP *	WORM_OP;
typedef struct _WORM_SUPER *	WORM_SUPER;




typedef struct _WORM_OBJ {		/* basic object 		*/
   WORM_TYPE	type;			/* type of object		*/
#ifdef DOUBLE_PAD
   Integer	pad0;
#endif
   WORM_UNIV	data[1];		/* data for object		*/
} WORM_OBJ_INFO;


typedef struct _WORM_OBJ_HEADER {	/* this must match WORM_OBJ	*/
   WORM_TYPE	type;
#ifdef DOUBLE_PAD
   Integer	pad0;
#endif
} WORM_OBJ_HEADER;






typedef struct _WORM_TYPE {
   WORM_OBJ_HEADER header;		/* header so type is an object	*/
   String	name;			/* name of object		*/
   Integer	total_len;		/* length for allocation	*/
   Integer	local_len;		/* length of local data 	*/
   Integer	data_offset;		/* offset to local data 	*/
   WORM_TYPE	next;			/* linked list of all types	*/
   Integer	numsuper;		/* number of supertypes 	*/
   WORM_SUPER	super;			/* super type array		*/
   Integer	numop;			/* number of operations 	*/
   WORM_OP	op;			/* table of operations		*/
   Universal *	dflt;			/* default values		*/
} WORM_TYPE_INFO;





typedef struct _WORM_OPDEF {
   String	name;			/* operation name		*/
   WORM_OPID	index;			/* index into op tables 	*/
   WORM_OPDEF	next;			/* linked list of ops		*/
} WORM_OPDEF_INFO;




typedef struct _WORM_SUPER {
   WORM_TYPE	type;			/* supertype			*/
   Integer	offset; 		/* offset for this type 	*/
} WORM_SUPER_INFO;




typedef struct _WORM_OP {
   Function_Ptr fct;			/* routine to handle operation	*/
   WORM_TYPE	base;			/* base type of operation	*/
   Short	numarg; 		/* number of arguments		*/
   Boolean	localdata;		/* pass local data flag 	*/
} WORM_OP_INFO;





/************************************************************************/
/*									*/
/*	Global storage							*/
/*									*/
/************************************************************************/


extern	WORM_TYPE	WORM__type_Any;
extern	WORM_TYPE	WORM__type_Type;

extern	WORM_OPID	WORM__op_Instance;
extern	WORM_OPID	WORM__op_Inittype;





/************************************************************************/
/*									*/
/*	Module entry points						*/
/*									*/
/************************************************************************/


					/* wormmain.c			*/
extern	void		WORM_init();
extern	void		WORM_error();



					/* wormtype.c			*/
extern	void		WORM_type_init();
extern	void		WORM_type_private();
extern	void		WORM_new_op();



					/* wormop.c			*/
extern	void		WORM_op_init();
extern	void		WORM_op_setup();
extern	void		WORM_op_enter();



					/* wormbase.c			*/
extern	void		WORM_base_init();
extern	void		WORM_base_define();



					/* wormio.c			*/
extern	void		WORM_io_init();





/* end of worm_local.h */

