/************************************************************************/
/*									*/
/*		worm.h							*/
/*									*/
/*	Definitions for using the WORM object package			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/



#ifndef WORM__INCLUDED
#define WORM__INCLUDED



/************************************************************************/
/*									*/
/*	Type definitions						*/
/*									*/
/************************************************************************/


typedef struct _WORM_OBJ *	WORM_OBJ;
typedef struct _WORM_TYPE *	WORM_TYPE;
typedef long int		WORM_OPID;

typedef int *			WORM_UNIV;



/********************************************************************************/
/*										*/
/*	Data structures and macros for I/O tables and routines			*/
/*										*/
/********************************************************************************/


typedef struct _WORM_READ_DATA {
   char * fieldname;
   int offset;
   char * type;
   char * base;
   char * query;
} WORM_READ_DATA;


typedef union _WORM_DIALOG_ARG {
   int intarg;
   char strarg[256];
   double fltarg;
} WORM_DIALOG_ARG;



#define WORM_QUERY_DEFAULT	0
#define WORM_QUERY_IGNORE	"^"
#define WORM_QUERY_NEST 	"@"



#define WORM_TYPE_OFFSET	(-1)
#define WORM_END_OFFSET 	(-2)
#define WORM_ENUM_OFFSET	(-3)





/********************************************************************************/
/*										*/
/*	For the following table macros, you should define a union called	*/
/*	DUMMY that contains componets called __<name> for each type name	*/
/*	that will be used as an internal field.  The pointer to this		*/
/*	structure is then passed to WORMset_io_table which will reset all	*/
/*	offsets accordingly.  This enables the table to contain pointers	*/
/*	to fields in this structure.						*/
/*										*/
/*	The table should end with 2 entries with offset WORM_END_OFFSET.	*/
/*										*/
/********************************************************************************/


#ifndef __STDC__
#define WORM_FIELD_OFF(base,name)	((int) (& DUMMY.__/**/base.name))
#else
#define WORM_FIELD_OFF(base,name)	((int) (& DUMMY.__ ## base.name))
#endif

#define WORM_TYPE_DEF(type)		{ "type", WORM_TYPE_OFFSET, 0, 0, 0 }
#define WORM_TYPE_QDF(type,qry) 	{ "type", WORM_TYPE_OFFSET, 0, 0, "qry" }
#define WORM_FIELD_DEF(base,name,type)	{ "name", WORM_FIELD_OFF(base,name), "type", "base", 0 }
#define WORM_FIELD_QDF(base,name,type,qry) { "name", WORM_FIELD_OFF(base,name), "type", "base", "qry" }
#define WORM_ENUM_DEF(name)		{ "name", WORM_ENUM_OFFSET, 0, 0, 0 }





/************************************************************************/
/*									*/
/*	Entry points							*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	WORM_TYPE		WORMtype_define();
extern	WORM_TYPE		WORMtype_find();
extern	WORM_OBJ		WORMinstance();
extern	WORM_UNIV		WORMaccess();
extern	char *			WORMinq_type_name();
extern	int			WORMinq_subtypes();

extern	WORM_OPID		WORMop_define();
extern	WORM_OPID		WORMop_find();
extern	WORM_UNIV		WORMapply();
extern	WORM_UNIV		WORMapply_type();

extern	void			WORMset_io_table();
extern	void			WORMread();
extern	void			WORMwrite_begin();
extern	void			WORMwrite();
extern	void			WORMwrite_end();
extern	int			WORMquery();
extern	int			WORMquery_field();
extern	WORM_OBJ		WORMquery_new();

#else

extern "C" {
	WORM_TYPE		WORMtype_define(char *,int ...);
	WORM_TYPE		WORMtype_find(char *);
	WORM_OBJ		WORMinstance(WORM_TYPE);
	WORM_UNIV		WORMaccess(WORM_TYPE,WORM_OBJ);
	char *			WORMinq_type_name(WORM_OBJ);
	int			WORMinq_subtypes(WORM_TYPE,int,char **);

	WORM_OPID		WORMop_define(char *,WORM_TYPE ...);
	WORM_OPID		WORMop_find(char *);
	WORM_UNIV		WORMapply(WORM_OPID,WORM_OBJ ...);
	WORM_UNIV		WORMapply_type(WORM_OPID,WORM_TYPE,WORM_OBJ ...);

	void			WORMset_io_table(WORM_READ_DATA * ...);
	void			WORMread(char * ...);
	void			WORMwrite_begin(...);
	void			WORMwrite(...);
	void			WORMwrite_end(...);
	int			WORMquery(ASH_WINDOW,WORM_OBJ);
	int			WORMquery_field(ASH_WINDOW,WORM_OBJ,char *);
	WORM_OBJ		WORMquery_new(ASH_WINDOW,char *,int);
};

#endif




/********************************************************************************/
/*										*/
/*	Usage macros								*/
/*										*/
/********************************************************************************/


#define WORMDEF(type,str,def)		WORMtype_define("type",sizeof(str),def,0)
#define WORMDEF1(type,str,def,sup)	WORMtype_define("type",sizeof(str),def,1,sup)
#define WORMDEF2(type,str,def,sp1,sp2)	WORMtype_define("type",sizeof(str),def,2,sp1,sp2)
#define WORMDEFN(type)			WORMtype_define("type",0,NULL,0)
#define WORMDEFN1(type,sup)		WORMtype_define("type",0,NULL,1,sup)

#define WORMAPPLY(type,msg,obj) 	((type) WORMapply(msg,obj))
#define WORMAPPLY1(type,msg,obj,a1)	((type) WORMapply(msg,obj,a1))
#define WORMAPPLY2(type,msg,obj,a1,a2)	((type) WORMapply(msg,obj,a1,a2))
#define WORMAPPLY3(type,msg,obj,a1,a2,a3) ((type) WORMapply(msg,obj,a1,a2,a3))




#endif

/* end of worm.h */
