/************************************************************************/
/*									*/
/*		windmain.c						*/
/*									*/
/*	Main entries for using WIND					*/
/*									*/
/************************************************************************/
/* COPYRIGHT 1988 BROWN UNIVERSITY.					*/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "wind_local.h"




/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	Boolean initedflag = FALSE;	   /* have we been inited	*/

static	Sequence     user_exit; 	   /* user exit function	*/

	PROT_DECL;




/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


#ifdef LIB
static	void		wind_cleanup_rtn();
#endif




/************************************************************************/
/*									*/
/*	WINDinit -- initialize wind					*/
/*									*/
/************************************************************************/


void
WINDinit()
{
   PROT_INIT;

   PROTECT;
   if (!initedflag) {
#ifdef LIB
      BROWNregister_cleanup(wind_cleanup_rtn);
#endif
      initedflag = TRUE;
      user_exit = NULL;

      WIND_control_init();
      WIND_act_init();
      WIND_defs_init();
      WIND_draw_init();
    };
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	WINDregister_exit -- record user function for cleanup		*/
/*									*/
/************************************************************************/


void
WINDregister_exit(fct)
   Function_Ptr fct;
{
   WINDinit();

   user_exit = CONS(fct,user_exit);
};





/************************************************************************/
/*									*/
/*	WIND_error -- handle wind error message 			*/
/*									*/
/************************************************************************/


void
WIND_error(msg,a1,a2,a3,a4)
   String msg;
{
   Character buf[1024];

   sprintf(buf,msg,a1,a2,a3,a4);

   fprintf(stderr,"WIND: ERROR: %s\n",buf);

   fflush(stderr);
};






/************************************************************************/
/*									*/
/*	WINDexit -- called to clean up and exit from the system 	*/
/*									*/
/************************************************************************/


int
WINDexit(sts)
   Integer sts;
{
   Function_Ptr ex;
   Sequence l;

   if (user_exit != NULL) {
      forin (ex,Function_Ptr,l,user_exit) {
	 (*ex)(sts);
       };
    };

   ASHexit();

   exit(sts);

   return FALSE;
};





/************************************************************************/
/*									*/
/*	wind_cleanup_rtn -- routine to reinitialize when in library	*/
/*									*/
/************************************************************************/


#ifdef LIB

static void
wind_cleanup_rtn()
{
   WIND__debugfg = 0;
   WIND__initedflag = FALSE;
};

#endif




/* end of windmain.c */
