/************************************************************************/
/*									*/
/*		winddraw.c						*/
/*									*/
/*	Routines for drawing selection window				*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "wind_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define SMALL_FONT		"fixed",10,ASH_FONT_ROMAN




/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


static	ASH_FONT	label_font;
static	ASH_FONT	button_font;

static	WIND_CTL      control;




/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	void		update_menus();
static	void		draw_selects();
static	int		wind_panel_btn();
static	int		wind_stem_btn();
static	void		check_windows();





/************************************************************************/
/*									*/
/*	LEAF and STEM definitions					*/
/*									*/
/************************************************************************/


#define MENU_WIN	1
#define DISPLAY_WIN	2
#define STATUS_WIN	3


static LEAF_DATA wind_ctl_leaf[] = {
   LEAF_ROOT(NULL),
   { MENU_WIN, LEAF_TYPE_PDM,
	{ LEAF_COORD_LX, LEAF_COORD_TEXT_LINE, LEAF_COORD_RX, LEAF_COORD_TY },
	NULL, NULL },
   { DISPLAY_WIN, LEAF_TYPE_WINDOW|LEAF_TYPE_UPPER_LEFT|LEAF_TYPE_INVISIBLE,
	{ LEAF_COORD_LX, LEAF_COORD_NEXT(STATUS_WIN),
	     LEAF_COORD_RX, LEAF_COORD_NEXT(MENU_WIN) },
	NULL, NULL },
   { STATUS_WIN, LEAF_TYPE_WINDOW|LEAF_TYPE_UPPER_LEFT,
	{ LEAF_COORD_LX, LEAF_COORD_BY, LEAF_COORD_RX, LEAF_COORD_TEXT_LINE },
	NULL, NULL },
   LEAF_END
};



static	STEM_PDM_DATA	ctl_menus[] = {
   { STEM_PSTATE_END }
};





/************************************************************************/
/*									*/
/*	WIND_draw_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
WIND_draw_init()
{
   label_font = ASHfont_id(SMALL_FONT);
   button_font = ASHloadfont(ASHinq_base_font());
   control = NULL;
};





/************************************************************************/
/*									*/
/*	WINDdraw_window -- get window to draw selections in		*/
/*									*/
/************************************************************************/


int
WINDdraw_window(rw)
   ASH_WINDOW rw;
{
   ASH_WINDOW w;
   String s;

   WINDinit();

   if (control != NULL) {
      ASHremove(control->window);
      control = NULL;
    };

   s = ASHinq_window_id(rw);
   ASHset_window_id(rw,"control");
   ASHset_window_defaults(rw);

   w = WINDsetup(rw);

   ASHset_window_id(rw,s);

   if (w == NULL) return FALSE;

   control = PALLOC(WIND_CTL_INFO);
   control->window = rw;
   control->ctl_window = w;
   control->menus = NULL;
   ASHset_window_name(w,"Control Panel");

   LEAFsetup_window(w,wind_ctl_leaf,control);
   LEAFredraw(w);

   control->menu_win = LEAFinq_window(w,MENU_WIN,0);
   control->select_win = LEAFinq_window(w,DISPLAY_WIN,0);
   control->status_win = LEAFinq_window(w,STATUS_WIN,0);

   if (control->menu_win == NULL || control->select_win == NULL ||
	  control->status_win == NULL) {
      fprintf(stderr,"WIND: Window too small do draw control panel\n");
      return FALSE;
    };

   ASHset_window_id(control->menu_win,"control");
   STEMpdm_define(control->menu_win,control,ctl_menus);

   ASHset_window_id(control->select_win,"control");
   STEMpanel_define(control->select_win,NULL,wind_panel_btn,NULL,
		       STEM_PANEL_SAME_SIZE);

   ASHset_window_id(control->status_win,"control");
   RIParea(RIP_AREA_STATUS,control->status_win);
   RIParea(RIP_AREA_PROMPT,control->status_win);
   RIParea(RIP_AREA_TYPEIN,control->status_win);

   WIND_draw_update();

   ASHvisible(control->select_win,TRUE);
   ASHvisible(w,TRUE);

   LEAFset_refresh(w,check_windows);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	WIND_draw_update -- update selection windows			*/
/*									*/
/************************************************************************/


void
WIND_draw_update()
{
   if (control == NULL) return;

   ASHbatch_mode(TRUE);
   update_menus(control);
   draw_selects(control->select_win);
   ASHbatch_mode(FALSE);
};





/************************************************************************/
/*									*/
/*	WIND_inq_control_window -- return control panel window		*/
/*									*/
/************************************************************************/


ASH_WINDOW
WIND_inq_control_window()
{
   return (control == NULL ? NULL : control->window);
};





/************************************************************************/
/*									*/
/*	update_menus -- update menus in control window			*/
/*									*/
/************************************************************************/


static void
update_menus(c)
   WIND_CTL c;
{
   Sequence l,la,lb;
   WIND_VIEW vws[64];
   Integer i,ct;
   WIND_MENU wm;
   WIND_BTN wb;

   if (c->menu_win == NULL) {
      if (c->menus != NULL) {
	 forin (wm,WIND_MENU,l,c->menus) {
	    forin (wb,WIND_BTN,la,wm->btns) free(wb);
	    free(wm);
	  };
	 LFREE(c->menus);
	 c->menus = NULL;
       };
      return;
    };

   ct = WIND_inq_views_menu(64,vws);

   if (c->menus != NULL) {
      forin (wm,WIND_MENU,l,c->menus) {
	 forin (wb,WIND_BTN,la,wm->btns) wb->used = FALSE;
       };
    };

   for (i = 0; i < ct; ++i) {
      forin (wm,WIND_MENU,l,c->menus) {
	 if (STREQL(wm->name,vws[i]->menuname)) break;
       };
      if (wm == NULL) {
	 STEMpdm_menu_add(c->menu_win,vws[i]->menuname);
	 wm = PALLOC(WIND_MENU_INFO);
	 wm->name = vws[i]->menuname;
	 wm->btns = NULL;
	 c->menus = APPEND(wm,c->menus);
       };
      forin (wb,WIND_BTN,l,wm->btns) {
	 if (STREQL(vws[i]->name,wb->name)) break;
       };
      if (wb == NULL) {
	 STEMpdm_btn_add(c->menu_win,vws[i]->menuname,vws[i]->name,wind_stem_btn);
	 wb = PALLOC(WIND_BTN_INFO);
	 wb->name = vws[i]->name;
	 wm->btns = APPEND(wb,wm->btns);
       };
      wb->used = TRUE;
    };

   forin (wm,WIND_MENU,l,c->menus) {
      lb = NULL;
      forin (wb,WIND_BTN,la,wm->btns) {
	 if (wb->used) lb = APPEND(wb,lb);
	 else {
	    STEMpdm_btn_remove(c->menu_win,wm->name,wb->name);
	  };
       };
      LFREE(wm->btns);
      wm->btns = lb;
    };
};





/************************************************************************/
/*									*/
/*	draw_selects -- draw the selection window			*/
/*									*/
/************************************************************************/


static void
draw_selects(w)
   ASH_WINDOW w;
{
   WIND_VIEW views[64],wv;
   STEM_PANEL_BTN btns[64];
   Character buf[256];
   Integer ct;
   Integer i;

   ct = WIND_inq_views_display(64,views);

   for (i = 0; i < ct; ++i) {
      wv = views[i];
      if (wv->icon == NULL) sprintf(buf,"\f%d\f%s",button_font,wv->name);
      else sprintf(buf,"\f%d\f%s\n\f%d\f%s",wv->iconfont,wv->icon,
		      label_font,wv->name);
      btns[i].text = SALLOC(buf);
      btns[i].color = NULL;
      btns[i].data = (int) wv;
    };
   btns[ct].text = NULL;

   STEMpanel_reset(w,btns);

   for (i = 0; i < ct; ++i) {
      SFREE(btns[i].text);
    };
};





/************************************************************************/
/*									*/
/*	wind_panel_btn -- handle hits to RIP regions in selection	  */
/*									*/
/************************************************************************/


static int
wind_panel_btn(wv)
   WIND_VIEW wv;
{
   if (wv == NULL) return FALSE;

   WIND_activate(wv,NULL,NULL);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	wind_stem_btn -- handle hits to STEM menus			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static int
wind_stem_btn(ctl,m,b)
   WIND_CTL ctl;
   String m;
   String b;
{
   WIND_VIEW vws[64];
   Integer i,ct;

   ct = WIND_inq_views_menu(64,vws);

   for (i = 0; i < ct; ++i) {
      if (STREQL(m,vws[i]->menuname) && STREQL(b,vws[i]->name)) {
	 WIND_activate(vws[i],NULL,NULL);
	 return TRUE;
       };
    };

   return FALSE;
};





/************************************************************************/
/*									*/
/*	check_windows -- check for user doing a stupid resize		*/
/*									*/
/************************************************************************/


static void
check_windows(w)
   ASH_WINDOW w;
{
   if (w != control->ctl_window) return;

   if (control->menu_win != LEAFinq_window(w,MENU_WIN,0) ||
	  control->select_win != LEAFinq_window(w,DISPLAY_WIN,0) ||
	  control->status_win != LEAFinq_window(w,STATUS_WIN,0)) {
      fprintf(stderr,"WIND: Control panel sized too small.\n");
      ASHremove(control->ctl_window);
    };
};






/* end of winddraw.c */

