/************************************************************************/
/*									*/
/*		wind_local.h						*/
/*									*/
/*	Local definitions for WIND window manager			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include <DATATYPES.h>

#define PROT_NAME	WIND__sema
#include <bwethread.h>
#include <sequence.h>

#include <ash.h>
#include <bio.h>
#include <rip.h>
#include <leaf.h>
#include <stem.h>
#include <wind.h>
#include <cmpx.h>




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	Data Types local to WIND					*/
/*									*/
/************************************************************************/


typedef THREAD			(*THREAD_FCT)();


typedef struct _WIND_WIN *    WIND_WIN;
typedef struct _WIND_VIEW *   WIND_VIEW;
typedef struct _WIND_CTL *    WIND_CTL;
typedef struct _WIND_MENU *   WIND_MENU;
typedef struct _WIND_BTN *    WIND_BTN;



typedef enum _WIND_SETUP_TYPE {
   WIND_SETUP_NONE,
   WIND_SETUP_BUTTONS,
   WIND_SETUP_SOLO,
} WIND_SETUP_TYPE;




typedef struct _WIND_WIN {		/* active window information	*/
   ASH_WINDOW window;
   ASH_WINDOW user_window;
   Boolean title;
} WIND_WIN_INFO;



typedef struct _WIND_VIEW {		/* window definition		*/
   String defname;			/*    name of definition	*/
   String name; 			/*    current display name	*/
   String icon; 			/*    icon for window		*/
   String origname;			/*    name given initially	*/
   Integer iconfont;			/*    icon font for window	*/
   String menuname;			/*    menu name 		*/
   WIND_FCT rtn;			/*    creation routine		*/
   String action;			/*    shell action		*/
   Boolean unique;			/*    one/many instance flag	*/
   ASH_WINDOW topwindow;		/*    top window		*/
   ASH_WINDOW window;			/*    user window		*/
   Integer pid; 			/*    process id		*/
   Boolean display;			/*    display flag		*/
   Boolean usethreads;			/*    use threads		*/
   Boolean nowindow;			/*    don't create window       */
   THREAD thread;			/*    control thread		*/
   RIP_REGION region;			/*    rip region		*/
   STEM_BTN btn;			/*    STEM_BTN id		*/
} WIND_VIEW_INFO;



typedef struct _WIND_CTL {		/* controlling information	*/
   ASH_WINDOW window;
   ASH_WINDOW ctl_window;
   ASH_WINDOW select_win;
   ASH_WINDOW menu_win;
   ASH_WINDOW status_win;
   Sequence menus;
} WIND_CTL_INFO;



typedef struct _WIND_MENU {
   String name;
   Sequence btns;
} WIND_MENU_INFO;



typedef struct _WIND_BTN {
   String name;
   Boolean used;
} WIND_BTN_INFO;




/************************************************************************/
/*									*/
/*	Global storage definitions					*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Internal Function Definitions					*/
/*									*/
/************************************************************************/


extern	void		WIND_error();
extern	void		WIND_exit();


extern	void		WIND_control_init();
extern	ASH_WINDOW	WIND_wind_window();
extern	void		WIND_control_active();


extern	void		WIND_act_init();


extern	void		WIND_defs_init();
extern	WIND_VIEW	WIND_activate();
extern	Integer 	WIND_inq_views_display();
extern	Integer 	WIND_inq_views_menu();


extern	void		WIND_draw_init();
extern	void		WIND_draw_update();
extern	ASH_WINDOW	WIND_inq_control_window();





/* end of wind_local.h */


