/************************************************************************/
/*									*/
/*		wind.h							*/
/*									*/
/*	External definitions for using wind				*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "ash.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	Data structures for table definitions				*/
/*									*/
/************************************************************************/


typedef int	(*WIND_FCT)();
typedef struct _WIND_DEF *    WIND_DEF;



typedef struct _WIND_DEF {		/* window/command definition	*/
   char * name; 			/*    name of window		*/
   WIND_FCT rtn;			/*    creation routine		*/
   char * action;			/*    shell action		*/
   char    unique;			/*    one/many instance flag	*/
   char    nogeneric;			/*    don't display generic     */
   char    usethreads;			/*    use threads on create	*/
   char    nowindow;			/*    no window--action only	*/
} WIND_DEF_INFO;




/************************************************************************/
/*									*/
/*	User-accessible routines					*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	void		WINDinit();
extern	void		WINDregister_exit();
extern	int		WINDexit();

extern	void		WINDset_setup_type();
extern	ASH_WINDOW	WINDsetup();
extern	ASH_WINDOW	WINDsetup_solo();
extern	ASH_WINDOW	WINDsetup_buttons();

extern	int		WINDact_move();
extern	int		WINDact_size();
extern	int		WINDact_push();
extern	int		WINDact_pop();
extern	int		WINDact_iconify();
extern	int		WINDact_remove();
extern	int		WINDact_enable();
extern	ASH_WINDOW	WINDact_new();

extern	void		WINDthread_init();
extern	void		WINDdefine();
extern	void		WINDregister_thread_fct();
extern	void		WINDthread_stack_size();
extern	void		WINDthread_priority();
extern	ASH_WINDOW	WINDactivate();

extern	int		WINDdraw_window();

#else

extern "C" {
	void		WINDinit();
	void		WINDregister_exit(...);
	int		WINDexit(int);

	void		WINDset_setup_type(char *);
	ASH_WINDOW	WINDsetup(ASH_WINDOW);
	ASH_WINDOW	WINDsetup_solo(ASH_WINDOW);
	ASH_WINDOW	WINDsetup_buttons(ASH_WINDOW);

	int		WINDact_move(ASH_WINDOW,int,int);
	int		WINDact_size(ASH_WINDOW,int,int);
	int		WINDact_push(ASH_WINDOW,int,int);
	int		WINDact_pop(ASH_WINDOW,int,int);
	int		WINDact_iconify(ASH_WINDOW,int,int);
	int		WINDact_remove(ASH_WINDOW,int,int);
	int		WINDact_enable(ASH_WINDOW,int);
	ASH_WINDOW	WINDact_new(ASH_WINDOW,char *);

	void		WINDthread_init();
	void		WINDdefine(WIND_DEF);
	void		WINDregister_thread_fct(...);
	void		WINDthread_stack_size(int);
	void		WINDthread_priority(int);
	ASH_WINDOW	WINDactivate(char *,char *,char *);

	int		WINDdraw_window(ASH_WINDOW);
};

#endif




/* end of wind.h */

