/************************************************************************/
/*									*/
/*		tulipuser.c						*/
/*									*/
/*	User entries for terminal utility package			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "tulip_local.h"






/************************************************************************/
/*									*/
/*	Parameter Definitions						*/
/*									*/
/************************************************************************/


#define CH_ESC		'\033'





/************************************************************************/
/*									*/
/*	Variable definitions						*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	void		output_buffer();




/************************************************************************/
/*									*/
/*	TULIP_user_init -- initialize this portion of tulip		*/
/*									*/
/************************************************************************/


void
TULIP_user_init()
{
   ITRACE("TULIP_user_init");
};






/************************************************************************/
/*									*/
/*	TULIPwrite -- output string to current terminal 		*/
/*									*/
/************************************************************************/


void
TULIPwrite(curtulip,txt)
   register TULIP_INFO curtulip;
   String txt;
{
   register Integer i,c;
   register Boolean flush;
   Character buf[256];

   ENTER("TULIPwrite");

   if (!T_PROTECT) return;

   ASHbatch_mode(TRUE);
   flush = TRUE;

   while ((c = *txt++) != 0) {
      c &= 0x7f;
      switch (INPUTSTATE) {
	 case TULIP_INPUT_BEGIN :
	    if (c == ' ' || isprint(c)) {
	       BUFFER[BUFCNT++] = c;
	       if (BUFCNT == STRING_BUF_SIZE-1) output_buffer(curtulip);
	     }
	    else if (c != CH_ESC) {
	       if (BUFCNT > 0) output_buffer(curtulip);
	       TULIP_control(curtulip,c);
	     }
	    else if (*txt == 'f') {
	       ++txt;
	       i = 0;
	       while (*txt > ' ') buf[i++] = *txt++;
	       if (*txt != 0) ++txt;
	       buf[i] = 0;
	       i = TULIP_getfont(buf);
	       sprintf(buf,"%d\n",i);
	       TULIP_saveinput(curtulip,buf);
	     }
	    else if (*txt == 'e') {
	       flush = FALSE;
	       ++txt;
	     }
	    else {
	       if (BUFCNT > 0) output_buffer(curtulip);
	       for (i = 0; i < NPARM; ++i) PARMS[i] = 0;
	       MODECHAR = 0;
	       NUMPARM = 0;
	       INPUTSTATE = TULIP_INPUT_ESCAPE;
	     };
	    break;

	 case TULIP_INPUT_ESCAPE :
	    if (c < ' ') INPUTSTATE = TULIP_INPUT_BEGIN;
	    else if (c == '[') INPUTSTATE = TULIP_INPUT_PARM;
	    else if (c < '@') {
	       MODECHAR = c;
	       INPUTSTATE = TULIP_INPUT_MODE;
	     }
	    else {
	       INPUTSTATE = TULIP_INPUT_BEGIN;
	       TULIP_escape(curtulip,c,MODECHAR,NUMPARM,PARMS);
	     };
	    break;

	 case TULIP_INPUT_MODE :
	    INPUTSTATE = TULIP_INPUT_BEGIN;
	    if (c >= ' ') TULIP_escape(curtulip,MODECHAR,c,NUMPARM,PARMS);
	    break;

	 case TULIP_INPUT_PARM :
	 case TULIP_INPUT_PARM1 :
	    if (isdigit(c)) {
	       PARMS[NUMPARM] = PARMS[NUMPARM]*10+(c-'0');
	       INPUTSTATE = TULIP_INPUT_PARM1;
	     }
	    else if (c == ';') ++NUMPARM;
	    else if (c < '@') {
	       MODECHAR = c;
	       INPUTSTATE = TULIP_INPUT_PARM1;
	     }
	    else {
	       if (NUMPARM != 0 || INPUTSTATE == TULIP_INPUT_PARM1) ++NUMPARM;
	       INPUTSTATE = TULIP_INPUT_BEGIN;
	       TULIP_escape(curtulip,c,MODECHAR,NUMPARM,PARMS);
	     };
	    break;
       };
    };

   if (BUFCNT != 0 && flush) output_buffer(curtulip);

   TULIP_set_cursor(curtulip,TRUE);
   ASHbatch_mode(FALSE);
   T_UNPROTECT;
};





/************************************************************************/
/*									*/
/*	TULIPread -- return data to user as required			*/
/*									*/
/************************************************************************/


int
TULIPread(curtulip,buf,ln)
   register TULIP_INFO curtulip;
   String buf;
   Integer ln;
{
   register Integer rln;

   ENTER("TULIPread 0x%x 0x%x %d",curtulip,buf,ln);

   if (READDATA == NULL) return 0;

   if (!T_PROTECT) return 0;

   --ln;
   rln = strlen(READDATA);
   if (ln > rln) ln = rln;

   if (ln >= 0) {
      strncpy(buf,READDATA,ln);
      buf[ln] = 0;
      if (READDATA[ln] != 0) {
	 strcpy(READDATA,&READDATA[ln]);
       }
      else {
	 free(READDATA);
	 READDATA = NULL;
       };
    };

   T_UNPROTECT;

   return ln;
};





/************************************************************************/
/*									*/
/*	TULIPprintf -- do a printf followed by TULIPwrite		*/
/*									*/
/************************************************************************/


/* VARARGS1 */

void
TULIPprintf(ti,s,a1,a2,a3,a4,a5,a6)
   TULIP_INFO ti;
   String s;
   Integer a1,a2,a3,a4,a5,a6;
{
   Character buf[256];

   sprintf(buf,s,a1,a2,a3,a4,a5,a6);

   TULIPwrite(ti,buf);
};





/************************************************************************/
/*									*/
/*	TULIP_saveinput -- save string for user TULIPread		*/
/*									*/
/************************************************************************/


#define MAX_BUFFER_SIZE 4096

void
TULIP_saveinput(curtulip,txt)
   register TULIP_INFO curtulip;
   String txt;
{
   Character buf[MAX_BUFFER_SIZE];

   ITRACE("TULIP_saveinput 0x%x %s",curtulip,txt);

   if (READDATA == NULL) {
      READDATA = SALLOC(txt);
    }
   else {
      if (strlen(READDATA)+strlen(txt) >= MAX_BUFFER_SIZE) {
	 ERROR(Too much input for TULIP);
	 return;
       };
      sprintf(buf,"%s%s",READDATA,txt);
      free(READDATA);
      READDATA = SALLOC(buf);
    };
};





/************************************************************************/
/*									*/
/*	output_buffer -- flush output buffer				*/
/*									*/
/************************************************************************/


static void
output_buffer(curtulip)
   register TULIP_INFO curtulip;
{
   DTRACE("output_buffer 0x%x",curtulip);

   if (BUFCNT == 1) {
      TULIP_outc(curtulip,BUFFER[0]);
      BUFCNT = 0;
    }
   else if (BUFCNT > 1) {
      BUFFER[BUFCNT] = 0;
      TULIP_outs(curtulip,BUFFER);
      BUFCNT = 0;
    };
};





/* end of tulipuser.c */

