/************************************************************************/
/*									*/
/*		tulip.h 						*/
/*									*/
/*	External definitions for terminal utility package		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "ash.h"



/************************************************************************/
/*									*/
/*	Types								*/
/*									*/
/************************************************************************/


typedef struct _TULIP_INFO *	TULIP_ID;





/************************************************************************/
/*									*/
/*	Tracing definitions						*/
/*									*/
/************************************************************************/


#define TULIP_TRACE_OFF        0
#define TULIP_TRACE_ON	       1
#define TULIP_TRACE_INT        2
#define TULIP_TRACE_DEBUG      4




/************************************************************************/
/*									*/
/*	External routines						*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	void		TULIPinit();
extern	void		TULIPtrace();
extern	void		TULIPset_limits();
extern	TULIP_ID	TULIPopen();
extern	void		TULIPclose();
extern	void		TULIPdefine_alternative();

extern	void		TULIPwrite();
extern	int		TULIPread();
extern	void		TULIPprintf();

extern	void		TULIPinq_size();
extern	void		TULIPinq_max_size();
extern	void		TULIPcorrelate();
extern	void		TULIPchar_delete();
extern	void		TULIPchar_insert();
extern	void		TULIPline_delete();
extern	void		TULIPline_insert();
extern	void		TULIPscroll_up();
extern	void		TULIPscroll_down();
extern	void		TULIPinsertmode();
extern	void		TULIPmove();
extern	void		TULIPmove_rel();
extern	void		TULIPfont_map();
extern	void		TULIPhighlight();
extern	void		TULIPerase_line();
extern	void		TULIPerase_screen();
extern	void		TULIPcursor();
extern	int		TULIPinq_font();

#else

extern "C" {
	void		TULIPinit();
	void		TULIPtrace(int);
	void		TULIPset_limits(int,int,int,int);
	TULIP_ID	TULIPopen(ASH_WINDOW);
	void		TULIPclose(TULIP_ID);
	void		TULIPdefine_alternative(TULIP_ID,int,TULIP_ID);

	void		TULIPwrite(TULIP_ID,char *);
	int		TULIPread(TULIP_ID,char *,int);
	void		TULIPprintf(TULIP_ID,char * ...);

	void		TULIPinq_size(TULIP_ID,int *,int *);
	void		TULIPcorrelate(TULIP_ID,int,int,int *,int *);
	void		TULIPchar_delete(TULIP_ID,int);
	void		TULIPchar_insert(TULIP_ID,int);
	void		TULIPline_delete(TULIP_ID,int);
	void		TULIPline_insert(TULIP_ID,int);
	void		TULIPscroll_up(TULIP_ID,int);
	void		TULIPscroll_down(TULIP_ID,int);
	void		TULIPinsertmode(TULIP_ID,int);
	void		TULIPmove(TULIP_ID,int,int);
	void		TULIPmove_rel(TULIP_ID,int,int);
	void		TULIPfont_map(TULIP_ID,int,int,int,int,int,int);
	void		TULIPhighlight(TULIP_ID,int,int,int,int,int,int,int);
	void		TULIPerase_line(TULIP_ID);
	void		TULIPerase_screen(TULIP_ID);
	void		TULIPcursor(TULIP_ID,int);
	int		TULIPinq_font(TULIP_ID);
};

#endif




/************************************************************************/
/*									*/
/*	Macros								*/
/*									*/
/************************************************************************/


#define VT_OUT(t,s) TULIPwrite(t,s)
#define VT_OUT1(t,s,a) TULIPprintf(t,s,a)
#define VT_OUT2(t,s,a1,a2) TULIPprintf(t,s,a1,a2)
#define VT_OUT3(t,s,a1,a2,a3) TULIPprintf(t,s,a1,a2,a3)
#define VT_OUT4(t,s,a1,a2,a3,a4) TULIPprintf(t,s,a1,a2,a3,a4)
#define VT_OUT5(t,s,a1,a2,a3,a4,a5) TULIPprintf(t,s,a1,a2,a3,a4,a5)
#define VT_OUT6(t,s,a1,a2,a3,a4,a5,a6) TULIPprintf(t,s,a1,a2,a3,a4,a5,a6)


#define VT_INSERTMODE(t)		TULIPinsertmode(t,TRUE)
#define VT_INS_CHAR(t,n)		TULIPchar_insert(t,(n))
#define VT_UP(t,n)			TULIPmove_rel(t,-(n),0)
#define VT_DOWN(t,n)			TULIPmove_rel(t,(n),0)
#define VT_RIGHT(t,n)			TULIPmove_rel(t,0,(n))
#define VT_LEFT(t,n)			TULIPmove_rel(t,0,-(n))
#define VT_REDRAW(t)			VT_OUT(t,"\033E")
#define VT_FONT(t,n)			VT_OUT1(t,"\033[%dF",n)
#define VT_SPACEFONT(t,n)		VT_OUT1(t,"\033[%dG",n)
#define VT_MOVE(t,a,b)			TULIPmove(t,(a),(b))
#define VT_RINDEX(t,n)			VT_OUT1(t,"\033[%dI",n)
#define VT_ERASE_SCREEN(t)		TULIPerase_screen(t)
#define VT_ERASE_LINE(t)		TULIPerase_line(t)
#define VT_INS_LINE(t,n)		TULIPline_insert(t,n)
#define VT_DEL_LINE(t,n)		TULIPline_delete(t,n)
#define VT_DEL_CHAR(t,n)		TULIPchar_delete(t,n)
#define VT_ENDINSERTMODE(t)		TULIPinsertmode(t,FALSE)
#define VT_MAP(t,a,b,c,dd,e,f)		TULIPfont_map(t,(a),(b),(c),(dd),(e),(f))
#define VT_MOVE_ABS(t,x,y)		VT_OUT2(t,"\033[%d;%dW",x,y)
#define VT_ALTERNATIVE(t)		VT_OUT(t,"\033a")


#define VT_CURSOR(t,n)			VT_OUT1(t,"\033[>5%c",(n ? 'l' : 'h'))
#define VT_SCROLL(t)			VT_OUT(t,"\033!1")
#define VT_NO_SCROLL(t) 		VT_OUT(t,"\033!0")
#define VT_NO_NLCLEAR(t)		VT_OUT(t,"\033#0")
#define VT_NLCLEAR(t)			VT_OUT(t,"\033#1")
#define VT_NO_BSCLEAR(t)		VT_OUT(t,"\033#2")
#define VT_BSCLEAR(t)			VT_OUT(t,"\033#3")
#define VT_NO_TABCLEAR(t)		VT_OUT(t,"\033#4")
#define VT_TABCLEAR(t)			VT_OUT(t,"\033#5")
#define VT_WRAP(t)			VT_OUT(t,"\033!3")
#define VT_NO_WRAP(t)			VT_OUT(t,"\033!2")
#define VT_DISCARD(t)			VT_OUT(t,"\033!5")
#define VT_NO_DISCARD(t)		VT_OUT(t,"\033!4")
#define VT_FIXED(t)			VT_OUT(t,"\033[>10h")
#define VT_NO_FIXED(t)			VT_OUT(t,"\033[>10l")
#define VT_ABSOLUTE(t)			VT_OUT(t,"\033)1")
#define VT_RELATIVE(t)			VT_OUT(t,"\033)0")






/* end of tulip.h */

